<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSystemRoleTicketQueueType Array
 * @subpackage Arrays
 */
class ArrayOfSystemRoleTicketQueueType extends AbstractStructArrayBase
{
    /**
     * The SystemRoleTicketQueueType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\SystemRoleTicketQueueType[]
     */
    public $SystemRoleTicketQueueType;
    /**
     * Constructor method for ArrayOfSystemRoleTicketQueueType
     * @uses ArrayOfSystemRoleTicketQueueType::setSystemRoleTicketQueueType()
     * @param \SGCIS\Struct\SystemRoleTicketQueueType[] $systemRoleTicketQueueType
     */
    public function __construct(array $systemRoleTicketQueueType = array())
    {
        $this
            ->setSystemRoleTicketQueueType($systemRoleTicketQueueType);
    }
    /**
     * Get SystemRoleTicketQueueType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\SystemRoleTicketQueueType[]|null
     */
    public function getSystemRoleTicketQueueType()
    {
        return isset($this->SystemRoleTicketQueueType) ? $this->SystemRoleTicketQueueType : null;
    }
    /**
     * Set SystemRoleTicketQueueType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\SystemRoleTicketQueueType[] $systemRoleTicketQueueType
     * @return \SGCIS\Array\ArrayOfSystemRoleTicketQueueType
     */
    public function setSystemRoleTicketQueueType(array $systemRoleTicketQueueType = array())
    {
        foreach ($systemRoleTicketQueueType as $arrayOfSystemRoleTicketQueueTypeSystemRoleTicketQueueTypeItem) {
            // validation for constraint: itemType
            if (!$arrayOfSystemRoleTicketQueueTypeSystemRoleTicketQueueTypeItem instanceof \SGCIS\Struct\SystemRoleTicketQueueType) {
                throw new \InvalidArgumentException(sprintf('The SystemRoleTicketQueueType property can only contain items of \SGCIS\Struct\SystemRoleTicketQueueType, "%s" given', is_object($arrayOfSystemRoleTicketQueueTypeSystemRoleTicketQueueTypeItem) ? get_class($arrayOfSystemRoleTicketQueueTypeSystemRoleTicketQueueTypeItem) : gettype($arrayOfSystemRoleTicketQueueTypeSystemRoleTicketQueueTypeItem)), __LINE__);
            }
        }
        if (is_null($systemRoleTicketQueueType) || (is_array($systemRoleTicketQueueType) && empty($systemRoleTicketQueueType))) {
            unset($this->SystemRoleTicketQueueType);
        } else {
            $this->SystemRoleTicketQueueType = $systemRoleTicketQueueType;
        }
        return $this;
    }
    /**
     * Add item to SystemRoleTicketQueueType value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\SystemRoleTicketQueueType $item
     * @return \SGCIS\Array\ArrayOfSystemRoleTicketQueueType
     */
    public function addToSystemRoleTicketQueueType(\SGCIS\Struct\SystemRoleTicketQueueType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\SystemRoleTicketQueueType) {
            throw new \InvalidArgumentException(sprintf('The SystemRoleTicketQueueType property can only contain items of \SGCIS\Struct\SystemRoleTicketQueueType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SystemRoleTicketQueueType[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\SystemRoleTicketQueueType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\SystemRoleTicketQueueType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\SystemRoleTicketQueueType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\SystemRoleTicketQueueType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\SystemRoleTicketQueueType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SystemRoleTicketQueueType
     */
    public function getAttributeName()
    {
        return 'SystemRoleTicketQueueType';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfSystemRoleTicketQueueType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
