<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSystemRoleApplicationFunction Array
 * @subpackage Arrays
 */
class ArrayOfSystemRoleApplicationFunction extends AbstractStructArrayBase
{
    /**
     * The SystemRoleApplicationFunction
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\SystemRoleApplicationFunction[]
     */
    public $SystemRoleApplicationFunction;
    /**
     * Constructor method for ArrayOfSystemRoleApplicationFunction
     * @uses ArrayOfSystemRoleApplicationFunction::setSystemRoleApplicationFunction()
     * @param \SGCIS\Struct\SystemRoleApplicationFunction[] $systemRoleApplicationFunction
     */
    public function __construct(array $systemRoleApplicationFunction = array())
    {
        $this
            ->setSystemRoleApplicationFunction($systemRoleApplicationFunction);
    }
    /**
     * Get SystemRoleApplicationFunction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\SystemRoleApplicationFunction[]|null
     */
    public function getSystemRoleApplicationFunction()
    {
        return isset($this->SystemRoleApplicationFunction) ? $this->SystemRoleApplicationFunction : null;
    }
    /**
     * Set SystemRoleApplicationFunction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\SystemRoleApplicationFunction[] $systemRoleApplicationFunction
     * @return \SGCIS\Array\ArrayOfSystemRoleApplicationFunction
     */
    public function setSystemRoleApplicationFunction(array $systemRoleApplicationFunction = array())
    {
        foreach ($systemRoleApplicationFunction as $arrayOfSystemRoleApplicationFunctionSystemRoleApplicationFunctionItem) {
            // validation for constraint: itemType
            if (!$arrayOfSystemRoleApplicationFunctionSystemRoleApplicationFunctionItem instanceof \SGCIS\Struct\SystemRoleApplicationFunction) {
                throw new \InvalidArgumentException(sprintf('The SystemRoleApplicationFunction property can only contain items of \SGCIS\Struct\SystemRoleApplicationFunction, "%s" given', is_object($arrayOfSystemRoleApplicationFunctionSystemRoleApplicationFunctionItem) ? get_class($arrayOfSystemRoleApplicationFunctionSystemRoleApplicationFunctionItem) : gettype($arrayOfSystemRoleApplicationFunctionSystemRoleApplicationFunctionItem)), __LINE__);
            }
        }
        if (is_null($systemRoleApplicationFunction) || (is_array($systemRoleApplicationFunction) && empty($systemRoleApplicationFunction))) {
            unset($this->SystemRoleApplicationFunction);
        } else {
            $this->SystemRoleApplicationFunction = $systemRoleApplicationFunction;
        }
        return $this;
    }
    /**
     * Add item to SystemRoleApplicationFunction value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\SystemRoleApplicationFunction $item
     * @return \SGCIS\Array\ArrayOfSystemRoleApplicationFunction
     */
    public function addToSystemRoleApplicationFunction(\SGCIS\Struct\SystemRoleApplicationFunction $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\SystemRoleApplicationFunction) {
            throw new \InvalidArgumentException(sprintf('The SystemRoleApplicationFunction property can only contain items of \SGCIS\Struct\SystemRoleApplicationFunction, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SystemRoleApplicationFunction[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\SystemRoleApplicationFunction|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\SystemRoleApplicationFunction|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\SystemRoleApplicationFunction|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\SystemRoleApplicationFunction|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\SystemRoleApplicationFunction|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SystemRoleApplicationFunction
     */
    public function getAttributeName()
    {
        return 'SystemRoleApplicationFunction';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfSystemRoleApplicationFunction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
