<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSystemEvent Array
 * @subpackage Arrays
 */
class ArrayOfSystemEvent extends AbstractStructArrayBase
{
    /**
     * The SystemEvent
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\SystemEvent[]
     */
    public $SystemEvent;
    /**
     * Constructor method for ArrayOfSystemEvent
     * @uses ArrayOfSystemEvent::setSystemEvent()
     * @param \SGCIS\Struct\SystemEvent[] $systemEvent
     */
    public function __construct(array $systemEvent = array())
    {
        $this
            ->setSystemEvent($systemEvent);
    }
    /**
     * Get SystemEvent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\SystemEvent[]|null
     */
    public function getSystemEvent()
    {
        return isset($this->SystemEvent) ? $this->SystemEvent : null;
    }
    /**
     * Set SystemEvent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\SystemEvent[] $systemEvent
     * @return \SGCIS\Array\ArrayOfSystemEvent
     */
    public function setSystemEvent(array $systemEvent = array())
    {
        foreach ($systemEvent as $arrayOfSystemEventSystemEventItem) {
            // validation for constraint: itemType
            if (!$arrayOfSystemEventSystemEventItem instanceof \SGCIS\Struct\SystemEvent) {
                throw new \InvalidArgumentException(sprintf('The SystemEvent property can only contain items of \SGCIS\Struct\SystemEvent, "%s" given', is_object($arrayOfSystemEventSystemEventItem) ? get_class($arrayOfSystemEventSystemEventItem) : gettype($arrayOfSystemEventSystemEventItem)), __LINE__);
            }
        }
        if (is_null($systemEvent) || (is_array($systemEvent) && empty($systemEvent))) {
            unset($this->SystemEvent);
        } else {
            $this->SystemEvent = $systemEvent;
        }
        return $this;
    }
    /**
     * Add item to SystemEvent value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\SystemEvent $item
     * @return \SGCIS\Array\ArrayOfSystemEvent
     */
    public function addToSystemEvent(\SGCIS\Struct\SystemEvent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\SystemEvent) {
            throw new \InvalidArgumentException(sprintf('The SystemEvent property can only contain items of \SGCIS\Struct\SystemEvent, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SystemEvent[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\SystemEvent|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\SystemEvent|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\SystemEvent|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\SystemEvent|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\SystemEvent|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SystemEvent
     */
    public function getAttributeName()
    {
        return 'SystemEvent';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfSystemEvent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
