<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfServiceAgreement Array
 * @subpackage Arrays
 */
class ArrayOfServiceAgreement extends AbstractStructArrayBase
{
    /**
     * The ServiceAgreement
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\ServiceAgreement[]
     */
    public $ServiceAgreement;
    /**
     * Constructor method for ArrayOfServiceAgreement
     * @uses ArrayOfServiceAgreement::setServiceAgreement()
     * @param \SGCIS\Struct\ServiceAgreement[] $serviceAgreement
     */
    public function __construct(array $serviceAgreement = array())
    {
        $this
            ->setServiceAgreement($serviceAgreement);
    }
    /**
     * Get ServiceAgreement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\ServiceAgreement[]|null
     */
    public function getServiceAgreement()
    {
        return isset($this->ServiceAgreement) ? $this->ServiceAgreement : null;
    }
    /**
     * Set ServiceAgreement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\ServiceAgreement[] $serviceAgreement
     * @return \SGCIS\Array\ArrayOfServiceAgreement
     */
    public function setServiceAgreement(array $serviceAgreement = array())
    {
        foreach ($serviceAgreement as $arrayOfServiceAgreementServiceAgreementItem) {
            // validation for constraint: itemType
            if (!$arrayOfServiceAgreementServiceAgreementItem instanceof \SGCIS\Struct\ServiceAgreement) {
                throw new \InvalidArgumentException(sprintf('The ServiceAgreement property can only contain items of \SGCIS\Struct\ServiceAgreement, "%s" given', is_object($arrayOfServiceAgreementServiceAgreementItem) ? get_class($arrayOfServiceAgreementServiceAgreementItem) : gettype($arrayOfServiceAgreementServiceAgreementItem)), __LINE__);
            }
        }
        if (is_null($serviceAgreement) || (is_array($serviceAgreement) && empty($serviceAgreement))) {
            unset($this->ServiceAgreement);
        } else {
            $this->ServiceAgreement = $serviceAgreement;
        }
        return $this;
    }
    /**
     * Add item to ServiceAgreement value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\ServiceAgreement $item
     * @return \SGCIS\Array\ArrayOfServiceAgreement
     */
    public function addToServiceAgreement(\SGCIS\Struct\ServiceAgreement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\ServiceAgreement) {
            throw new \InvalidArgumentException(sprintf('The ServiceAgreement property can only contain items of \SGCIS\Struct\ServiceAgreement, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ServiceAgreement[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\ServiceAgreement|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\ServiceAgreement|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\ServiceAgreement|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\ServiceAgreement|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\ServiceAgreement|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ServiceAgreement
     */
    public function getAttributeName()
    {
        return 'ServiceAgreement';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfServiceAgreement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
