<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPerson Array
 * @subpackage Arrays
 */
class ArrayOfPerson extends AbstractStructArrayBase
{
    /**
     * The Person
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\Person[]
     */
    public $Person;
    /**
     * Constructor method for ArrayOfPerson
     * @uses ArrayOfPerson::setPerson()
     * @param \SGCIS\Struct\Person[] $person
     */
    public function __construct(array $person = array())
    {
        $this
            ->setPerson($person);
    }
    /**
     * Get Person value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\Person[]|null
     */
    public function getPerson()
    {
        return isset($this->Person) ? $this->Person : null;
    }
    /**
     * Set Person value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\Person[] $person
     * @return \SGCIS\Array\ArrayOfPerson
     */
    public function setPerson(array $person = array())
    {
        foreach ($person as $arrayOfPersonPersonItem) {
            // validation for constraint: itemType
            if (!$arrayOfPersonPersonItem instanceof \SGCIS\Struct\Person) {
                throw new \InvalidArgumentException(sprintf('The Person property can only contain items of \SGCIS\Struct\Person, "%s" given', is_object($arrayOfPersonPersonItem) ? get_class($arrayOfPersonPersonItem) : gettype($arrayOfPersonPersonItem)), __LINE__);
            }
        }
        if (is_null($person) || (is_array($person) && empty($person))) {
            unset($this->Person);
        } else {
            $this->Person = $person;
        }
        return $this;
    }
    /**
     * Add item to Person value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\Person $item
     * @return \SGCIS\Array\ArrayOfPerson
     */
    public function addToPerson(\SGCIS\Struct\Person $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\Person) {
            throw new \InvalidArgumentException(sprintf('The Person property can only contain items of \SGCIS\Struct\Person, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Person[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\Person|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\Person|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\Person|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\Person|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\Person|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Person
     */
    public function getAttributeName()
    {
        return 'Person';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfPerson
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
