<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPaymentTenderType Array
 * @subpackage Arrays
 */
class ArrayOfPaymentTenderType extends AbstractStructArrayBase
{
    /**
     * The PaymentTenderType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\PaymentTenderType[]
     */
    public $PaymentTenderType;
    /**
     * Constructor method for ArrayOfPaymentTenderType
     * @uses ArrayOfPaymentTenderType::setPaymentTenderType()
     * @param \SGCIS\Struct\PaymentTenderType[] $paymentTenderType
     */
    public function __construct(array $paymentTenderType = array())
    {
        $this
            ->setPaymentTenderType($paymentTenderType);
    }
    /**
     * Get PaymentTenderType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\PaymentTenderType[]|null
     */
    public function getPaymentTenderType()
    {
        return isset($this->PaymentTenderType) ? $this->PaymentTenderType : null;
    }
    /**
     * Set PaymentTenderType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\PaymentTenderType[] $paymentTenderType
     * @return \SGCIS\Array\ArrayOfPaymentTenderType
     */
    public function setPaymentTenderType(array $paymentTenderType = array())
    {
        foreach ($paymentTenderType as $arrayOfPaymentTenderTypePaymentTenderTypeItem) {
            // validation for constraint: itemType
            if (!$arrayOfPaymentTenderTypePaymentTenderTypeItem instanceof \SGCIS\Struct\PaymentTenderType) {
                throw new \InvalidArgumentException(sprintf('The PaymentTenderType property can only contain items of \SGCIS\Struct\PaymentTenderType, "%s" given', is_object($arrayOfPaymentTenderTypePaymentTenderTypeItem) ? get_class($arrayOfPaymentTenderTypePaymentTenderTypeItem) : gettype($arrayOfPaymentTenderTypePaymentTenderTypeItem)), __LINE__);
            }
        }
        if (is_null($paymentTenderType) || (is_array($paymentTenderType) && empty($paymentTenderType))) {
            unset($this->PaymentTenderType);
        } else {
            $this->PaymentTenderType = $paymentTenderType;
        }
        return $this;
    }
    /**
     * Add item to PaymentTenderType value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\PaymentTenderType $item
     * @return \SGCIS\Array\ArrayOfPaymentTenderType
     */
    public function addToPaymentTenderType(\SGCIS\Struct\PaymentTenderType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\PaymentTenderType) {
            throw new \InvalidArgumentException(sprintf('The PaymentTenderType property can only contain items of \SGCIS\Struct\PaymentTenderType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentTenderType[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\PaymentTenderType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\PaymentTenderType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\PaymentTenderType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\PaymentTenderType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\PaymentTenderType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PaymentTenderType
     */
    public function getAttributeName()
    {
        return 'PaymentTenderType';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfPaymentTenderType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
