<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPaymentAccount Array
 * @subpackage Arrays
 */
class ArrayOfPaymentAccount extends AbstractStructArrayBase
{
    /**
     * The PaymentAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\PaymentAccount[]
     */
    public $PaymentAccount;
    /**
     * Constructor method for ArrayOfPaymentAccount
     * @uses ArrayOfPaymentAccount::setPaymentAccount()
     * @param \SGCIS\Struct\PaymentAccount[] $paymentAccount
     */
    public function __construct(array $paymentAccount = array())
    {
        $this
            ->setPaymentAccount($paymentAccount);
    }
    /**
     * Get PaymentAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\PaymentAccount[]|null
     */
    public function getPaymentAccount()
    {
        return isset($this->PaymentAccount) ? $this->PaymentAccount : null;
    }
    /**
     * Set PaymentAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\PaymentAccount[] $paymentAccount
     * @return \SGCIS\Array\ArrayOfPaymentAccount
     */
    public function setPaymentAccount(array $paymentAccount = array())
    {
        foreach ($paymentAccount as $arrayOfPaymentAccountPaymentAccountItem) {
            // validation for constraint: itemType
            if (!$arrayOfPaymentAccountPaymentAccountItem instanceof \SGCIS\Struct\PaymentAccount) {
                throw new \InvalidArgumentException(sprintf('The PaymentAccount property can only contain items of \SGCIS\Struct\PaymentAccount, "%s" given', is_object($arrayOfPaymentAccountPaymentAccountItem) ? get_class($arrayOfPaymentAccountPaymentAccountItem) : gettype($arrayOfPaymentAccountPaymentAccountItem)), __LINE__);
            }
        }
        if (is_null($paymentAccount) || (is_array($paymentAccount) && empty($paymentAccount))) {
            unset($this->PaymentAccount);
        } else {
            $this->PaymentAccount = $paymentAccount;
        }
        return $this;
    }
    /**
     * Add item to PaymentAccount value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\PaymentAccount $item
     * @return \SGCIS\Array\ArrayOfPaymentAccount
     */
    public function addToPaymentAccount(\SGCIS\Struct\PaymentAccount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\PaymentAccount) {
            throw new \InvalidArgumentException(sprintf('The PaymentAccount property can only contain items of \SGCIS\Struct\PaymentAccount, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentAccount[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\PaymentAccount|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\PaymentAccount|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\PaymentAccount|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\PaymentAccount|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\PaymentAccount|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PaymentAccount
     */
    public function getAttributeName()
    {
        return 'PaymentAccount';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfPaymentAccount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
