<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCommunity Array
 * @subpackage Arrays
 */
class ArrayOfCommunity extends AbstractStructArrayBase
{
    /**
     * The Community
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\Community[]
     */
    public $Community;
    /**
     * Constructor method for ArrayOfCommunity
     * @uses ArrayOfCommunity::setCommunity()
     * @param \SGCIS\Struct\Community[] $community
     */
    public function __construct(array $community = array())
    {
        $this
            ->setCommunity($community);
    }
    /**
     * Get Community value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\Community[]|null
     */
    public function getCommunity()
    {
        return isset($this->Community) ? $this->Community : null;
    }
    /**
     * Set Community value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\Community[] $community
     * @return \SGCIS\Array\ArrayOfCommunity
     */
    public function setCommunity(array $community = array())
    {
        foreach ($community as $arrayOfCommunityCommunityItem) {
            // validation for constraint: itemType
            if (!$arrayOfCommunityCommunityItem instanceof \SGCIS\Struct\Community) {
                throw new \InvalidArgumentException(sprintf('The Community property can only contain items of \SGCIS\Struct\Community, "%s" given', is_object($arrayOfCommunityCommunityItem) ? get_class($arrayOfCommunityCommunityItem) : gettype($arrayOfCommunityCommunityItem)), __LINE__);
            }
        }
        if (is_null($community) || (is_array($community) && empty($community))) {
            unset($this->Community);
        } else {
            $this->Community = $community;
        }
        return $this;
    }
    /**
     * Add item to Community value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\Community $item
     * @return \SGCIS\Array\ArrayOfCommunity
     */
    public function addToCommunity(\SGCIS\Struct\Community $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\Community) {
            throw new \InvalidArgumentException(sprintf('The Community property can only contain items of \SGCIS\Struct\Community, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Community[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\Community|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\Community|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\Community|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\Community|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\Community|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Community
     */
    public function getAttributeName()
    {
        return 'Community';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfCommunity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
