<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfChargeTier Array
 * @subpackage Arrays
 */
class ArrayOfChargeTier extends AbstractStructArrayBase
{
    /**
     * The ChargeTier
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\ChargeTier[]
     */
    public $ChargeTier;
    /**
     * Constructor method for ArrayOfChargeTier
     * @uses ArrayOfChargeTier::setChargeTier()
     * @param \SGCIS\Struct\ChargeTier[] $chargeTier
     */
    public function __construct(array $chargeTier = array())
    {
        $this
            ->setChargeTier($chargeTier);
    }
    /**
     * Get ChargeTier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\ChargeTier[]|null
     */
    public function getChargeTier()
    {
        return isset($this->ChargeTier) ? $this->ChargeTier : null;
    }
    /**
     * Set ChargeTier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\ChargeTier[] $chargeTier
     * @return \SGCIS\Array\ArrayOfChargeTier
     */
    public function setChargeTier(array $chargeTier = array())
    {
        foreach ($chargeTier as $arrayOfChargeTierChargeTierItem) {
            // validation for constraint: itemType
            if (!$arrayOfChargeTierChargeTierItem instanceof \SGCIS\Struct\ChargeTier) {
                throw new \InvalidArgumentException(sprintf('The ChargeTier property can only contain items of \SGCIS\Struct\ChargeTier, "%s" given', is_object($arrayOfChargeTierChargeTierItem) ? get_class($arrayOfChargeTierChargeTierItem) : gettype($arrayOfChargeTierChargeTierItem)), __LINE__);
            }
        }
        if (is_null($chargeTier) || (is_array($chargeTier) && empty($chargeTier))) {
            unset($this->ChargeTier);
        } else {
            $this->ChargeTier = $chargeTier;
        }
        return $this;
    }
    /**
     * Add item to ChargeTier value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\ChargeTier $item
     * @return \SGCIS\Array\ArrayOfChargeTier
     */
    public function addToChargeTier(\SGCIS\Struct\ChargeTier $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\ChargeTier) {
            throw new \InvalidArgumentException(sprintf('The ChargeTier property can only contain items of \SGCIS\Struct\ChargeTier, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ChargeTier[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\ChargeTier|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\ChargeTier|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\ChargeTier|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\ChargeTier|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\ChargeTier|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ChargeTier
     */
    public function getAttributeName()
    {
        return 'ChargeTier';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfChargeTier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
