<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfChargeAccountType Array
 * @subpackage Arrays
 */
class ArrayOfChargeAccountType extends AbstractStructArrayBase
{
    /**
     * The ChargeAccountType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\ChargeAccountType[]
     */
    public $ChargeAccountType;
    /**
     * Constructor method for ArrayOfChargeAccountType
     * @uses ArrayOfChargeAccountType::setChargeAccountType()
     * @param \SGCIS\Struct\ChargeAccountType[] $chargeAccountType
     */
    public function __construct(array $chargeAccountType = array())
    {
        $this
            ->setChargeAccountType($chargeAccountType);
    }
    /**
     * Get ChargeAccountType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\ChargeAccountType[]|null
     */
    public function getChargeAccountType()
    {
        return isset($this->ChargeAccountType) ? $this->ChargeAccountType : null;
    }
    /**
     * Set ChargeAccountType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\ChargeAccountType[] $chargeAccountType
     * @return \SGCIS\Array\ArrayOfChargeAccountType
     */
    public function setChargeAccountType(array $chargeAccountType = array())
    {
        foreach ($chargeAccountType as $arrayOfChargeAccountTypeChargeAccountTypeItem) {
            // validation for constraint: itemType
            if (!$arrayOfChargeAccountTypeChargeAccountTypeItem instanceof \SGCIS\Struct\ChargeAccountType) {
                throw new \InvalidArgumentException(sprintf('The ChargeAccountType property can only contain items of \SGCIS\Struct\ChargeAccountType, "%s" given', is_object($arrayOfChargeAccountTypeChargeAccountTypeItem) ? get_class($arrayOfChargeAccountTypeChargeAccountTypeItem) : gettype($arrayOfChargeAccountTypeChargeAccountTypeItem)), __LINE__);
            }
        }
        if (is_null($chargeAccountType) || (is_array($chargeAccountType) && empty($chargeAccountType))) {
            unset($this->ChargeAccountType);
        } else {
            $this->ChargeAccountType = $chargeAccountType;
        }
        return $this;
    }
    /**
     * Add item to ChargeAccountType value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\ChargeAccountType $item
     * @return \SGCIS\Array\ArrayOfChargeAccountType
     */
    public function addToChargeAccountType(\SGCIS\Struct\ChargeAccountType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\ChargeAccountType) {
            throw new \InvalidArgumentException(sprintf('The ChargeAccountType property can only contain items of \SGCIS\Struct\ChargeAccountType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ChargeAccountType[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\ChargeAccountType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\ChargeAccountType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\ChargeAccountType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\ChargeAccountType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\ChargeAccountType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ChargeAccountType
     */
    public function getAttributeName()
    {
        return 'ChargeAccountType';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfChargeAccountType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
