<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBudgetBillMonthlyAmount Array
 * @subpackage Arrays
 */
class ArrayOfBudgetBillMonthlyAmount extends AbstractStructArrayBase
{
    /**
     * The BudgetBillMonthlyAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\BudgetBillMonthlyAmount[]
     */
    public $BudgetBillMonthlyAmount;
    /**
     * Constructor method for ArrayOfBudgetBillMonthlyAmount
     * @uses ArrayOfBudgetBillMonthlyAmount::setBudgetBillMonthlyAmount()
     * @param \SGCIS\Struct\BudgetBillMonthlyAmount[] $budgetBillMonthlyAmount
     */
    public function __construct(array $budgetBillMonthlyAmount = array())
    {
        $this
            ->setBudgetBillMonthlyAmount($budgetBillMonthlyAmount);
    }
    /**
     * Get BudgetBillMonthlyAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\BudgetBillMonthlyAmount[]|null
     */
    public function getBudgetBillMonthlyAmount()
    {
        return isset($this->BudgetBillMonthlyAmount) ? $this->BudgetBillMonthlyAmount : null;
    }
    /**
     * Set BudgetBillMonthlyAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\BudgetBillMonthlyAmount[] $budgetBillMonthlyAmount
     * @return \SGCIS\Array\ArrayOfBudgetBillMonthlyAmount
     */
    public function setBudgetBillMonthlyAmount(array $budgetBillMonthlyAmount = array())
    {
        foreach ($budgetBillMonthlyAmount as $arrayOfBudgetBillMonthlyAmountBudgetBillMonthlyAmountItem) {
            // validation for constraint: itemType
            if (!$arrayOfBudgetBillMonthlyAmountBudgetBillMonthlyAmountItem instanceof \SGCIS\Struct\BudgetBillMonthlyAmount) {
                throw new \InvalidArgumentException(sprintf('The BudgetBillMonthlyAmount property can only contain items of \SGCIS\Struct\BudgetBillMonthlyAmount, "%s" given', is_object($arrayOfBudgetBillMonthlyAmountBudgetBillMonthlyAmountItem) ? get_class($arrayOfBudgetBillMonthlyAmountBudgetBillMonthlyAmountItem) : gettype($arrayOfBudgetBillMonthlyAmountBudgetBillMonthlyAmountItem)), __LINE__);
            }
        }
        if (is_null($budgetBillMonthlyAmount) || (is_array($budgetBillMonthlyAmount) && empty($budgetBillMonthlyAmount))) {
            unset($this->BudgetBillMonthlyAmount);
        } else {
            $this->BudgetBillMonthlyAmount = $budgetBillMonthlyAmount;
        }
        return $this;
    }
    /**
     * Add item to BudgetBillMonthlyAmount value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\BudgetBillMonthlyAmount $item
     * @return \SGCIS\Array\ArrayOfBudgetBillMonthlyAmount
     */
    public function addToBudgetBillMonthlyAmount(\SGCIS\Struct\BudgetBillMonthlyAmount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\BudgetBillMonthlyAmount) {
            throw new \InvalidArgumentException(sprintf('The BudgetBillMonthlyAmount property can only contain items of \SGCIS\Struct\BudgetBillMonthlyAmount, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BudgetBillMonthlyAmount[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\BudgetBillMonthlyAmount|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\BudgetBillMonthlyAmount|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\BudgetBillMonthlyAmount|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\BudgetBillMonthlyAmount|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\BudgetBillMonthlyAmount|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BudgetBillMonthlyAmount
     */
    public function getAttributeName()
    {
        return 'BudgetBillMonthlyAmount';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfBudgetBillMonthlyAmount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
