<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBill Array
 * @subpackage Arrays
 */
class ArrayOfBill extends AbstractStructArrayBase
{
    /**
     * The Bill
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\Bill[]
     */
    public $Bill;
    /**
     * Constructor method for ArrayOfBill
     * @uses ArrayOfBill::setBill()
     * @param \SGCIS\Struct\Bill[] $bill
     */
    public function __construct(array $bill = array())
    {
        $this
            ->setBill($bill);
    }
    /**
     * Get Bill value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\Bill[]|null
     */
    public function getBill()
    {
        return isset($this->Bill) ? $this->Bill : null;
    }
    /**
     * Set Bill value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\Bill[] $bill
     * @return \SGCIS\Array\ArrayOfBill
     */
    public function setBill(array $bill = array())
    {
        foreach ($bill as $arrayOfBillBillItem) {
            // validation for constraint: itemType
            if (!$arrayOfBillBillItem instanceof \SGCIS\Struct\Bill) {
                throw new \InvalidArgumentException(sprintf('The Bill property can only contain items of \SGCIS\Struct\Bill, "%s" given', is_object($arrayOfBillBillItem) ? get_class($arrayOfBillBillItem) : gettype($arrayOfBillBillItem)), __LINE__);
            }
        }
        if (is_null($bill) || (is_array($bill) && empty($bill))) {
            unset($this->Bill);
        } else {
            $this->Bill = $bill;
        }
        return $this;
    }
    /**
     * Add item to Bill value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\Bill $item
     * @return \SGCIS\Array\ArrayOfBill
     */
    public function addToBill(\SGCIS\Struct\Bill $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\Bill) {
            throw new \InvalidArgumentException(sprintf('The Bill property can only contain items of \SGCIS\Struct\Bill, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Bill[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\Bill|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\Bill|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\Bill|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\Bill|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\Bill|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Bill
     */
    public function getAttributeName()
    {
        return 'Bill';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfBill
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
