<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAccountTransaction Array
 * @subpackage Arrays
 */
class ArrayOfAccountTransaction extends AbstractStructArrayBase
{
    /**
     * The AccountTransaction
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\AccountTransaction[]
     */
    public $AccountTransaction;
    /**
     * Constructor method for ArrayOfAccountTransaction
     * @uses ArrayOfAccountTransaction::setAccountTransaction()
     * @param \SGCIS\Struct\AccountTransaction[] $accountTransaction
     */
    public function __construct(array $accountTransaction = array())
    {
        $this
            ->setAccountTransaction($accountTransaction);
    }
    /**
     * Get AccountTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\AccountTransaction[]|null
     */
    public function getAccountTransaction()
    {
        return isset($this->AccountTransaction) ? $this->AccountTransaction : null;
    }
    /**
     * Set AccountTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\AccountTransaction[] $accountTransaction
     * @return \SGCIS\Array\ArrayOfAccountTransaction
     */
    public function setAccountTransaction(array $accountTransaction = array())
    {
        foreach ($accountTransaction as $arrayOfAccountTransactionAccountTransactionItem) {
            // validation for constraint: itemType
            if (!$arrayOfAccountTransactionAccountTransactionItem instanceof \SGCIS\Struct\AccountTransaction) {
                throw new \InvalidArgumentException(sprintf('The AccountTransaction property can only contain items of \SGCIS\Struct\AccountTransaction, "%s" given', is_object($arrayOfAccountTransactionAccountTransactionItem) ? get_class($arrayOfAccountTransactionAccountTransactionItem) : gettype($arrayOfAccountTransactionAccountTransactionItem)), __LINE__);
            }
        }
        if (is_null($accountTransaction) || (is_array($accountTransaction) && empty($accountTransaction))) {
            unset($this->AccountTransaction);
        } else {
            $this->AccountTransaction = $accountTransaction;
        }
        return $this;
    }
    /**
     * Add item to AccountTransaction value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\AccountTransaction $item
     * @return \SGCIS\Array\ArrayOfAccountTransaction
     */
    public function addToAccountTransaction(\SGCIS\Struct\AccountTransaction $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\AccountTransaction) {
            throw new \InvalidArgumentException(sprintf('The AccountTransaction property can only contain items of \SGCIS\Struct\AccountTransaction, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AccountTransaction[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\AccountTransaction|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\AccountTransaction|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\AccountTransaction|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\AccountTransaction|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\AccountTransaction|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AccountTransaction
     */
    public function getAttributeName()
    {
        return 'AccountTransaction';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfAccountTransaction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
