<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAccountServicePoint Array
 * @subpackage Arrays
 */
class ArrayOfAccountServicePoint extends AbstractStructArrayBase
{
    /**
     * The AccountServicePoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\AccountServicePoint[]
     */
    public $AccountServicePoint;
    /**
     * Constructor method for ArrayOfAccountServicePoint
     * @uses ArrayOfAccountServicePoint::setAccountServicePoint()
     * @param \SGCIS\Struct\AccountServicePoint[] $accountServicePoint
     */
    public function __construct(array $accountServicePoint = array())
    {
        $this
            ->setAccountServicePoint($accountServicePoint);
    }
    /**
     * Get AccountServicePoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\AccountServicePoint[]|null
     */
    public function getAccountServicePoint()
    {
        return isset($this->AccountServicePoint) ? $this->AccountServicePoint : null;
    }
    /**
     * Set AccountServicePoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\AccountServicePoint[] $accountServicePoint
     * @return \SGCIS\Array\ArrayOfAccountServicePoint
     */
    public function setAccountServicePoint(array $accountServicePoint = array())
    {
        foreach ($accountServicePoint as $arrayOfAccountServicePointAccountServicePointItem) {
            // validation for constraint: itemType
            if (!$arrayOfAccountServicePointAccountServicePointItem instanceof \SGCIS\Struct\AccountServicePoint) {
                throw new \InvalidArgumentException(sprintf('The AccountServicePoint property can only contain items of \SGCIS\Struct\AccountServicePoint, "%s" given', is_object($arrayOfAccountServicePointAccountServicePointItem) ? get_class($arrayOfAccountServicePointAccountServicePointItem) : gettype($arrayOfAccountServicePointAccountServicePointItem)), __LINE__);
            }
        }
        if (is_null($accountServicePoint) || (is_array($accountServicePoint) && empty($accountServicePoint))) {
            unset($this->AccountServicePoint);
        } else {
            $this->AccountServicePoint = $accountServicePoint;
        }
        return $this;
    }
    /**
     * Add item to AccountServicePoint value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\AccountServicePoint $item
     * @return \SGCIS\Array\ArrayOfAccountServicePoint
     */
    public function addToAccountServicePoint(\SGCIS\Struct\AccountServicePoint $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\AccountServicePoint) {
            throw new \InvalidArgumentException(sprintf('The AccountServicePoint property can only contain items of \SGCIS\Struct\AccountServicePoint, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AccountServicePoint[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\AccountServicePoint|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\AccountServicePoint|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\AccountServicePoint|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\AccountServicePoint|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\AccountServicePoint|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AccountServicePoint
     */
    public function getAttributeName()
    {
        return 'AccountServicePoint';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfAccountServicePoint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
