<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserCharacteristicRequest Struct
 * @subpackage Structs
 */
class UserCharacteristicRequest extends ServiceRequestBase
{
    /**
     * The UserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserID;
    /**
     * The CharName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CharName;
    /**
     * Constructor method for UserCharacteristicRequest
     * @uses UserCharacteristicRequest::setUserID()
     * @uses UserCharacteristicRequest::setCharName()
     * @param int $userID
     * @param string $charName
     */
    public function __construct($userID = null, $charName = null)
    {
        $this
            ->setUserID($userID)
            ->setCharName($charName);
    }
    /**
     * Get UserID value
     * @return int
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param int $userID
     * @return \SGCIS\Struct\UserCharacteristicRequest
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: int
        if (!is_null($userID) && !is_numeric($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get CharName value
     * @return string|null
     */
    public function getCharName()
    {
        return $this->CharName;
    }
    /**
     * Set CharName value
     * @param string $charName
     * @return \SGCIS\Struct\UserCharacteristicRequest
     */
    public function setCharName($charName = null)
    {
        // validation for constraint: string
        if (!is_null($charName) && !is_string($charName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($charName)), __LINE__);
        }
        $this->CharName = $charName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\UserCharacteristicRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
