<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserCharacteristic Struct
 * @subpackage Structs
 */
class UserCharacteristic extends AbstractStructBase
{
    /**
     * The UserCharacteristicID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserCharacteristicID;
    /**
     * The UserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserID;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The CharName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CharName;
    /**
     * The CharDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CharDescription;
    /**
     * The CharValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CharValue;
    /**
     * Constructor method for UserCharacteristic
     * @uses UserCharacteristic::setUserCharacteristicID()
     * @uses UserCharacteristic::setUserID()
     * @uses UserCharacteristic::setCreateDate()
     * @uses UserCharacteristic::setCharName()
     * @uses UserCharacteristic::setCharDescription()
     * @uses UserCharacteristic::setCharValue()
     * @param int $userCharacteristicID
     * @param int $userID
     * @param string $createDate
     * @param string $charName
     * @param string $charDescription
     * @param string $charValue
     */
    public function __construct($userCharacteristicID = null, $userID = null, $createDate = null, $charName = null, $charDescription = null, $charValue = null)
    {
        $this
            ->setUserCharacteristicID($userCharacteristicID)
            ->setUserID($userID)
            ->setCreateDate($createDate)
            ->setCharName($charName)
            ->setCharDescription($charDescription)
            ->setCharValue($charValue);
    }
    /**
     * Get UserCharacteristicID value
     * @return int
     */
    public function getUserCharacteristicID()
    {
        return $this->UserCharacteristicID;
    }
    /**
     * Set UserCharacteristicID value
     * @param int $userCharacteristicID
     * @return \SGCIS\Struct\UserCharacteristic
     */
    public function setUserCharacteristicID($userCharacteristicID = null)
    {
        // validation for constraint: int
        if (!is_null($userCharacteristicID) && !is_numeric($userCharacteristicID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($userCharacteristicID)), __LINE__);
        }
        $this->UserCharacteristicID = $userCharacteristicID;
        return $this;
    }
    /**
     * Get UserID value
     * @return int
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param int $userID
     * @return \SGCIS\Struct\UserCharacteristic
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: int
        if (!is_null($userID) && !is_numeric($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\UserCharacteristic
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get CharName value
     * @return string|null
     */
    public function getCharName()
    {
        return $this->CharName;
    }
    /**
     * Set CharName value
     * @param string $charName
     * @return \SGCIS\Struct\UserCharacteristic
     */
    public function setCharName($charName = null)
    {
        // validation for constraint: string
        if (!is_null($charName) && !is_string($charName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($charName)), __LINE__);
        }
        $this->CharName = $charName;
        return $this;
    }
    /**
     * Get CharDescription value
     * @return string|null
     */
    public function getCharDescription()
    {
        return $this->CharDescription;
    }
    /**
     * Set CharDescription value
     * @param string $charDescription
     * @return \SGCIS\Struct\UserCharacteristic
     */
    public function setCharDescription($charDescription = null)
    {
        // validation for constraint: string
        if (!is_null($charDescription) && !is_string($charDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($charDescription)), __LINE__);
        }
        $this->CharDescription = $charDescription;
        return $this;
    }
    /**
     * Get CharValue value
     * @return string|null
     */
    public function getCharValue()
    {
        return $this->CharValue;
    }
    /**
     * Set CharValue value
     * @param string $charValue
     * @return \SGCIS\Struct\UserCharacteristic
     */
    public function setCharValue($charValue = null)
    {
        // validation for constraint: string
        if (!is_null($charValue) && !is_string($charValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($charValue)), __LINE__);
        }
        $this->CharValue = $charValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\UserCharacteristic
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
