<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UsageChargeAccountType Struct
 * @subpackage Structs
 */
class UsageChargeAccountType extends BaseDTO
{
    /**
     * The UsageChargeAccountTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UsageChargeAccountTypeID;
    /**
     * The AccountTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountTypeID;
    /**
     * The UsageChargeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UsageChargeID;
    /**
     * Constructor method for UsageChargeAccountType
     * @uses UsageChargeAccountType::setUsageChargeAccountTypeID()
     * @uses UsageChargeAccountType::setAccountTypeID()
     * @uses UsageChargeAccountType::setUsageChargeID()
     * @param int $usageChargeAccountTypeID
     * @param int $accountTypeID
     * @param int $usageChargeID
     */
    public function __construct($usageChargeAccountTypeID = null, $accountTypeID = null, $usageChargeID = null)
    {
        $this
            ->setUsageChargeAccountTypeID($usageChargeAccountTypeID)
            ->setAccountTypeID($accountTypeID)
            ->setUsageChargeID($usageChargeID);
    }
    /**
     * Get UsageChargeAccountTypeID value
     * @return int
     */
    public function getUsageChargeAccountTypeID()
    {
        return $this->UsageChargeAccountTypeID;
    }
    /**
     * Set UsageChargeAccountTypeID value
     * @param int $usageChargeAccountTypeID
     * @return \SGCIS\Struct\UsageChargeAccountType
     */
    public function setUsageChargeAccountTypeID($usageChargeAccountTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($usageChargeAccountTypeID) && !is_numeric($usageChargeAccountTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($usageChargeAccountTypeID)), __LINE__);
        }
        $this->UsageChargeAccountTypeID = $usageChargeAccountTypeID;
        return $this;
    }
    /**
     * Get AccountTypeID value
     * @return int
     */
    public function getAccountTypeID()
    {
        return $this->AccountTypeID;
    }
    /**
     * Set AccountTypeID value
     * @param int $accountTypeID
     * @return \SGCIS\Struct\UsageChargeAccountType
     */
    public function setAccountTypeID($accountTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($accountTypeID) && !is_numeric($accountTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountTypeID)), __LINE__);
        }
        $this->AccountTypeID = $accountTypeID;
        return $this;
    }
    /**
     * Get UsageChargeID value
     * @return int
     */
    public function getUsageChargeID()
    {
        return $this->UsageChargeID;
    }
    /**
     * Set UsageChargeID value
     * @param int $usageChargeID
     * @return \SGCIS\Struct\UsageChargeAccountType
     */
    public function setUsageChargeID($usageChargeID = null)
    {
        // validation for constraint: int
        if (!is_null($usageChargeID) && !is_numeric($usageChargeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($usageChargeID)), __LINE__);
        }
        $this->UsageChargeID = $usageChargeID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\UsageChargeAccountType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
