<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UsageCharge Struct
 * @subpackage Structs
 */
class UsageCharge extends BaseDTO
{
    /**
     * The UsageChargeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UsageChargeID;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Active;
    /**
     * The ChargeTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChargeTypeID;
    /**
     * The ChargeAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ChargeAmount;
    /**
     * The UnitOfMeasureID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UnitOfMeasureID;
    /**
     * The ChargeIndexTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChargeIndexTypeID;
    /**
     * The TOUID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TOUID;
    /**
     * The DistributionServiceProviderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DistributionServiceProviderID;
    /**
     * The TaxTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TaxTypeID;
    /**
     * The IsTaxable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsTaxable;
    /**
     * The DateApproved
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateApproved;
    /**
     * The ApprovedBy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ApprovedBy;
    /**
     * The MinRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $MinRate;
    /**
     * The MaxRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $MaxRate;
    /**
     * The TierResetTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TierResetTypeID;
    /**
     * The RateUsageChargeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RateUsageChargeID;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The AprrovedUserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AprrovedUserName;
    /**
     * The UsageChargeAccountTypes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfUsageChargeAccountType
     */
    public $UsageChargeAccountTypes;
    /**
     * The TOUChargeSchedule
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfTOU
     */
    public $TOUChargeSchedule;
    /**
     * The UsageChargeTiers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfUsageChargeTier
     */
    public $UsageChargeTiers;
    /**
     * Constructor method for UsageCharge
     * @uses UsageCharge::setUsageChargeID()
     * @uses UsageCharge::setActive()
     * @uses UsageCharge::setChargeTypeID()
     * @uses UsageCharge::setChargeAmount()
     * @uses UsageCharge::setUnitOfMeasureID()
     * @uses UsageCharge::setChargeIndexTypeID()
     * @uses UsageCharge::setTOUID()
     * @uses UsageCharge::setDistributionServiceProviderID()
     * @uses UsageCharge::setTaxTypeID()
     * @uses UsageCharge::setIsTaxable()
     * @uses UsageCharge::setDateApproved()
     * @uses UsageCharge::setApprovedBy()
     * @uses UsageCharge::setMinRate()
     * @uses UsageCharge::setMaxRate()
     * @uses UsageCharge::setTierResetTypeID()
     * @uses UsageCharge::setRateUsageChargeID()
     * @uses UsageCharge::setName()
     * @uses UsageCharge::setDescription()
     * @uses UsageCharge::setAprrovedUserName()
     * @uses UsageCharge::setUsageChargeAccountTypes()
     * @uses UsageCharge::setTOUChargeSchedule()
     * @uses UsageCharge::setUsageChargeTiers()
     * @param int $usageChargeID
     * @param bool $active
     * @param int $chargeTypeID
     * @param float $chargeAmount
     * @param int $unitOfMeasureID
     * @param int $chargeIndexTypeID
     * @param int $tOUID
     * @param int $distributionServiceProviderID
     * @param int $taxTypeID
     * @param bool $isTaxable
     * @param string $dateApproved
     * @param int $approvedBy
     * @param float $minRate
     * @param float $maxRate
     * @param int $tierResetTypeID
     * @param int $rateUsageChargeID
     * @param string $name
     * @param string $description
     * @param string $aprrovedUserName
     * @param \SGCIS\Array\ArrayOfUsageChargeAccountType $usageChargeAccountTypes
     * @param \SGCIS\Array\ArrayOfTOU $tOUChargeSchedule
     * @param \SGCIS\Array\ArrayOfUsageChargeTier $usageChargeTiers
     */
    public function __construct($usageChargeID = null, $active = null, $chargeTypeID = null, $chargeAmount = null, $unitOfMeasureID = null, $chargeIndexTypeID = null, $tOUID = null, $distributionServiceProviderID = null, $taxTypeID = null, $isTaxable = null, $dateApproved = null, $approvedBy = null, $minRate = null, $maxRate = null, $tierResetTypeID = null, $rateUsageChargeID = null, $name = null, $description = null, $aprrovedUserName = null, \SGCIS\Array\ArrayOfUsageChargeAccountType $usageChargeAccountTypes = null, \SGCIS\Array\ArrayOfTOU $tOUChargeSchedule = null, \SGCIS\Array\ArrayOfUsageChargeTier $usageChargeTiers = null)
    {
        $this
            ->setUsageChargeID($usageChargeID)
            ->setActive($active)
            ->setChargeTypeID($chargeTypeID)
            ->setChargeAmount($chargeAmount)
            ->setUnitOfMeasureID($unitOfMeasureID)
            ->setChargeIndexTypeID($chargeIndexTypeID)
            ->setTOUID($tOUID)
            ->setDistributionServiceProviderID($distributionServiceProviderID)
            ->setTaxTypeID($taxTypeID)
            ->setIsTaxable($isTaxable)
            ->setDateApproved($dateApproved)
            ->setApprovedBy($approvedBy)
            ->setMinRate($minRate)
            ->setMaxRate($maxRate)
            ->setTierResetTypeID($tierResetTypeID)
            ->setRateUsageChargeID($rateUsageChargeID)
            ->setName($name)
            ->setDescription($description)
            ->setAprrovedUserName($aprrovedUserName)
            ->setUsageChargeAccountTypes($usageChargeAccountTypes)
            ->setTOUChargeSchedule($tOUChargeSchedule)
            ->setUsageChargeTiers($usageChargeTiers);
    }
    /**
     * Get UsageChargeID value
     * @return int
     */
    public function getUsageChargeID()
    {
        return $this->UsageChargeID;
    }
    /**
     * Set UsageChargeID value
     * @param int $usageChargeID
     * @return \SGCIS\Struct\UsageCharge
     */
    public function setUsageChargeID($usageChargeID = null)
    {
        // validation for constraint: int
        if (!is_null($usageChargeID) && !is_numeric($usageChargeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($usageChargeID)), __LINE__);
        }
        $this->UsageChargeID = $usageChargeID;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \SGCIS\Struct\UsageCharge
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get ChargeTypeID value
     * @return int
     */
    public function getChargeTypeID()
    {
        return $this->ChargeTypeID;
    }
    /**
     * Set ChargeTypeID value
     * @param int $chargeTypeID
     * @return \SGCIS\Struct\UsageCharge
     */
    public function setChargeTypeID($chargeTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($chargeTypeID) && !is_numeric($chargeTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeTypeID)), __LINE__);
        }
        $this->ChargeTypeID = $chargeTypeID;
        return $this;
    }
    /**
     * Get ChargeAmount value
     * @return float
     */
    public function getChargeAmount()
    {
        return $this->ChargeAmount;
    }
    /**
     * Set ChargeAmount value
     * @param float $chargeAmount
     * @return \SGCIS\Struct\UsageCharge
     */
    public function setChargeAmount($chargeAmount = null)
    {
        $this->ChargeAmount = $chargeAmount;
        return $this;
    }
    /**
     * Get UnitOfMeasureID value
     * @return int
     */
    public function getUnitOfMeasureID()
    {
        return $this->UnitOfMeasureID;
    }
    /**
     * Set UnitOfMeasureID value
     * @param int $unitOfMeasureID
     * @return \SGCIS\Struct\UsageCharge
     */
    public function setUnitOfMeasureID($unitOfMeasureID = null)
    {
        // validation for constraint: int
        if (!is_null($unitOfMeasureID) && !is_numeric($unitOfMeasureID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($unitOfMeasureID)), __LINE__);
        }
        $this->UnitOfMeasureID = $unitOfMeasureID;
        return $this;
    }
    /**
     * Get ChargeIndexTypeID value
     * @return int
     */
    public function getChargeIndexTypeID()
    {
        return $this->ChargeIndexTypeID;
    }
    /**
     * Set ChargeIndexTypeID value
     * @param int $chargeIndexTypeID
     * @return \SGCIS\Struct\UsageCharge
     */
    public function setChargeIndexTypeID($chargeIndexTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($chargeIndexTypeID) && !is_numeric($chargeIndexTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeIndexTypeID)), __LINE__);
        }
        $this->ChargeIndexTypeID = $chargeIndexTypeID;
        return $this;
    }
    /**
     * Get TOUID value
     * @return int
     */
    public function getTOUID()
    {
        return $this->TOUID;
    }
    /**
     * Set TOUID value
     * @param int $tOUID
     * @return \SGCIS\Struct\UsageCharge
     */
    public function setTOUID($tOUID = null)
    {
        // validation for constraint: int
        if (!is_null($tOUID) && !is_numeric($tOUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tOUID)), __LINE__);
        }
        $this->TOUID = $tOUID;
        return $this;
    }
    /**
     * Get DistributionServiceProviderID value
     * @return int
     */
    public function getDistributionServiceProviderID()
    {
        return $this->DistributionServiceProviderID;
    }
    /**
     * Set DistributionServiceProviderID value
     * @param int $distributionServiceProviderID
     * @return \SGCIS\Struct\UsageCharge
     */
    public function setDistributionServiceProviderID($distributionServiceProviderID = null)
    {
        // validation for constraint: int
        if (!is_null($distributionServiceProviderID) && !is_numeric($distributionServiceProviderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distributionServiceProviderID)), __LINE__);
        }
        $this->DistributionServiceProviderID = $distributionServiceProviderID;
        return $this;
    }
    /**
     * Get TaxTypeID value
     * @return int
     */
    public function getTaxTypeID()
    {
        return $this->TaxTypeID;
    }
    /**
     * Set TaxTypeID value
     * @param int $taxTypeID
     * @return \SGCIS\Struct\UsageCharge
     */
    public function setTaxTypeID($taxTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($taxTypeID) && !is_numeric($taxTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($taxTypeID)), __LINE__);
        }
        $this->TaxTypeID = $taxTypeID;
        return $this;
    }
    /**
     * Get IsTaxable value
     * @return bool
     */
    public function getIsTaxable()
    {
        return $this->IsTaxable;
    }
    /**
     * Set IsTaxable value
     * @param bool $isTaxable
     * @return \SGCIS\Struct\UsageCharge
     */
    public function setIsTaxable($isTaxable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTaxable) && !is_bool($isTaxable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isTaxable)), __LINE__);
        }
        $this->IsTaxable = $isTaxable;
        return $this;
    }
    /**
     * Get DateApproved value
     * @return string
     */
    public function getDateApproved()
    {
        return $this->DateApproved;
    }
    /**
     * Set DateApproved value
     * @param string $dateApproved
     * @return \SGCIS\Struct\UsageCharge
     */
    public function setDateApproved($dateApproved = null)
    {
        // validation for constraint: string
        if (!is_null($dateApproved) && !is_string($dateApproved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateApproved)), __LINE__);
        }
        $this->DateApproved = $dateApproved;
        return $this;
    }
    /**
     * Get ApprovedBy value
     * @return int
     */
    public function getApprovedBy()
    {
        return $this->ApprovedBy;
    }
    /**
     * Set ApprovedBy value
     * @param int $approvedBy
     * @return \SGCIS\Struct\UsageCharge
     */
    public function setApprovedBy($approvedBy = null)
    {
        // validation for constraint: int
        if (!is_null($approvedBy) && !is_numeric($approvedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($approvedBy)), __LINE__);
        }
        $this->ApprovedBy = $approvedBy;
        return $this;
    }
    /**
     * Get MinRate value
     * @return float
     */
    public function getMinRate()
    {
        return $this->MinRate;
    }
    /**
     * Set MinRate value
     * @param float $minRate
     * @return \SGCIS\Struct\UsageCharge
     */
    public function setMinRate($minRate = null)
    {
        $this->MinRate = $minRate;
        return $this;
    }
    /**
     * Get MaxRate value
     * @return float
     */
    public function getMaxRate()
    {
        return $this->MaxRate;
    }
    /**
     * Set MaxRate value
     * @param float $maxRate
     * @return \SGCIS\Struct\UsageCharge
     */
    public function setMaxRate($maxRate = null)
    {
        $this->MaxRate = $maxRate;
        return $this;
    }
    /**
     * Get TierResetTypeID value
     * @return int
     */
    public function getTierResetTypeID()
    {
        return $this->TierResetTypeID;
    }
    /**
     * Set TierResetTypeID value
     * @param int $tierResetTypeID
     * @return \SGCIS\Struct\UsageCharge
     */
    public function setTierResetTypeID($tierResetTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($tierResetTypeID) && !is_numeric($tierResetTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tierResetTypeID)), __LINE__);
        }
        $this->TierResetTypeID = $tierResetTypeID;
        return $this;
    }
    /**
     * Get RateUsageChargeID value
     * @return int
     */
    public function getRateUsageChargeID()
    {
        return $this->RateUsageChargeID;
    }
    /**
     * Set RateUsageChargeID value
     * @param int $rateUsageChargeID
     * @return \SGCIS\Struct\UsageCharge
     */
    public function setRateUsageChargeID($rateUsageChargeID = null)
    {
        // validation for constraint: int
        if (!is_null($rateUsageChargeID) && !is_numeric($rateUsageChargeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rateUsageChargeID)), __LINE__);
        }
        $this->RateUsageChargeID = $rateUsageChargeID;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \SGCIS\Struct\UsageCharge
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SGCIS\Struct\UsageCharge
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get AprrovedUserName value
     * @return string|null
     */
    public function getAprrovedUserName()
    {
        return $this->AprrovedUserName;
    }
    /**
     * Set AprrovedUserName value
     * @param string $aprrovedUserName
     * @return \SGCIS\Struct\UsageCharge
     */
    public function setAprrovedUserName($aprrovedUserName = null)
    {
        // validation for constraint: string
        if (!is_null($aprrovedUserName) && !is_string($aprrovedUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aprrovedUserName)), __LINE__);
        }
        $this->AprrovedUserName = $aprrovedUserName;
        return $this;
    }
    /**
     * Get UsageChargeAccountTypes value
     * @return \SGCIS\Array\ArrayOfUsageChargeAccountType|null
     */
    public function getUsageChargeAccountTypes()
    {
        return $this->UsageChargeAccountTypes;
    }
    /**
     * Set UsageChargeAccountTypes value
     * @param \SGCIS\Array\ArrayOfUsageChargeAccountType $usageChargeAccountTypes
     * @return \SGCIS\Struct\UsageCharge
     */
    public function setUsageChargeAccountTypes(\SGCIS\Array\ArrayOfUsageChargeAccountType $usageChargeAccountTypes = null)
    {
        $this->UsageChargeAccountTypes = $usageChargeAccountTypes;
        return $this;
    }
    /**
     * Get TOUChargeSchedule value
     * @return \SGCIS\Array\ArrayOfTOU|null
     */
    public function getTOUChargeSchedule()
    {
        return $this->TOUChargeSchedule;
    }
    /**
     * Set TOUChargeSchedule value
     * @param \SGCIS\Array\ArrayOfTOU $tOUChargeSchedule
     * @return \SGCIS\Struct\UsageCharge
     */
    public function setTOUChargeSchedule(\SGCIS\Array\ArrayOfTOU $tOUChargeSchedule = null)
    {
        $this->TOUChargeSchedule = $tOUChargeSchedule;
        return $this;
    }
    /**
     * Get UsageChargeTiers value
     * @return \SGCIS\Array\ArrayOfUsageChargeTier|null
     */
    public function getUsageChargeTiers()
    {
        return $this->UsageChargeTiers;
    }
    /**
     * Set UsageChargeTiers value
     * @param \SGCIS\Array\ArrayOfUsageChargeTier $usageChargeTiers
     * @return \SGCIS\Struct\UsageCharge
     */
    public function setUsageChargeTiers(\SGCIS\Array\ArrayOfUsageChargeTier $usageChargeTiers = null)
    {
        $this->UsageChargeTiers = $usageChargeTiers;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\UsageCharge
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
