<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransferServiceLocationRequest Struct
 * @subpackage Structs
 */
class TransferServiceLocationRequest extends CreateAccountRequest
{
    /**
     * The ServiceTransferDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceTransferDate;
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The DistributionPointIDToTransferFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DistributionPointIDToTransferFrom;
    /**
     * The DistributionPointIDToTransferTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DistributionPointIDToTransferTo;
    /**
     * The DistributionPointToTransfer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\DistributionPoint
     */
    public $DistributionPointToTransfer;
    /**
     * Constructor method for TransferServiceLocationRequest
     * @uses TransferServiceLocationRequest::setServiceTransferDate()
     * @uses TransferServiceLocationRequest::setAccountID()
     * @uses TransferServiceLocationRequest::setDistributionPointIDToTransferFrom()
     * @uses TransferServiceLocationRequest::setDistributionPointIDToTransferTo()
     * @uses TransferServiceLocationRequest::setDistributionPointToTransfer()
     * @param string $serviceTransferDate
     * @param int $accountID
     * @param int $distributionPointIDToTransferFrom
     * @param int $distributionPointIDToTransferTo
     * @param \SGCIS\Struct\DistributionPoint $distributionPointToTransfer
     */
    public function __construct($serviceTransferDate = null, $accountID = null, $distributionPointIDToTransferFrom = null, $distributionPointIDToTransferTo = null, \SGCIS\Struct\DistributionPoint $distributionPointToTransfer = null)
    {
        $this
            ->setServiceTransferDate($serviceTransferDate)
            ->setAccountID($accountID)
            ->setDistributionPointIDToTransferFrom($distributionPointIDToTransferFrom)
            ->setDistributionPointIDToTransferTo($distributionPointIDToTransferTo)
            ->setDistributionPointToTransfer($distributionPointToTransfer);
    }
    /**
     * Get ServiceTransferDate value
     * @return string
     */
    public function getServiceTransferDate()
    {
        return $this->ServiceTransferDate;
    }
    /**
     * Set ServiceTransferDate value
     * @param string $serviceTransferDate
     * @return \SGCIS\Struct\TransferServiceLocationRequest
     */
    public function setServiceTransferDate($serviceTransferDate = null)
    {
        // validation for constraint: string
        if (!is_null($serviceTransferDate) && !is_string($serviceTransferDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceTransferDate)), __LINE__);
        }
        $this->ServiceTransferDate = $serviceTransferDate;
        return $this;
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\TransferServiceLocationRequest
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get DistributionPointIDToTransferFrom value
     * @return int
     */
    public function getDistributionPointIDToTransferFrom()
    {
        return $this->DistributionPointIDToTransferFrom;
    }
    /**
     * Set DistributionPointIDToTransferFrom value
     * @param int $distributionPointIDToTransferFrom
     * @return \SGCIS\Struct\TransferServiceLocationRequest
     */
    public function setDistributionPointIDToTransferFrom($distributionPointIDToTransferFrom = null)
    {
        // validation for constraint: int
        if (!is_null($distributionPointIDToTransferFrom) && !is_numeric($distributionPointIDToTransferFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distributionPointIDToTransferFrom)), __LINE__);
        }
        $this->DistributionPointIDToTransferFrom = $distributionPointIDToTransferFrom;
        return $this;
    }
    /**
     * Get DistributionPointIDToTransferTo value
     * @return int
     */
    public function getDistributionPointIDToTransferTo()
    {
        return $this->DistributionPointIDToTransferTo;
    }
    /**
     * Set DistributionPointIDToTransferTo value
     * @param int $distributionPointIDToTransferTo
     * @return \SGCIS\Struct\TransferServiceLocationRequest
     */
    public function setDistributionPointIDToTransferTo($distributionPointIDToTransferTo = null)
    {
        // validation for constraint: int
        if (!is_null($distributionPointIDToTransferTo) && !is_numeric($distributionPointIDToTransferTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distributionPointIDToTransferTo)), __LINE__);
        }
        $this->DistributionPointIDToTransferTo = $distributionPointIDToTransferTo;
        return $this;
    }
    /**
     * Get DistributionPointToTransfer value
     * @return \SGCIS\Struct\DistributionPoint|null
     */
    public function getDistributionPointToTransfer()
    {
        return $this->DistributionPointToTransfer;
    }
    /**
     * Set DistributionPointToTransfer value
     * @param \SGCIS\Struct\DistributionPoint $distributionPointToTransfer
     * @return \SGCIS\Struct\TransferServiceLocationRequest
     */
    public function setDistributionPointToTransfer(\SGCIS\Struct\DistributionPoint $distributionPointToTransfer = null)
    {
        $this->DistributionPointToTransfer = $distributionPointToTransfer;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\TransferServiceLocationRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
