<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionAssociateAccount Struct
 * @subpackage Structs
 */
class TransactionAssociateAccount extends AbstractStructBase
{
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The AccountServicePointID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountServicePointID;
    /**
     * The ServiceStartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceStartDate;
    /**
     * The InactivationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $InactivationDate;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The ServiceProviderIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceProviderIdentifier;
    /**
     * The ServicePointStatusName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServicePointStatusName;
    /**
     * The AccountStatusName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountStatusName;
    /**
     * Constructor method for TransactionAssociateAccount
     * @uses TransactionAssociateAccount::setAccountID()
     * @uses TransactionAssociateAccount::setAccountServicePointID()
     * @uses TransactionAssociateAccount::setServiceStartDate()
     * @uses TransactionAssociateAccount::setInactivationDate()
     * @uses TransactionAssociateAccount::setAccountNumber()
     * @uses TransactionAssociateAccount::setServiceProviderIdentifier()
     * @uses TransactionAssociateAccount::setServicePointStatusName()
     * @uses TransactionAssociateAccount::setAccountStatusName()
     * @param int $accountID
     * @param int $accountServicePointID
     * @param string $serviceStartDate
     * @param string $inactivationDate
     * @param string $accountNumber
     * @param string $serviceProviderIdentifier
     * @param string $servicePointStatusName
     * @param string $accountStatusName
     */
    public function __construct($accountID = null, $accountServicePointID = null, $serviceStartDate = null, $inactivationDate = null, $accountNumber = null, $serviceProviderIdentifier = null, $servicePointStatusName = null, $accountStatusName = null)
    {
        $this
            ->setAccountID($accountID)
            ->setAccountServicePointID($accountServicePointID)
            ->setServiceStartDate($serviceStartDate)
            ->setInactivationDate($inactivationDate)
            ->setAccountNumber($accountNumber)
            ->setServiceProviderIdentifier($serviceProviderIdentifier)
            ->setServicePointStatusName($servicePointStatusName)
            ->setAccountStatusName($accountStatusName);
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\TransactionAssociateAccount
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get AccountServicePointID value
     * @return int
     */
    public function getAccountServicePointID()
    {
        return $this->AccountServicePointID;
    }
    /**
     * Set AccountServicePointID value
     * @param int $accountServicePointID
     * @return \SGCIS\Struct\TransactionAssociateAccount
     */
    public function setAccountServicePointID($accountServicePointID = null)
    {
        // validation for constraint: int
        if (!is_null($accountServicePointID) && !is_numeric($accountServicePointID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountServicePointID)), __LINE__);
        }
        $this->AccountServicePointID = $accountServicePointID;
        return $this;
    }
    /**
     * Get ServiceStartDate value
     * @return string
     */
    public function getServiceStartDate()
    {
        return $this->ServiceStartDate;
    }
    /**
     * Set ServiceStartDate value
     * @param string $serviceStartDate
     * @return \SGCIS\Struct\TransactionAssociateAccount
     */
    public function setServiceStartDate($serviceStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($serviceStartDate) && !is_string($serviceStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceStartDate)), __LINE__);
        }
        $this->ServiceStartDate = $serviceStartDate;
        return $this;
    }
    /**
     * Get InactivationDate value
     * @return string
     */
    public function getInactivationDate()
    {
        return $this->InactivationDate;
    }
    /**
     * Set InactivationDate value
     * @param string $inactivationDate
     * @return \SGCIS\Struct\TransactionAssociateAccount
     */
    public function setInactivationDate($inactivationDate = null)
    {
        // validation for constraint: string
        if (!is_null($inactivationDate) && !is_string($inactivationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inactivationDate)), __LINE__);
        }
        $this->InactivationDate = $inactivationDate;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \SGCIS\Struct\TransactionAssociateAccount
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get ServiceProviderIdentifier value
     * @return string|null
     */
    public function getServiceProviderIdentifier()
    {
        return $this->ServiceProviderIdentifier;
    }
    /**
     * Set ServiceProviderIdentifier value
     * @param string $serviceProviderIdentifier
     * @return \SGCIS\Struct\TransactionAssociateAccount
     */
    public function setServiceProviderIdentifier($serviceProviderIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($serviceProviderIdentifier) && !is_string($serviceProviderIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceProviderIdentifier)), __LINE__);
        }
        $this->ServiceProviderIdentifier = $serviceProviderIdentifier;
        return $this;
    }
    /**
     * Get ServicePointStatusName value
     * @return string|null
     */
    public function getServicePointStatusName()
    {
        return $this->ServicePointStatusName;
    }
    /**
     * Set ServicePointStatusName value
     * @param string $servicePointStatusName
     * @return \SGCIS\Struct\TransactionAssociateAccount
     */
    public function setServicePointStatusName($servicePointStatusName = null)
    {
        // validation for constraint: string
        if (!is_null($servicePointStatusName) && !is_string($servicePointStatusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($servicePointStatusName)), __LINE__);
        }
        $this->ServicePointStatusName = $servicePointStatusName;
        return $this;
    }
    /**
     * Get AccountStatusName value
     * @return string|null
     */
    public function getAccountStatusName()
    {
        return $this->AccountStatusName;
    }
    /**
     * Set AccountStatusName value
     * @param string $accountStatusName
     * @return \SGCIS\Struct\TransactionAssociateAccount
     */
    public function setAccountStatusName($accountStatusName = null)
    {
        // validation for constraint: string
        if (!is_null($accountStatusName) && !is_string($accountStatusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountStatusName)), __LINE__);
        }
        $this->AccountStatusName = $accountStatusName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\TransactionAssociateAccount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
