<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketType Struct
 * @subpackage Structs
 */
class TicketType extends BaseDTO
{
    /**
     * The TicketTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TicketTypeID;
    /**
     * The DefaultPriorityID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DefaultPriorityID;
    /**
     * The TicketSlaID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TicketSlaID;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Active;
    /**
     * The DbRecord
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $DbRecord;
    /**
     * The IsActiveForTerminatedAccts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsActiveForTerminatedAccts;
    /**
     * The MaxEscalationLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MaxEscalationLevel;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The SlaName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SlaName;
    /**
     * The PriorityName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PriorityName;
    /**
     * The Queues
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Queues;
    /**
     * The Fields
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fields;
    /**
     * The QueuesID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $QueuesID;
    /**
     * The Ticketpriority
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\TicketPriority
     */
    public $Ticketpriority;
    /**
     * The Ticketsla
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\TicketSla
     */
    public $Ticketsla;
    /**
     * The Ticketypequeues
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfTicketTypeQueue
     */
    public $Ticketypequeues;
    /**
     * The TicketypeFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfTicketTypeField
     */
    public $TicketypeFields;
    /**
     * The TicketQueueTypes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfTicketQueueType
     */
    public $TicketQueueTypes;
    /**
     * Constructor method for TicketType
     * @uses TicketType::setTicketTypeID()
     * @uses TicketType::setDefaultPriorityID()
     * @uses TicketType::setTicketSlaID()
     * @uses TicketType::setActive()
     * @uses TicketType::setDbRecord()
     * @uses TicketType::setIsActiveForTerminatedAccts()
     * @uses TicketType::setMaxEscalationLevel()
     * @uses TicketType::setName()
     * @uses TicketType::setDescription()
     * @uses TicketType::setSlaName()
     * @uses TicketType::setPriorityName()
     * @uses TicketType::setQueues()
     * @uses TicketType::setFields()
     * @uses TicketType::setQueuesID()
     * @uses TicketType::setTicketpriority()
     * @uses TicketType::setTicketsla()
     * @uses TicketType::setTicketypequeues()
     * @uses TicketType::setTicketypeFields()
     * @uses TicketType::setTicketQueueTypes()
     * @param int $ticketTypeID
     * @param int $defaultPriorityID
     * @param int $ticketSlaID
     * @param bool $active
     * @param bool $dbRecord
     * @param bool $isActiveForTerminatedAccts
     * @param int $maxEscalationLevel
     * @param string $name
     * @param string $description
     * @param string $slaName
     * @param string $priorityName
     * @param string $queues
     * @param string $fields
     * @param string $queuesID
     * @param \SGCIS\Struct\TicketPriority $ticketpriority
     * @param \SGCIS\Struct\TicketSla $ticketsla
     * @param \SGCIS\Array\ArrayOfTicketTypeQueue $ticketypequeues
     * @param \SGCIS\Array\ArrayOfTicketTypeField $ticketypeFields
     * @param \SGCIS\Array\ArrayOfTicketQueueType $ticketQueueTypes
     */
    public function __construct($ticketTypeID = null, $defaultPriorityID = null, $ticketSlaID = null, $active = null, $dbRecord = null, $isActiveForTerminatedAccts = null, $maxEscalationLevel = null, $name = null, $description = null, $slaName = null, $priorityName = null, $queues = null, $fields = null, $queuesID = null, \SGCIS\Struct\TicketPriority $ticketpriority = null, \SGCIS\Struct\TicketSla $ticketsla = null, \SGCIS\Array\ArrayOfTicketTypeQueue $ticketypequeues = null, \SGCIS\Array\ArrayOfTicketTypeField $ticketypeFields = null, \SGCIS\Array\ArrayOfTicketQueueType $ticketQueueTypes = null)
    {
        $this
            ->setTicketTypeID($ticketTypeID)
            ->setDefaultPriorityID($defaultPriorityID)
            ->setTicketSlaID($ticketSlaID)
            ->setActive($active)
            ->setDbRecord($dbRecord)
            ->setIsActiveForTerminatedAccts($isActiveForTerminatedAccts)
            ->setMaxEscalationLevel($maxEscalationLevel)
            ->setName($name)
            ->setDescription($description)
            ->setSlaName($slaName)
            ->setPriorityName($priorityName)
            ->setQueues($queues)
            ->setFields($fields)
            ->setQueuesID($queuesID)
            ->setTicketpriority($ticketpriority)
            ->setTicketsla($ticketsla)
            ->setTicketypequeues($ticketypequeues)
            ->setTicketypeFields($ticketypeFields)
            ->setTicketQueueTypes($ticketQueueTypes);
    }
    /**
     * Get TicketTypeID value
     * @return int
     */
    public function getTicketTypeID()
    {
        return $this->TicketTypeID;
    }
    /**
     * Set TicketTypeID value
     * @param int $ticketTypeID
     * @return \SGCIS\Struct\TicketType
     */
    public function setTicketTypeID($ticketTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($ticketTypeID) && !is_numeric($ticketTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketTypeID)), __LINE__);
        }
        $this->TicketTypeID = $ticketTypeID;
        return $this;
    }
    /**
     * Get DefaultPriorityID value
     * @return int
     */
    public function getDefaultPriorityID()
    {
        return $this->DefaultPriorityID;
    }
    /**
     * Set DefaultPriorityID value
     * @param int $defaultPriorityID
     * @return \SGCIS\Struct\TicketType
     */
    public function setDefaultPriorityID($defaultPriorityID = null)
    {
        // validation for constraint: int
        if (!is_null($defaultPriorityID) && !is_numeric($defaultPriorityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($defaultPriorityID)), __LINE__);
        }
        $this->DefaultPriorityID = $defaultPriorityID;
        return $this;
    }
    /**
     * Get TicketSlaID value
     * @return int
     */
    public function getTicketSlaID()
    {
        return $this->TicketSlaID;
    }
    /**
     * Set TicketSlaID value
     * @param int $ticketSlaID
     * @return \SGCIS\Struct\TicketType
     */
    public function setTicketSlaID($ticketSlaID = null)
    {
        // validation for constraint: int
        if (!is_null($ticketSlaID) && !is_numeric($ticketSlaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketSlaID)), __LINE__);
        }
        $this->TicketSlaID = $ticketSlaID;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \SGCIS\Struct\TicketType
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get DbRecord value
     * @return bool
     */
    public function getDbRecord()
    {
        return $this->DbRecord;
    }
    /**
     * Set DbRecord value
     * @param bool $dbRecord
     * @return \SGCIS\Struct\TicketType
     */
    public function setDbRecord($dbRecord = null)
    {
        // validation for constraint: boolean
        if (!is_null($dbRecord) && !is_bool($dbRecord)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($dbRecord)), __LINE__);
        }
        $this->DbRecord = $dbRecord;
        return $this;
    }
    /**
     * Get IsActiveForTerminatedAccts value
     * @return bool
     */
    public function getIsActiveForTerminatedAccts()
    {
        return $this->IsActiveForTerminatedAccts;
    }
    /**
     * Set IsActiveForTerminatedAccts value
     * @param bool $isActiveForTerminatedAccts
     * @return \SGCIS\Struct\TicketType
     */
    public function setIsActiveForTerminatedAccts($isActiveForTerminatedAccts = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActiveForTerminatedAccts) && !is_bool($isActiveForTerminatedAccts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isActiveForTerminatedAccts)), __LINE__);
        }
        $this->IsActiveForTerminatedAccts = $isActiveForTerminatedAccts;
        return $this;
    }
    /**
     * Get MaxEscalationLevel value
     * @return int
     */
    public function getMaxEscalationLevel()
    {
        return $this->MaxEscalationLevel;
    }
    /**
     * Set MaxEscalationLevel value
     * @param int $maxEscalationLevel
     * @return \SGCIS\Struct\TicketType
     */
    public function setMaxEscalationLevel($maxEscalationLevel = null)
    {
        // validation for constraint: int
        if (!is_null($maxEscalationLevel) && !is_numeric($maxEscalationLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxEscalationLevel)), __LINE__);
        }
        $this->MaxEscalationLevel = $maxEscalationLevel;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \SGCIS\Struct\TicketType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SGCIS\Struct\TicketType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get SlaName value
     * @return string|null
     */
    public function getSlaName()
    {
        return $this->SlaName;
    }
    /**
     * Set SlaName value
     * @param string $slaName
     * @return \SGCIS\Struct\TicketType
     */
    public function setSlaName($slaName = null)
    {
        // validation for constraint: string
        if (!is_null($slaName) && !is_string($slaName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($slaName)), __LINE__);
        }
        $this->SlaName = $slaName;
        return $this;
    }
    /**
     * Get PriorityName value
     * @return string|null
     */
    public function getPriorityName()
    {
        return $this->PriorityName;
    }
    /**
     * Set PriorityName value
     * @param string $priorityName
     * @return \SGCIS\Struct\TicketType
     */
    public function setPriorityName($priorityName = null)
    {
        // validation for constraint: string
        if (!is_null($priorityName) && !is_string($priorityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($priorityName)), __LINE__);
        }
        $this->PriorityName = $priorityName;
        return $this;
    }
    /**
     * Get Queues value
     * @return string|null
     */
    public function getQueues()
    {
        return $this->Queues;
    }
    /**
     * Set Queues value
     * @param string $queues
     * @return \SGCIS\Struct\TicketType
     */
    public function setQueues($queues = null)
    {
        // validation for constraint: string
        if (!is_null($queues) && !is_string($queues)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($queues)), __LINE__);
        }
        $this->Queues = $queues;
        return $this;
    }
    /**
     * Get Fields value
     * @return string|null
     */
    public function getFields()
    {
        return $this->Fields;
    }
    /**
     * Set Fields value
     * @param string $fields
     * @return \SGCIS\Struct\TicketType
     */
    public function setFields($fields = null)
    {
        // validation for constraint: string
        if (!is_null($fields) && !is_string($fields)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fields)), __LINE__);
        }
        $this->Fields = $fields;
        return $this;
    }
    /**
     * Get QueuesID value
     * @return string|null
     */
    public function getQueuesID()
    {
        return $this->QueuesID;
    }
    /**
     * Set QueuesID value
     * @param string $queuesID
     * @return \SGCIS\Struct\TicketType
     */
    public function setQueuesID($queuesID = null)
    {
        // validation for constraint: string
        if (!is_null($queuesID) && !is_string($queuesID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($queuesID)), __LINE__);
        }
        $this->QueuesID = $queuesID;
        return $this;
    }
    /**
     * Get Ticketpriority value
     * @return \SGCIS\Struct\TicketPriority|null
     */
    public function getTicketpriority()
    {
        return $this->Ticketpriority;
    }
    /**
     * Set Ticketpriority value
     * @param \SGCIS\Struct\TicketPriority $ticketpriority
     * @return \SGCIS\Struct\TicketType
     */
    public function setTicketpriority(\SGCIS\Struct\TicketPriority $ticketpriority = null)
    {
        $this->Ticketpriority = $ticketpriority;
        return $this;
    }
    /**
     * Get Ticketsla value
     * @return \SGCIS\Struct\TicketSla|null
     */
    public function getTicketsla()
    {
        return $this->Ticketsla;
    }
    /**
     * Set Ticketsla value
     * @param \SGCIS\Struct\TicketSla $ticketsla
     * @return \SGCIS\Struct\TicketType
     */
    public function setTicketsla(\SGCIS\Struct\TicketSla $ticketsla = null)
    {
        $this->Ticketsla = $ticketsla;
        return $this;
    }
    /**
     * Get Ticketypequeues value
     * @return \SGCIS\Array\ArrayOfTicketTypeQueue|null
     */
    public function getTicketypequeues()
    {
        return $this->Ticketypequeues;
    }
    /**
     * Set Ticketypequeues value
     * @param \SGCIS\Array\ArrayOfTicketTypeQueue $ticketypequeues
     * @return \SGCIS\Struct\TicketType
     */
    public function setTicketypequeues(\SGCIS\Array\ArrayOfTicketTypeQueue $ticketypequeues = null)
    {
        $this->Ticketypequeues = $ticketypequeues;
        return $this;
    }
    /**
     * Get TicketypeFields value
     * @return \SGCIS\Array\ArrayOfTicketTypeField|null
     */
    public function getTicketypeFields()
    {
        return $this->TicketypeFields;
    }
    /**
     * Set TicketypeFields value
     * @param \SGCIS\Array\ArrayOfTicketTypeField $ticketypeFields
     * @return \SGCIS\Struct\TicketType
     */
    public function setTicketypeFields(\SGCIS\Array\ArrayOfTicketTypeField $ticketypeFields = null)
    {
        $this->TicketypeFields = $ticketypeFields;
        return $this;
    }
    /**
     * Get TicketQueueTypes value
     * @return \SGCIS\Array\ArrayOfTicketQueueType|null
     */
    public function getTicketQueueTypes()
    {
        return $this->TicketQueueTypes;
    }
    /**
     * Set TicketQueueTypes value
     * @param \SGCIS\Array\ArrayOfTicketQueueType $ticketQueueTypes
     * @return \SGCIS\Struct\TicketType
     */
    public function setTicketQueueTypes(\SGCIS\Array\ArrayOfTicketQueueType $ticketQueueTypes = null)
    {
        $this->TicketQueueTypes = $ticketQueueTypes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\TicketType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
