<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketFieldValue Struct
 * @subpackage Structs
 */
class TicketFieldValue extends AbstractStructBase
{
    /**
     * The TicketFieldValueID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TicketFieldValueID;
    /**
     * The TicketFieldID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TicketFieldID;
    /**
     * The TicketID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TicketID;
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * Constructor method for TicketFieldValue
     * @uses TicketFieldValue::setTicketFieldValueID()
     * @uses TicketFieldValue::setTicketFieldID()
     * @uses TicketFieldValue::setTicketID()
     * @uses TicketFieldValue::setValue()
     * @param int $ticketFieldValueID
     * @param int $ticketFieldID
     * @param int $ticketID
     * @param string $value
     */
    public function __construct($ticketFieldValueID = null, $ticketFieldID = null, $ticketID = null, $value = null)
    {
        $this
            ->setTicketFieldValueID($ticketFieldValueID)
            ->setTicketFieldID($ticketFieldID)
            ->setTicketID($ticketID)
            ->setValue($value);
    }
    /**
     * Get TicketFieldValueID value
     * @return int
     */
    public function getTicketFieldValueID()
    {
        return $this->TicketFieldValueID;
    }
    /**
     * Set TicketFieldValueID value
     * @param int $ticketFieldValueID
     * @return \SGCIS\Struct\TicketFieldValue
     */
    public function setTicketFieldValueID($ticketFieldValueID = null)
    {
        // validation for constraint: int
        if (!is_null($ticketFieldValueID) && !is_numeric($ticketFieldValueID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketFieldValueID)), __LINE__);
        }
        $this->TicketFieldValueID = $ticketFieldValueID;
        return $this;
    }
    /**
     * Get TicketFieldID value
     * @return int
     */
    public function getTicketFieldID()
    {
        return $this->TicketFieldID;
    }
    /**
     * Set TicketFieldID value
     * @param int $ticketFieldID
     * @return \SGCIS\Struct\TicketFieldValue
     */
    public function setTicketFieldID($ticketFieldID = null)
    {
        // validation for constraint: int
        if (!is_null($ticketFieldID) && !is_numeric($ticketFieldID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketFieldID)), __LINE__);
        }
        $this->TicketFieldID = $ticketFieldID;
        return $this;
    }
    /**
     * Get TicketID value
     * @return int
     */
    public function getTicketID()
    {
        return $this->TicketID;
    }
    /**
     * Set TicketID value
     * @param int $ticketID
     * @return \SGCIS\Struct\TicketFieldValue
     */
    public function setTicketID($ticketID = null)
    {
        // validation for constraint: int
        if (!is_null($ticketID) && !is_numeric($ticketID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketID)), __LINE__);
        }
        $this->TicketID = $ticketID;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \SGCIS\Struct\TicketFieldValue
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\TicketFieldValue
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
