<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SystemRoleTicketQueueType Struct
 * @subpackage Structs
 */
class SystemRoleTicketQueueType extends AbstractStructBase
{
    /**
     * The SystemRoleTicketQueueTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SystemRoleTicketQueueTypeID;
    /**
     * The SystemRoleID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SystemRoleID;
    /**
     * The TicketQueueTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TicketQueueTypeID;
    /**
     * The UserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserID;
    /**
     * The RoleName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoleName;
    /**
     * The UserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * Constructor method for SystemRoleTicketQueueType
     * @uses SystemRoleTicketQueueType::setSystemRoleTicketQueueTypeID()
     * @uses SystemRoleTicketQueueType::setSystemRoleID()
     * @uses SystemRoleTicketQueueType::setTicketQueueTypeID()
     * @uses SystemRoleTicketQueueType::setUserID()
     * @uses SystemRoleTicketQueueType::setRoleName()
     * @uses SystemRoleTicketQueueType::setUserName()
     * @param int $systemRoleTicketQueueTypeID
     * @param int $systemRoleID
     * @param int $ticketQueueTypeID
     * @param int $userID
     * @param string $roleName
     * @param string $userName
     */
    public function __construct($systemRoleTicketQueueTypeID = null, $systemRoleID = null, $ticketQueueTypeID = null, $userID = null, $roleName = null, $userName = null)
    {
        $this
            ->setSystemRoleTicketQueueTypeID($systemRoleTicketQueueTypeID)
            ->setSystemRoleID($systemRoleID)
            ->setTicketQueueTypeID($ticketQueueTypeID)
            ->setUserID($userID)
            ->setRoleName($roleName)
            ->setUserName($userName);
    }
    /**
     * Get SystemRoleTicketQueueTypeID value
     * @return int
     */
    public function getSystemRoleTicketQueueTypeID()
    {
        return $this->SystemRoleTicketQueueTypeID;
    }
    /**
     * Set SystemRoleTicketQueueTypeID value
     * @param int $systemRoleTicketQueueTypeID
     * @return \SGCIS\Struct\SystemRoleTicketQueueType
     */
    public function setSystemRoleTicketQueueTypeID($systemRoleTicketQueueTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($systemRoleTicketQueueTypeID) && !is_numeric($systemRoleTicketQueueTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($systemRoleTicketQueueTypeID)), __LINE__);
        }
        $this->SystemRoleTicketQueueTypeID = $systemRoleTicketQueueTypeID;
        return $this;
    }
    /**
     * Get SystemRoleID value
     * @return int
     */
    public function getSystemRoleID()
    {
        return $this->SystemRoleID;
    }
    /**
     * Set SystemRoleID value
     * @param int $systemRoleID
     * @return \SGCIS\Struct\SystemRoleTicketQueueType
     */
    public function setSystemRoleID($systemRoleID = null)
    {
        // validation for constraint: int
        if (!is_null($systemRoleID) && !is_numeric($systemRoleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($systemRoleID)), __LINE__);
        }
        $this->SystemRoleID = $systemRoleID;
        return $this;
    }
    /**
     * Get TicketQueueTypeID value
     * @return int
     */
    public function getTicketQueueTypeID()
    {
        return $this->TicketQueueTypeID;
    }
    /**
     * Set TicketQueueTypeID value
     * @param int $ticketQueueTypeID
     * @return \SGCIS\Struct\SystemRoleTicketQueueType
     */
    public function setTicketQueueTypeID($ticketQueueTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($ticketQueueTypeID) && !is_numeric($ticketQueueTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketQueueTypeID)), __LINE__);
        }
        $this->TicketQueueTypeID = $ticketQueueTypeID;
        return $this;
    }
    /**
     * Get UserID value
     * @return int
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param int $userID
     * @return \SGCIS\Struct\SystemRoleTicketQueueType
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: int
        if (!is_null($userID) && !is_numeric($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get RoleName value
     * @return string|null
     */
    public function getRoleName()
    {
        return $this->RoleName;
    }
    /**
     * Set RoleName value
     * @param string $roleName
     * @return \SGCIS\Struct\SystemRoleTicketQueueType
     */
    public function setRoleName($roleName = null)
    {
        // validation for constraint: string
        if (!is_null($roleName) && !is_string($roleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roleName)), __LINE__);
        }
        $this->RoleName = $roleName;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \SGCIS\Struct\SystemRoleTicketQueueType
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\SystemRoleTicketQueueType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
