<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SystemRoleApplicationFunction Struct
 * @subpackage Structs
 */
class SystemRoleApplicationFunction extends AbstractStructBase
{
    /**
     * The SystemRoleApplicationFunctionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SystemRoleApplicationFunctionID;
    /**
     * The SystemRoleApplicationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SystemRoleApplicationID;
    /**
     * The SystemFunctionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SystemFunctionID;
    /**
     * The FunctionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FunctionName;
    /**
     * The FunctionDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FunctionDescription;
    /**
     * Constructor method for SystemRoleApplicationFunction
     * @uses SystemRoleApplicationFunction::setSystemRoleApplicationFunctionID()
     * @uses SystemRoleApplicationFunction::setSystemRoleApplicationID()
     * @uses SystemRoleApplicationFunction::setSystemFunctionID()
     * @uses SystemRoleApplicationFunction::setFunctionName()
     * @uses SystemRoleApplicationFunction::setFunctionDescription()
     * @param int $systemRoleApplicationFunctionID
     * @param int $systemRoleApplicationID
     * @param int $systemFunctionID
     * @param string $functionName
     * @param string $functionDescription
     */
    public function __construct($systemRoleApplicationFunctionID = null, $systemRoleApplicationID = null, $systemFunctionID = null, $functionName = null, $functionDescription = null)
    {
        $this
            ->setSystemRoleApplicationFunctionID($systemRoleApplicationFunctionID)
            ->setSystemRoleApplicationID($systemRoleApplicationID)
            ->setSystemFunctionID($systemFunctionID)
            ->setFunctionName($functionName)
            ->setFunctionDescription($functionDescription);
    }
    /**
     * Get SystemRoleApplicationFunctionID value
     * @return int
     */
    public function getSystemRoleApplicationFunctionID()
    {
        return $this->SystemRoleApplicationFunctionID;
    }
    /**
     * Set SystemRoleApplicationFunctionID value
     * @param int $systemRoleApplicationFunctionID
     * @return \SGCIS\Struct\SystemRoleApplicationFunction
     */
    public function setSystemRoleApplicationFunctionID($systemRoleApplicationFunctionID = null)
    {
        // validation for constraint: int
        if (!is_null($systemRoleApplicationFunctionID) && !is_numeric($systemRoleApplicationFunctionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($systemRoleApplicationFunctionID)), __LINE__);
        }
        $this->SystemRoleApplicationFunctionID = $systemRoleApplicationFunctionID;
        return $this;
    }
    /**
     * Get SystemRoleApplicationID value
     * @return int
     */
    public function getSystemRoleApplicationID()
    {
        return $this->SystemRoleApplicationID;
    }
    /**
     * Set SystemRoleApplicationID value
     * @param int $systemRoleApplicationID
     * @return \SGCIS\Struct\SystemRoleApplicationFunction
     */
    public function setSystemRoleApplicationID($systemRoleApplicationID = null)
    {
        // validation for constraint: int
        if (!is_null($systemRoleApplicationID) && !is_numeric($systemRoleApplicationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($systemRoleApplicationID)), __LINE__);
        }
        $this->SystemRoleApplicationID = $systemRoleApplicationID;
        return $this;
    }
    /**
     * Get SystemFunctionID value
     * @return int
     */
    public function getSystemFunctionID()
    {
        return $this->SystemFunctionID;
    }
    /**
     * Set SystemFunctionID value
     * @param int $systemFunctionID
     * @return \SGCIS\Struct\SystemRoleApplicationFunction
     */
    public function setSystemFunctionID($systemFunctionID = null)
    {
        // validation for constraint: int
        if (!is_null($systemFunctionID) && !is_numeric($systemFunctionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($systemFunctionID)), __LINE__);
        }
        $this->SystemFunctionID = $systemFunctionID;
        return $this;
    }
    /**
     * Get FunctionName value
     * @return string|null
     */
    public function getFunctionName()
    {
        return $this->FunctionName;
    }
    /**
     * Set FunctionName value
     * @param string $functionName
     * @return \SGCIS\Struct\SystemRoleApplicationFunction
     */
    public function setFunctionName($functionName = null)
    {
        // validation for constraint: string
        if (!is_null($functionName) && !is_string($functionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($functionName)), __LINE__);
        }
        $this->FunctionName = $functionName;
        return $this;
    }
    /**
     * Get FunctionDescription value
     * @return string|null
     */
    public function getFunctionDescription()
    {
        return $this->FunctionDescription;
    }
    /**
     * Set FunctionDescription value
     * @param string $functionDescription
     * @return \SGCIS\Struct\SystemRoleApplicationFunction
     */
    public function setFunctionDescription($functionDescription = null)
    {
        // validation for constraint: string
        if (!is_null($functionDescription) && !is_string($functionDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($functionDescription)), __LINE__);
        }
        $this->FunctionDescription = $functionDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\SystemRoleApplicationFunction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
