<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendPasswordRequest Struct
 * @subpackage Structs
 */
class SendPasswordRequest extends ServiceRequestBase
{
    /**
     * The PersonID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PersonID;
    /**
     * The SecurityQuestionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SecurityQuestionID;
    /**
     * The EmailAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailAddress;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The Token
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Token;
    /**
     * The SecurityQuestionAnswer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SecurityQuestionAnswer;
    /**
     * Constructor method for SendPasswordRequest
     * @uses SendPasswordRequest::setPersonID()
     * @uses SendPasswordRequest::setSecurityQuestionID()
     * @uses SendPasswordRequest::setEmailAddress()
     * @uses SendPasswordRequest::setAccountNumber()
     * @uses SendPasswordRequest::setPassword()
     * @uses SendPasswordRequest::setToken()
     * @uses SendPasswordRequest::setSecurityQuestionAnswer()
     * @param int $personID
     * @param int $securityQuestionID
     * @param string $emailAddress
     * @param string $accountNumber
     * @param string $password
     * @param string $token
     * @param string $securityQuestionAnswer
     */
    public function __construct($personID = null, $securityQuestionID = null, $emailAddress = null, $accountNumber = null, $password = null, $token = null, $securityQuestionAnswer = null)
    {
        $this
            ->setPersonID($personID)
            ->setSecurityQuestionID($securityQuestionID)
            ->setEmailAddress($emailAddress)
            ->setAccountNumber($accountNumber)
            ->setPassword($password)
            ->setToken($token)
            ->setSecurityQuestionAnswer($securityQuestionAnswer);
    }
    /**
     * Get PersonID value
     * @return int
     */
    public function getPersonID()
    {
        return $this->PersonID;
    }
    /**
     * Set PersonID value
     * @param int $personID
     * @return \SGCIS\Struct\SendPasswordRequest
     */
    public function setPersonID($personID = null)
    {
        // validation for constraint: int
        if (!is_null($personID) && !is_numeric($personID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personID)), __LINE__);
        }
        $this->PersonID = $personID;
        return $this;
    }
    /**
     * Get SecurityQuestionID value
     * @return int
     */
    public function getSecurityQuestionID()
    {
        return $this->SecurityQuestionID;
    }
    /**
     * Set SecurityQuestionID value
     * @param int $securityQuestionID
     * @return \SGCIS\Struct\SendPasswordRequest
     */
    public function setSecurityQuestionID($securityQuestionID = null)
    {
        // validation for constraint: int
        if (!is_null($securityQuestionID) && !is_numeric($securityQuestionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($securityQuestionID)), __LINE__);
        }
        $this->SecurityQuestionID = $securityQuestionID;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \SGCIS\Struct\SendPasswordRequest
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \SGCIS\Struct\SendPasswordRequest
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \SGCIS\Struct\SendPasswordRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get Token value
     * @return string|null
     */
    public function getToken()
    {
        return $this->Token;
    }
    /**
     * Set Token value
     * @param string $token
     * @return \SGCIS\Struct\SendPasswordRequest
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($token)), __LINE__);
        }
        $this->Token = $token;
        return $this;
    }
    /**
     * Get SecurityQuestionAnswer value
     * @return string|null
     */
    public function getSecurityQuestionAnswer()
    {
        return $this->SecurityQuestionAnswer;
    }
    /**
     * Set SecurityQuestionAnswer value
     * @param string $securityQuestionAnswer
     * @return \SGCIS\Struct\SendPasswordRequest
     */
    public function setSecurityQuestionAnswer($securityQuestionAnswer = null)
    {
        // validation for constraint: string
        if (!is_null($securityQuestionAnswer) && !is_string($securityQuestionAnswer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($securityQuestionAnswer)), __LINE__);
        }
        $this->SecurityQuestionAnswer = $securityQuestionAnswer;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\SendPasswordRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
