<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesForceLead Struct
 * @subpackage Structs
 */
class SalesForceLead extends AbstractStructBase
{
    /**
     * The DateOfBirth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateOfBirth;
    /**
     * The ProductID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductID;
    /**
     * The LanguageID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LanguageID;
    /**
     * The SalesForceLeadID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SalesForceLeadID;
    /**
     * The LeadCaptureSource
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LeadCaptureSource;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The CellPhone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CellPhone;
    /**
     * The HomePhone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HomePhone;
    /**
     * The NotificationChannel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfInt
     */
    public $NotificationChannel;
    /**
     * The ServiceAddress1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceAddress1;
    /**
     * The ServiceAddress2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceAddress2;
    /**
     * The ServiceAddressCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceAddressCity;
    /**
     * The ServiceAddressState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceAddressState;
    /**
     * The ServiceAddressZip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceAddressZip;
    /**
     * The ESIID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ESIID;
    /**
     * The AgentCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AgentCode;
    /**
     * The ProductName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductName;
    /**
     * The PinNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PinNumber;
    /**
     * Constructor method for SalesForceLead
     * @uses SalesForceLead::setDateOfBirth()
     * @uses SalesForceLead::setProductID()
     * @uses SalesForceLead::setLanguageID()
     * @uses SalesForceLead::setSalesForceLeadID()
     * @uses SalesForceLead::setLeadCaptureSource()
     * @uses SalesForceLead::setFirstName()
     * @uses SalesForceLead::setLastName()
     * @uses SalesForceLead::setEmail()
     * @uses SalesForceLead::setCellPhone()
     * @uses SalesForceLead::setHomePhone()
     * @uses SalesForceLead::setNotificationChannel()
     * @uses SalesForceLead::setServiceAddress1()
     * @uses SalesForceLead::setServiceAddress2()
     * @uses SalesForceLead::setServiceAddressCity()
     * @uses SalesForceLead::setServiceAddressState()
     * @uses SalesForceLead::setServiceAddressZip()
     * @uses SalesForceLead::setESIID()
     * @uses SalesForceLead::setAgentCode()
     * @uses SalesForceLead::setProductName()
     * @uses SalesForceLead::setPinNumber()
     * @param string $dateOfBirth
     * @param int $productID
     * @param int $languageID
     * @param string $salesForceLeadID
     * @param string $leadCaptureSource
     * @param string $firstName
     * @param string $lastName
     * @param string $email
     * @param string $cellPhone
     * @param string $homePhone
     * @param \SGCIS\Array\ArrayOfInt $notificationChannel
     * @param string $serviceAddress1
     * @param string $serviceAddress2
     * @param string $serviceAddressCity
     * @param string $serviceAddressState
     * @param string $serviceAddressZip
     * @param string $eSIID
     * @param string $agentCode
     * @param string $productName
     * @param string $pinNumber
     */
    public function __construct($dateOfBirth = null, $productID = null, $languageID = null, $salesForceLeadID = null, $leadCaptureSource = null, $firstName = null, $lastName = null, $email = null, $cellPhone = null, $homePhone = null, \SGCIS\Array\ArrayOfInt $notificationChannel = null, $serviceAddress1 = null, $serviceAddress2 = null, $serviceAddressCity = null, $serviceAddressState = null, $serviceAddressZip = null, $eSIID = null, $agentCode = null, $productName = null, $pinNumber = null)
    {
        $this
            ->setDateOfBirth($dateOfBirth)
            ->setProductID($productID)
            ->setLanguageID($languageID)
            ->setSalesForceLeadID($salesForceLeadID)
            ->setLeadCaptureSource($leadCaptureSource)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setEmail($email)
            ->setCellPhone($cellPhone)
            ->setHomePhone($homePhone)
            ->setNotificationChannel($notificationChannel)
            ->setServiceAddress1($serviceAddress1)
            ->setServiceAddress2($serviceAddress2)
            ->setServiceAddressCity($serviceAddressCity)
            ->setServiceAddressState($serviceAddressState)
            ->setServiceAddressZip($serviceAddressZip)
            ->setESIID($eSIID)
            ->setAgentCode($agentCode)
            ->setProductName($productName)
            ->setPinNumber($pinNumber);
    }
    /**
     * Get DateOfBirth value
     * @return string
     */
    public function getDateOfBirth()
    {
        return $this->DateOfBirth;
    }
    /**
     * Set DateOfBirth value
     * @param string $dateOfBirth
     * @return \SGCIS\Struct\SalesForceLead
     */
    public function setDateOfBirth($dateOfBirth = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfBirth) && !is_string($dateOfBirth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateOfBirth)), __LINE__);
        }
        $this->DateOfBirth = $dateOfBirth;
        return $this;
    }
    /**
     * Get ProductID value
     * @return int
     */
    public function getProductID()
    {
        return $this->ProductID;
    }
    /**
     * Set ProductID value
     * @param int $productID
     * @return \SGCIS\Struct\SalesForceLead
     */
    public function setProductID($productID = null)
    {
        // validation for constraint: int
        if (!is_null($productID) && !is_numeric($productID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productID)), __LINE__);
        }
        $this->ProductID = $productID;
        return $this;
    }
    /**
     * Get LanguageID value
     * @return int
     */
    public function getLanguageID()
    {
        return $this->LanguageID;
    }
    /**
     * Set LanguageID value
     * @param int $languageID
     * @return \SGCIS\Struct\SalesForceLead
     */
    public function setLanguageID($languageID = null)
    {
        // validation for constraint: int
        if (!is_null($languageID) && !is_numeric($languageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($languageID)), __LINE__);
        }
        $this->LanguageID = $languageID;
        return $this;
    }
    /**
     * Get SalesForceLeadID value
     * @return string|null
     */
    public function getSalesForceLeadID()
    {
        return $this->SalesForceLeadID;
    }
    /**
     * Set SalesForceLeadID value
     * @param string $salesForceLeadID
     * @return \SGCIS\Struct\SalesForceLead
     */
    public function setSalesForceLeadID($salesForceLeadID = null)
    {
        // validation for constraint: string
        if (!is_null($salesForceLeadID) && !is_string($salesForceLeadID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($salesForceLeadID)), __LINE__);
        }
        $this->SalesForceLeadID = $salesForceLeadID;
        return $this;
    }
    /**
     * Get LeadCaptureSource value
     * @return string|null
     */
    public function getLeadCaptureSource()
    {
        return $this->LeadCaptureSource;
    }
    /**
     * Set LeadCaptureSource value
     * @param string $leadCaptureSource
     * @return \SGCIS\Struct\SalesForceLead
     */
    public function setLeadCaptureSource($leadCaptureSource = null)
    {
        // validation for constraint: string
        if (!is_null($leadCaptureSource) && !is_string($leadCaptureSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($leadCaptureSource)), __LINE__);
        }
        $this->LeadCaptureSource = $leadCaptureSource;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \SGCIS\Struct\SalesForceLead
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \SGCIS\Struct\SalesForceLead
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \SGCIS\Struct\SalesForceLead
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get CellPhone value
     * @return string|null
     */
    public function getCellPhone()
    {
        return $this->CellPhone;
    }
    /**
     * Set CellPhone value
     * @param string $cellPhone
     * @return \SGCIS\Struct\SalesForceLead
     */
    public function setCellPhone($cellPhone = null)
    {
        // validation for constraint: string
        if (!is_null($cellPhone) && !is_string($cellPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cellPhone)), __LINE__);
        }
        $this->CellPhone = $cellPhone;
        return $this;
    }
    /**
     * Get HomePhone value
     * @return string|null
     */
    public function getHomePhone()
    {
        return $this->HomePhone;
    }
    /**
     * Set HomePhone value
     * @param string $homePhone
     * @return \SGCIS\Struct\SalesForceLead
     */
    public function setHomePhone($homePhone = null)
    {
        // validation for constraint: string
        if (!is_null($homePhone) && !is_string($homePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($homePhone)), __LINE__);
        }
        $this->HomePhone = $homePhone;
        return $this;
    }
    /**
     * Get NotificationChannel value
     * @return \SGCIS\Array\ArrayOfInt|null
     */
    public function getNotificationChannel()
    {
        return $this->NotificationChannel;
    }
    /**
     * Set NotificationChannel value
     * @param \SGCIS\Array\ArrayOfInt $notificationChannel
     * @return \SGCIS\Struct\SalesForceLead
     */
    public function setNotificationChannel(\SGCIS\Array\ArrayOfInt $notificationChannel = null)
    {
        $this->NotificationChannel = $notificationChannel;
        return $this;
    }
    /**
     * Get ServiceAddress1 value
     * @return string|null
     */
    public function getServiceAddress1()
    {
        return $this->ServiceAddress1;
    }
    /**
     * Set ServiceAddress1 value
     * @param string $serviceAddress1
     * @return \SGCIS\Struct\SalesForceLead
     */
    public function setServiceAddress1($serviceAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($serviceAddress1) && !is_string($serviceAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceAddress1)), __LINE__);
        }
        $this->ServiceAddress1 = $serviceAddress1;
        return $this;
    }
    /**
     * Get ServiceAddress2 value
     * @return string|null
     */
    public function getServiceAddress2()
    {
        return $this->ServiceAddress2;
    }
    /**
     * Set ServiceAddress2 value
     * @param string $serviceAddress2
     * @return \SGCIS\Struct\SalesForceLead
     */
    public function setServiceAddress2($serviceAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($serviceAddress2) && !is_string($serviceAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceAddress2)), __LINE__);
        }
        $this->ServiceAddress2 = $serviceAddress2;
        return $this;
    }
    /**
     * Get ServiceAddressCity value
     * @return string|null
     */
    public function getServiceAddressCity()
    {
        return $this->ServiceAddressCity;
    }
    /**
     * Set ServiceAddressCity value
     * @param string $serviceAddressCity
     * @return \SGCIS\Struct\SalesForceLead
     */
    public function setServiceAddressCity($serviceAddressCity = null)
    {
        // validation for constraint: string
        if (!is_null($serviceAddressCity) && !is_string($serviceAddressCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceAddressCity)), __LINE__);
        }
        $this->ServiceAddressCity = $serviceAddressCity;
        return $this;
    }
    /**
     * Get ServiceAddressState value
     * @return string|null
     */
    public function getServiceAddressState()
    {
        return $this->ServiceAddressState;
    }
    /**
     * Set ServiceAddressState value
     * @param string $serviceAddressState
     * @return \SGCIS\Struct\SalesForceLead
     */
    public function setServiceAddressState($serviceAddressState = null)
    {
        // validation for constraint: string
        if (!is_null($serviceAddressState) && !is_string($serviceAddressState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceAddressState)), __LINE__);
        }
        $this->ServiceAddressState = $serviceAddressState;
        return $this;
    }
    /**
     * Get ServiceAddressZip value
     * @return string|null
     */
    public function getServiceAddressZip()
    {
        return $this->ServiceAddressZip;
    }
    /**
     * Set ServiceAddressZip value
     * @param string $serviceAddressZip
     * @return \SGCIS\Struct\SalesForceLead
     */
    public function setServiceAddressZip($serviceAddressZip = null)
    {
        // validation for constraint: string
        if (!is_null($serviceAddressZip) && !is_string($serviceAddressZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceAddressZip)), __LINE__);
        }
        $this->ServiceAddressZip = $serviceAddressZip;
        return $this;
    }
    /**
     * Get ESIID value
     * @return string|null
     */
    public function getESIID()
    {
        return $this->ESIID;
    }
    /**
     * Set ESIID value
     * @param string $eSIID
     * @return \SGCIS\Struct\SalesForceLead
     */
    public function setESIID($eSIID = null)
    {
        // validation for constraint: string
        if (!is_null($eSIID) && !is_string($eSIID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eSIID)), __LINE__);
        }
        $this->ESIID = $eSIID;
        return $this;
    }
    /**
     * Get AgentCode value
     * @return string|null
     */
    public function getAgentCode()
    {
        return $this->AgentCode;
    }
    /**
     * Set AgentCode value
     * @param string $agentCode
     * @return \SGCIS\Struct\SalesForceLead
     */
    public function setAgentCode($agentCode = null)
    {
        // validation for constraint: string
        if (!is_null($agentCode) && !is_string($agentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agentCode)), __LINE__);
        }
        $this->AgentCode = $agentCode;
        return $this;
    }
    /**
     * Get ProductName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->ProductName;
    }
    /**
     * Set ProductName value
     * @param string $productName
     * @return \SGCIS\Struct\SalesForceLead
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productName)), __LINE__);
        }
        $this->ProductName = $productName;
        return $this;
    }
    /**
     * Get PinNumber value
     * @return string|null
     */
    public function getPinNumber()
    {
        return $this->PinNumber;
    }
    /**
     * Set PinNumber value
     * @param string $pinNumber
     * @return \SGCIS\Struct\SalesForceLead
     */
    public function setPinNumber($pinNumber = null)
    {
        // validation for constraint: string
        if (!is_null($pinNumber) && !is_string($pinNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pinNumber)), __LINE__);
        }
        $this->PinNumber = $pinNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\SalesForceLead
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
