<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegisterResponse Struct
 * @subpackage Structs
 */
class RegisterResponse extends ServiceResponseBase
{
    /**
     * The IsValidRegistration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsValidRegistration;
    /**
     * The RegisterErrors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfString
     */
    public $RegisterErrors;
    /**
     * The TwoFactorAuthCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TwoFactorAuthCode;
    /**
     * The RegisterResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\RegisterResponse
     */
    public $RegisterResult;
    /**
     * Constructor method for RegisterResponse
     * @uses RegisterResponse::setIsValidRegistration()
     * @uses RegisterResponse::setRegisterErrors()
     * @uses RegisterResponse::setTwoFactorAuthCode()
     * @uses RegisterResponse::setRegisterResult()
     * @param bool $isValidRegistration
     * @param \SGCIS\Array\ArrayOfString $registerErrors
     * @param string $twoFactorAuthCode
     * @param \SGCIS\Struct\RegisterResponse $registerResult
     */
    public function __construct($isValidRegistration = null, \SGCIS\Array\ArrayOfString $registerErrors = null, $twoFactorAuthCode = null, \SGCIS\Struct\RegisterResponse $registerResult = null)
    {
        $this
            ->setIsValidRegistration($isValidRegistration)
            ->setRegisterErrors($registerErrors)
            ->setTwoFactorAuthCode($twoFactorAuthCode)
            ->setRegisterResult($registerResult);
    }
    /**
     * Get IsValidRegistration value
     * @return bool
     */
    public function getIsValidRegistration()
    {
        return $this->IsValidRegistration;
    }
    /**
     * Set IsValidRegistration value
     * @param bool $isValidRegistration
     * @return \SGCIS\Struct\RegisterResponse
     */
    public function setIsValidRegistration($isValidRegistration = null)
    {
        // validation for constraint: boolean
        if (!is_null($isValidRegistration) && !is_bool($isValidRegistration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isValidRegistration)), __LINE__);
        }
        $this->IsValidRegistration = $isValidRegistration;
        return $this;
    }
    /**
     * Get RegisterErrors value
     * @return \SGCIS\Array\ArrayOfString|null
     */
    public function getRegisterErrors()
    {
        return $this->RegisterErrors;
    }
    /**
     * Set RegisterErrors value
     * @param \SGCIS\Array\ArrayOfString $registerErrors
     * @return \SGCIS\Struct\RegisterResponse
     */
    public function setRegisterErrors(\SGCIS\Array\ArrayOfString $registerErrors = null)
    {
        $this->RegisterErrors = $registerErrors;
        return $this;
    }
    /**
     * Get TwoFactorAuthCode value
     * @return string|null
     */
    public function getTwoFactorAuthCode()
    {
        return $this->TwoFactorAuthCode;
    }
    /**
     * Set TwoFactorAuthCode value
     * @param string $twoFactorAuthCode
     * @return \SGCIS\Struct\RegisterResponse
     */
    public function setTwoFactorAuthCode($twoFactorAuthCode = null)
    {
        // validation for constraint: string
        if (!is_null($twoFactorAuthCode) && !is_string($twoFactorAuthCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($twoFactorAuthCode)), __LINE__);
        }
        $this->TwoFactorAuthCode = $twoFactorAuthCode;
        return $this;
    }
    /**
     * Get RegisterResult value
     * @return \SGCIS\Struct\RegisterResponse|null
     */
    public function getRegisterResult()
    {
        return $this->RegisterResult;
    }
    /**
     * Set RegisterResult value
     * @param \SGCIS\Struct\RegisterResponse $registerResult
     * @return \SGCIS\Struct\RegisterResponse
     */
    public function setRegisterResult(\SGCIS\Struct\RegisterResponse $registerResult = null)
    {
        $this->RegisterResult = $registerResult;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\RegisterResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
