<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductResponse Struct
 * @subpackage Structs
 */
class ProductResponse extends ServiceResponseBase
{
    /**
     * The ProductID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductID;
    /**
     * The Product
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\Product
     */
    public $Product;
    /**
     * The Products
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfProduct
     */
    public $Products;
    /**
     * The LinesOfBussinesses
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfLineOfBusiness
     */
    public $LinesOfBussinesses;
    /**
     * The LinesOfBussiness
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\LineOfBusiness
     */
    public $LinesOfBussiness;
    /**
     * The ProductFamily
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\ProductFamily
     */
    public $ProductFamily;
    /**
     * The ProductFamilies
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfProductFamily
     */
    public $ProductFamilies;
    /**
     * The ProductDocuments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfProductDocument
     */
    public $ProductDocuments;
    /**
     * The ProductDocument
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\ProductDocument
     */
    public $ProductDocument;
    /**
     * The Applications
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfApplication
     */
    public $Applications;
    /**
     * The ProductAccountTypes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfProductAccountType
     */
    public $ProductAccountTypes;
    /**
     * The AccountTypes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAccountType
     */
    public $AccountTypes;
    /**
     * The ProductDisplay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\ProductDisplay
     */
    public $ProductDisplay;
    /**
     * Constructor method for ProductResponse
     * @uses ProductResponse::setProductID()
     * @uses ProductResponse::setProduct()
     * @uses ProductResponse::setProducts()
     * @uses ProductResponse::setLinesOfBussinesses()
     * @uses ProductResponse::setLinesOfBussiness()
     * @uses ProductResponse::setProductFamily()
     * @uses ProductResponse::setProductFamilies()
     * @uses ProductResponse::setProductDocuments()
     * @uses ProductResponse::setProductDocument()
     * @uses ProductResponse::setApplications()
     * @uses ProductResponse::setProductAccountTypes()
     * @uses ProductResponse::setAccountTypes()
     * @uses ProductResponse::setProductDisplay()
     * @param int $productID
     * @param \SGCIS\Struct\Product $product
     * @param \SGCIS\Array\ArrayOfProduct $products
     * @param \SGCIS\Array\ArrayOfLineOfBusiness $linesOfBussinesses
     * @param \SGCIS\Struct\LineOfBusiness $linesOfBussiness
     * @param \SGCIS\Struct\ProductFamily $productFamily
     * @param \SGCIS\Array\ArrayOfProductFamily $productFamilies
     * @param \SGCIS\Array\ArrayOfProductDocument $productDocuments
     * @param \SGCIS\Struct\ProductDocument $productDocument
     * @param \SGCIS\Array\ArrayOfApplication $applications
     * @param \SGCIS\Array\ArrayOfProductAccountType $productAccountTypes
     * @param \SGCIS\Array\ArrayOfAccountType $accountTypes
     * @param \SGCIS\Struct\ProductDisplay $productDisplay
     */
    public function __construct($productID = null, \SGCIS\Struct\Product $product = null, \SGCIS\Array\ArrayOfProduct $products = null, \SGCIS\Array\ArrayOfLineOfBusiness $linesOfBussinesses = null, \SGCIS\Struct\LineOfBusiness $linesOfBussiness = null, \SGCIS\Struct\ProductFamily $productFamily = null, \SGCIS\Array\ArrayOfProductFamily $productFamilies = null, \SGCIS\Array\ArrayOfProductDocument $productDocuments = null, \SGCIS\Struct\ProductDocument $productDocument = null, \SGCIS\Array\ArrayOfApplication $applications = null, \SGCIS\Array\ArrayOfProductAccountType $productAccountTypes = null, \SGCIS\Array\ArrayOfAccountType $accountTypes = null, \SGCIS\Struct\ProductDisplay $productDisplay = null)
    {
        $this
            ->setProductID($productID)
            ->setProduct($product)
            ->setProducts($products)
            ->setLinesOfBussinesses($linesOfBussinesses)
            ->setLinesOfBussiness($linesOfBussiness)
            ->setProductFamily($productFamily)
            ->setProductFamilies($productFamilies)
            ->setProductDocuments($productDocuments)
            ->setProductDocument($productDocument)
            ->setApplications($applications)
            ->setProductAccountTypes($productAccountTypes)
            ->setAccountTypes($accountTypes)
            ->setProductDisplay($productDisplay);
    }
    /**
     * Get ProductID value
     * @return int
     */
    public function getProductID()
    {
        return $this->ProductID;
    }
    /**
     * Set ProductID value
     * @param int $productID
     * @return \SGCIS\Struct\ProductResponse
     */
    public function setProductID($productID = null)
    {
        // validation for constraint: int
        if (!is_null($productID) && !is_numeric($productID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productID)), __LINE__);
        }
        $this->ProductID = $productID;
        return $this;
    }
    /**
     * Get Product value
     * @return \SGCIS\Struct\Product|null
     */
    public function getProduct()
    {
        return $this->Product;
    }
    /**
     * Set Product value
     * @param \SGCIS\Struct\Product $product
     * @return \SGCIS\Struct\ProductResponse
     */
    public function setProduct(\SGCIS\Struct\Product $product = null)
    {
        $this->Product = $product;
        return $this;
    }
    /**
     * Get Products value
     * @return \SGCIS\Array\ArrayOfProduct|null
     */
    public function getProducts()
    {
        return $this->Products;
    }
    /**
     * Set Products value
     * @param \SGCIS\Array\ArrayOfProduct $products
     * @return \SGCIS\Struct\ProductResponse
     */
    public function setProducts(\SGCIS\Array\ArrayOfProduct $products = null)
    {
        $this->Products = $products;
        return $this;
    }
    /**
     * Get LinesOfBussinesses value
     * @return \SGCIS\Array\ArrayOfLineOfBusiness|null
     */
    public function getLinesOfBussinesses()
    {
        return $this->LinesOfBussinesses;
    }
    /**
     * Set LinesOfBussinesses value
     * @param \SGCIS\Array\ArrayOfLineOfBusiness $linesOfBussinesses
     * @return \SGCIS\Struct\ProductResponse
     */
    public function setLinesOfBussinesses(\SGCIS\Array\ArrayOfLineOfBusiness $linesOfBussinesses = null)
    {
        $this->LinesOfBussinesses = $linesOfBussinesses;
        return $this;
    }
    /**
     * Get LinesOfBussiness value
     * @return \SGCIS\Struct\LineOfBusiness|null
     */
    public function getLinesOfBussiness()
    {
        return $this->LinesOfBussiness;
    }
    /**
     * Set LinesOfBussiness value
     * @param \SGCIS\Struct\LineOfBusiness $linesOfBussiness
     * @return \SGCIS\Struct\ProductResponse
     */
    public function setLinesOfBussiness(\SGCIS\Struct\LineOfBusiness $linesOfBussiness = null)
    {
        $this->LinesOfBussiness = $linesOfBussiness;
        return $this;
    }
    /**
     * Get ProductFamily value
     * @return \SGCIS\Struct\ProductFamily|null
     */
    public function getProductFamily()
    {
        return $this->ProductFamily;
    }
    /**
     * Set ProductFamily value
     * @param \SGCIS\Struct\ProductFamily $productFamily
     * @return \SGCIS\Struct\ProductResponse
     */
    public function setProductFamily(\SGCIS\Struct\ProductFamily $productFamily = null)
    {
        $this->ProductFamily = $productFamily;
        return $this;
    }
    /**
     * Get ProductFamilies value
     * @return \SGCIS\Array\ArrayOfProductFamily|null
     */
    public function getProductFamilies()
    {
        return $this->ProductFamilies;
    }
    /**
     * Set ProductFamilies value
     * @param \SGCIS\Array\ArrayOfProductFamily $productFamilies
     * @return \SGCIS\Struct\ProductResponse
     */
    public function setProductFamilies(\SGCIS\Array\ArrayOfProductFamily $productFamilies = null)
    {
        $this->ProductFamilies = $productFamilies;
        return $this;
    }
    /**
     * Get ProductDocuments value
     * @return \SGCIS\Array\ArrayOfProductDocument|null
     */
    public function getProductDocuments()
    {
        return $this->ProductDocuments;
    }
    /**
     * Set ProductDocuments value
     * @param \SGCIS\Array\ArrayOfProductDocument $productDocuments
     * @return \SGCIS\Struct\ProductResponse
     */
    public function setProductDocuments(\SGCIS\Array\ArrayOfProductDocument $productDocuments = null)
    {
        $this->ProductDocuments = $productDocuments;
        return $this;
    }
    /**
     * Get ProductDocument value
     * @return \SGCIS\Struct\ProductDocument|null
     */
    public function getProductDocument()
    {
        return $this->ProductDocument;
    }
    /**
     * Set ProductDocument value
     * @param \SGCIS\Struct\ProductDocument $productDocument
     * @return \SGCIS\Struct\ProductResponse
     */
    public function setProductDocument(\SGCIS\Struct\ProductDocument $productDocument = null)
    {
        $this->ProductDocument = $productDocument;
        return $this;
    }
    /**
     * Get Applications value
     * @return \SGCIS\Array\ArrayOfApplication|null
     */
    public function getApplications()
    {
        return $this->Applications;
    }
    /**
     * Set Applications value
     * @param \SGCIS\Array\ArrayOfApplication $applications
     * @return \SGCIS\Struct\ProductResponse
     */
    public function setApplications(\SGCIS\Array\ArrayOfApplication $applications = null)
    {
        $this->Applications = $applications;
        return $this;
    }
    /**
     * Get ProductAccountTypes value
     * @return \SGCIS\Array\ArrayOfProductAccountType|null
     */
    public function getProductAccountTypes()
    {
        return $this->ProductAccountTypes;
    }
    /**
     * Set ProductAccountTypes value
     * @param \SGCIS\Array\ArrayOfProductAccountType $productAccountTypes
     * @return \SGCIS\Struct\ProductResponse
     */
    public function setProductAccountTypes(\SGCIS\Array\ArrayOfProductAccountType $productAccountTypes = null)
    {
        $this->ProductAccountTypes = $productAccountTypes;
        return $this;
    }
    /**
     * Get AccountTypes value
     * @return \SGCIS\Array\ArrayOfAccountType|null
     */
    public function getAccountTypes()
    {
        return $this->AccountTypes;
    }
    /**
     * Set AccountTypes value
     * @param \SGCIS\Array\ArrayOfAccountType $accountTypes
     * @return \SGCIS\Struct\ProductResponse
     */
    public function setAccountTypes(\SGCIS\Array\ArrayOfAccountType $accountTypes = null)
    {
        $this->AccountTypes = $accountTypes;
        return $this;
    }
    /**
     * Get ProductDisplay value
     * @return \SGCIS\Struct\ProductDisplay|null
     */
    public function getProductDisplay()
    {
        return $this->ProductDisplay;
    }
    /**
     * Set ProductDisplay value
     * @param \SGCIS\Struct\ProductDisplay $productDisplay
     * @return \SGCIS\Struct\ProductResponse
     */
    public function setProductDisplay(\SGCIS\Struct\ProductDisplay $productDisplay = null)
    {
        $this->ProductDisplay = $productDisplay;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\ProductResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
