<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductDocument Struct
 * @subpackage Structs
 */
class ProductDocument extends AbstractStructBase
{
    /**
     * The ProductDocumentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductDocumentID;
    /**
     * The ProductID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductID;
    /**
     * The VesionNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $VesionNumber;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The LastUpdateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastUpdateDate;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Active;
    /**
     * The ProductDocumentTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductDocumentTypeID;
    /**
     * The ProductDocumentLanguageID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductDocumentLanguageID;
    /**
     * The DistributionServiceProviderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DistributionServiceProviderID;
    /**
     * The DocumentName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentName;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The DocumentTemplate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentTemplate;
    /**
     * The CreatedByUserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreatedByUserName;
    /**
     * The LastUpdateUserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastUpdateUserName;
    /**
     * The FileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileName;
    /**
     * The ProductDocumentTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductDocumentTypeName;
    /**
     * The ProductDocumentLanguageName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductDocumentLanguageName;
    /**
     * The DocumentURL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentURL;
    /**
     * The ExternalDocumentURL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalDocumentURL;
    /**
     * The DistributionServiceProviderName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DistributionServiceProviderName;
    /**
     * Constructor method for ProductDocument
     * @uses ProductDocument::setProductDocumentID()
     * @uses ProductDocument::setProductID()
     * @uses ProductDocument::setVesionNumber()
     * @uses ProductDocument::setCreateDate()
     * @uses ProductDocument::setLastUpdateDate()
     * @uses ProductDocument::setActive()
     * @uses ProductDocument::setProductDocumentTypeID()
     * @uses ProductDocument::setProductDocumentLanguageID()
     * @uses ProductDocument::setDistributionServiceProviderID()
     * @uses ProductDocument::setDocumentName()
     * @uses ProductDocument::setDescription()
     * @uses ProductDocument::setDocumentTemplate()
     * @uses ProductDocument::setCreatedByUserName()
     * @uses ProductDocument::setLastUpdateUserName()
     * @uses ProductDocument::setFileName()
     * @uses ProductDocument::setProductDocumentTypeName()
     * @uses ProductDocument::setProductDocumentLanguageName()
     * @uses ProductDocument::setDocumentURL()
     * @uses ProductDocument::setExternalDocumentURL()
     * @uses ProductDocument::setDistributionServiceProviderName()
     * @param int $productDocumentID
     * @param int $productID
     * @param int $vesionNumber
     * @param string $createDate
     * @param string $lastUpdateDate
     * @param bool $active
     * @param int $productDocumentTypeID
     * @param int $productDocumentLanguageID
     * @param int $distributionServiceProviderID
     * @param string $documentName
     * @param string $description
     * @param string $documentTemplate
     * @param string $createdByUserName
     * @param string $lastUpdateUserName
     * @param string $fileName
     * @param string $productDocumentTypeName
     * @param string $productDocumentLanguageName
     * @param string $documentURL
     * @param string $externalDocumentURL
     * @param string $distributionServiceProviderName
     */
    public function __construct($productDocumentID = null, $productID = null, $vesionNumber = null, $createDate = null, $lastUpdateDate = null, $active = null, $productDocumentTypeID = null, $productDocumentLanguageID = null, $distributionServiceProviderID = null, $documentName = null, $description = null, $documentTemplate = null, $createdByUserName = null, $lastUpdateUserName = null, $fileName = null, $productDocumentTypeName = null, $productDocumentLanguageName = null, $documentURL = null, $externalDocumentURL = null, $distributionServiceProviderName = null)
    {
        $this
            ->setProductDocumentID($productDocumentID)
            ->setProductID($productID)
            ->setVesionNumber($vesionNumber)
            ->setCreateDate($createDate)
            ->setLastUpdateDate($lastUpdateDate)
            ->setActive($active)
            ->setProductDocumentTypeID($productDocumentTypeID)
            ->setProductDocumentLanguageID($productDocumentLanguageID)
            ->setDistributionServiceProviderID($distributionServiceProviderID)
            ->setDocumentName($documentName)
            ->setDescription($description)
            ->setDocumentTemplate($documentTemplate)
            ->setCreatedByUserName($createdByUserName)
            ->setLastUpdateUserName($lastUpdateUserName)
            ->setFileName($fileName)
            ->setProductDocumentTypeName($productDocumentTypeName)
            ->setProductDocumentLanguageName($productDocumentLanguageName)
            ->setDocumentURL($documentURL)
            ->setExternalDocumentURL($externalDocumentURL)
            ->setDistributionServiceProviderName($distributionServiceProviderName);
    }
    /**
     * Get ProductDocumentID value
     * @return int
     */
    public function getProductDocumentID()
    {
        return $this->ProductDocumentID;
    }
    /**
     * Set ProductDocumentID value
     * @param int $productDocumentID
     * @return \SGCIS\Struct\ProductDocument
     */
    public function setProductDocumentID($productDocumentID = null)
    {
        // validation for constraint: int
        if (!is_null($productDocumentID) && !is_numeric($productDocumentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productDocumentID)), __LINE__);
        }
        $this->ProductDocumentID = $productDocumentID;
        return $this;
    }
    /**
     * Get ProductID value
     * @return int
     */
    public function getProductID()
    {
        return $this->ProductID;
    }
    /**
     * Set ProductID value
     * @param int $productID
     * @return \SGCIS\Struct\ProductDocument
     */
    public function setProductID($productID = null)
    {
        // validation for constraint: int
        if (!is_null($productID) && !is_numeric($productID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productID)), __LINE__);
        }
        $this->ProductID = $productID;
        return $this;
    }
    /**
     * Get VesionNumber value
     * @return int
     */
    public function getVesionNumber()
    {
        return $this->VesionNumber;
    }
    /**
     * Set VesionNumber value
     * @param int $vesionNumber
     * @return \SGCIS\Struct\ProductDocument
     */
    public function setVesionNumber($vesionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($vesionNumber) && !is_numeric($vesionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($vesionNumber)), __LINE__);
        }
        $this->VesionNumber = $vesionNumber;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\ProductDocument
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get LastUpdateDate value
     * @return string
     */
    public function getLastUpdateDate()
    {
        return $this->LastUpdateDate;
    }
    /**
     * Set LastUpdateDate value
     * @param string $lastUpdateDate
     * @return \SGCIS\Struct\ProductDocument
     */
    public function setLastUpdateDate($lastUpdateDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateDate) && !is_string($lastUpdateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUpdateDate)), __LINE__);
        }
        $this->LastUpdateDate = $lastUpdateDate;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \SGCIS\Struct\ProductDocument
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get ProductDocumentTypeID value
     * @return int
     */
    public function getProductDocumentTypeID()
    {
        return $this->ProductDocumentTypeID;
    }
    /**
     * Set ProductDocumentTypeID value
     * @param int $productDocumentTypeID
     * @return \SGCIS\Struct\ProductDocument
     */
    public function setProductDocumentTypeID($productDocumentTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($productDocumentTypeID) && !is_numeric($productDocumentTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productDocumentTypeID)), __LINE__);
        }
        $this->ProductDocumentTypeID = $productDocumentTypeID;
        return $this;
    }
    /**
     * Get ProductDocumentLanguageID value
     * @return int
     */
    public function getProductDocumentLanguageID()
    {
        return $this->ProductDocumentLanguageID;
    }
    /**
     * Set ProductDocumentLanguageID value
     * @param int $productDocumentLanguageID
     * @return \SGCIS\Struct\ProductDocument
     */
    public function setProductDocumentLanguageID($productDocumentLanguageID = null)
    {
        // validation for constraint: int
        if (!is_null($productDocumentLanguageID) && !is_numeric($productDocumentLanguageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productDocumentLanguageID)), __LINE__);
        }
        $this->ProductDocumentLanguageID = $productDocumentLanguageID;
        return $this;
    }
    /**
     * Get DistributionServiceProviderID value
     * @return int
     */
    public function getDistributionServiceProviderID()
    {
        return $this->DistributionServiceProviderID;
    }
    /**
     * Set DistributionServiceProviderID value
     * @param int $distributionServiceProviderID
     * @return \SGCIS\Struct\ProductDocument
     */
    public function setDistributionServiceProviderID($distributionServiceProviderID = null)
    {
        // validation for constraint: int
        if (!is_null($distributionServiceProviderID) && !is_numeric($distributionServiceProviderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distributionServiceProviderID)), __LINE__);
        }
        $this->DistributionServiceProviderID = $distributionServiceProviderID;
        return $this;
    }
    /**
     * Get DocumentName value
     * @return string|null
     */
    public function getDocumentName()
    {
        return $this->DocumentName;
    }
    /**
     * Set DocumentName value
     * @param string $documentName
     * @return \SGCIS\Struct\ProductDocument
     */
    public function setDocumentName($documentName = null)
    {
        // validation for constraint: string
        if (!is_null($documentName) && !is_string($documentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentName)), __LINE__);
        }
        $this->DocumentName = $documentName;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SGCIS\Struct\ProductDocument
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get DocumentTemplate value
     * @return string|null
     */
    public function getDocumentTemplate()
    {
        return $this->DocumentTemplate;
    }
    /**
     * Set DocumentTemplate value
     * @param string $documentTemplate
     * @return \SGCIS\Struct\ProductDocument
     */
    public function setDocumentTemplate($documentTemplate = null)
    {
        // validation for constraint: string
        if (!is_null($documentTemplate) && !is_string($documentTemplate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentTemplate)), __LINE__);
        }
        $this->DocumentTemplate = $documentTemplate;
        return $this;
    }
    /**
     * Get CreatedByUserName value
     * @return string|null
     */
    public function getCreatedByUserName()
    {
        return $this->CreatedByUserName;
    }
    /**
     * Set CreatedByUserName value
     * @param string $createdByUserName
     * @return \SGCIS\Struct\ProductDocument
     */
    public function setCreatedByUserName($createdByUserName = null)
    {
        // validation for constraint: string
        if (!is_null($createdByUserName) && !is_string($createdByUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createdByUserName)), __LINE__);
        }
        $this->CreatedByUserName = $createdByUserName;
        return $this;
    }
    /**
     * Get LastUpdateUserName value
     * @return string|null
     */
    public function getLastUpdateUserName()
    {
        return $this->LastUpdateUserName;
    }
    /**
     * Set LastUpdateUserName value
     * @param string $lastUpdateUserName
     * @return \SGCIS\Struct\ProductDocument
     */
    public function setLastUpdateUserName($lastUpdateUserName = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateUserName) && !is_string($lastUpdateUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUpdateUserName)), __LINE__);
        }
        $this->LastUpdateUserName = $lastUpdateUserName;
        return $this;
    }
    /**
     * Get FileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->FileName;
    }
    /**
     * Set FileName value
     * @param string $fileName
     * @return \SGCIS\Struct\ProductDocument
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileName)), __LINE__);
        }
        $this->FileName = $fileName;
        return $this;
    }
    /**
     * Get ProductDocumentTypeName value
     * @return string|null
     */
    public function getProductDocumentTypeName()
    {
        return $this->ProductDocumentTypeName;
    }
    /**
     * Set ProductDocumentTypeName value
     * @param string $productDocumentTypeName
     * @return \SGCIS\Struct\ProductDocument
     */
    public function setProductDocumentTypeName($productDocumentTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($productDocumentTypeName) && !is_string($productDocumentTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productDocumentTypeName)), __LINE__);
        }
        $this->ProductDocumentTypeName = $productDocumentTypeName;
        return $this;
    }
    /**
     * Get ProductDocumentLanguageName value
     * @return string|null
     */
    public function getProductDocumentLanguageName()
    {
        return $this->ProductDocumentLanguageName;
    }
    /**
     * Set ProductDocumentLanguageName value
     * @param string $productDocumentLanguageName
     * @return \SGCIS\Struct\ProductDocument
     */
    public function setProductDocumentLanguageName($productDocumentLanguageName = null)
    {
        // validation for constraint: string
        if (!is_null($productDocumentLanguageName) && !is_string($productDocumentLanguageName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productDocumentLanguageName)), __LINE__);
        }
        $this->ProductDocumentLanguageName = $productDocumentLanguageName;
        return $this;
    }
    /**
     * Get DocumentURL value
     * @return string|null
     */
    public function getDocumentURL()
    {
        return $this->DocumentURL;
    }
    /**
     * Set DocumentURL value
     * @param string $documentURL
     * @return \SGCIS\Struct\ProductDocument
     */
    public function setDocumentURL($documentURL = null)
    {
        // validation for constraint: string
        if (!is_null($documentURL) && !is_string($documentURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentURL)), __LINE__);
        }
        $this->DocumentURL = $documentURL;
        return $this;
    }
    /**
     * Get ExternalDocumentURL value
     * @return string|null
     */
    public function getExternalDocumentURL()
    {
        return $this->ExternalDocumentURL;
    }
    /**
     * Set ExternalDocumentURL value
     * @param string $externalDocumentURL
     * @return \SGCIS\Struct\ProductDocument
     */
    public function setExternalDocumentURL($externalDocumentURL = null)
    {
        // validation for constraint: string
        if (!is_null($externalDocumentURL) && !is_string($externalDocumentURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalDocumentURL)), __LINE__);
        }
        $this->ExternalDocumentURL = $externalDocumentURL;
        return $this;
    }
    /**
     * Get DistributionServiceProviderName value
     * @return string|null
     */
    public function getDistributionServiceProviderName()
    {
        return $this->DistributionServiceProviderName;
    }
    /**
     * Set DistributionServiceProviderName value
     * @param string $distributionServiceProviderName
     * @return \SGCIS\Struct\ProductDocument
     */
    public function setDistributionServiceProviderName($distributionServiceProviderName = null)
    {
        // validation for constraint: string
        if (!is_null($distributionServiceProviderName) && !is_string($distributionServiceProviderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distributionServiceProviderName)), __LINE__);
        }
        $this->DistributionServiceProviderName = $distributionServiceProviderName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\ProductDocument
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
