<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDistributionPointsRequest Struct
 * @subpackage Structs
 */
class GetDistributionPointsRequest extends ServiceRequestBase
{
    /**
     * The IsEsiIDSearch
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsEsiIDSearch;
    /**
     * The EsiID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EsiID;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $State;
    /**
     * The Zip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Zip;
    /**
     * Constructor method for GetDistributionPointsRequest
     * @uses GetDistributionPointsRequest::setIsEsiIDSearch()
     * @uses GetDistributionPointsRequest::setEsiID()
     * @uses GetDistributionPointsRequest::setAddress()
     * @uses GetDistributionPointsRequest::setCity()
     * @uses GetDistributionPointsRequest::setState()
     * @uses GetDistributionPointsRequest::setZip()
     * @param bool $isEsiIDSearch
     * @param string $esiID
     * @param string $address
     * @param string $city
     * @param string $state
     * @param string $zip
     */
    public function __construct($isEsiIDSearch = null, $esiID = null, $address = null, $city = null, $state = null, $zip = null)
    {
        $this
            ->setIsEsiIDSearch($isEsiIDSearch)
            ->setEsiID($esiID)
            ->setAddress($address)
            ->setCity($city)
            ->setState($state)
            ->setZip($zip);
    }
    /**
     * Get IsEsiIDSearch value
     * @return bool
     */
    public function getIsEsiIDSearch()
    {
        return $this->IsEsiIDSearch;
    }
    /**
     * Set IsEsiIDSearch value
     * @param bool $isEsiIDSearch
     * @return \SGCIS\Struct\GetDistributionPointsRequest
     */
    public function setIsEsiIDSearch($isEsiIDSearch = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEsiIDSearch) && !is_bool($isEsiIDSearch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isEsiIDSearch)), __LINE__);
        }
        $this->IsEsiIDSearch = $isEsiIDSearch;
        return $this;
    }
    /**
     * Get EsiID value
     * @return string|null
     */
    public function getEsiID()
    {
        return $this->EsiID;
    }
    /**
     * Set EsiID value
     * @param string $esiID
     * @return \SGCIS\Struct\GetDistributionPointsRequest
     */
    public function setEsiID($esiID = null)
    {
        // validation for constraint: string
        if (!is_null($esiID) && !is_string($esiID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($esiID)), __LINE__);
        }
        $this->EsiID = $esiID;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \SGCIS\Struct\GetDistributionPointsRequest
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \SGCIS\Struct\GetDistributionPointsRequest
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \SGCIS\Struct\GetDistributionPointsRequest
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get Zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->Zip;
    }
    /**
     * Set Zip value
     * @param string $zip
     * @return \SGCIS\Struct\GetDistributionPointsRequest
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zip)), __LINE__);
        }
        $this->Zip = $zip;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\GetDistributionPointsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
