<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DistributionPoint Struct
 * @subpackage Structs
 */
class DistributionPoint extends BaseDTO
{
    /**
     * The DistributionPointID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DistributionPointID;
    /**
     * The DistributionServiceProviderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DistributionServiceProviderID;
    /**
     * The PremiseTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PremiseTypeID;
    /**
     * The CountyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CountyID;
    /**
     * The ProductID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductID;
    /**
     * The HasAmsMeter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HasAmsMeter;
    /**
     * The IsMarketSwitch
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsMarketSwitch;
    /**
     * The SwitchOrMoveInDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SwitchOrMoveInDate;
    /**
     * The SwitchOrMoveInOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SwitchOrMoveInOrder;
    /**
     * The IsServiceOrderComplete
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsServiceOrderComplete;
    /**
     * The IsNewService
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsNewService;
    /**
     * The StartRegisterValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $StartRegisterValue;
    /**
     * The IsSwitchHold
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSwitchHold;
    /**
     * The IsBackDatedNewService
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsBackDatedNewService;
    /**
     * The Address1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address1;
    /**
     * The Address2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address2;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The StateCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StateCode;
    /**
     * The ZipCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ZipCode;
    /**
     * The ZipPlus4Code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ZipPlus4Code;
    /**
     * The Metered
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Metered;
    /**
     * The ServiceProviderIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceProviderIdentifier;
    /**
     * The PowerRegion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PowerRegion;
    /**
     * The StationCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StationCode;
    /**
     * The StationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StationName;
    /**
     * The ServiceCycle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceCycle;
    /**
     * The PremiseType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PremiseType;
    /**
     * The DwellingType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DwellingType;
    /**
     * The DwellingUnits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DwellingUnits;
    /**
     * The LoadProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoadProfile;
    /**
     * The CustomerAccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerAccountNumber;
    /**
     * The CustomerName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerName;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The DistributionServiceProviderName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DistributionServiceProviderName;
    /**
     * The DistributionServiceProviderISO
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DistributionServiceProviderISO;
    /**
     * The DistributionServiceProviderStateCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DistributionServiceProviderStateCode;
    /**
     * The DistributionServiceProviderStateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DistributionServiceProviderStateName;
    /**
     * The TaxAddress1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxAddress1;
    /**
     * The TaxAddress2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxAddress2;
    /**
     * The TaxCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxCity;
    /**
     * The TaxState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxState;
    /**
     * The TaxZip5
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxZip5;
    /**
     * The TaxZip4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxZip4;
    /**
     * The TaxFullZip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxFullZip;
    /**
     * The AccountAssociated
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\Account
     */
    public $AccountAssociated;
    /**
     * The BlockNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BlockNumber;
    /**
     * The LotNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LotNumber;
    /**
     * The MeterSize
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MeterSize;
    /**
     * The MonthlyBillingCycle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MonthlyBillingCycle;
    /**
     * The PolrCustomerClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PolrCustomerClass;
    /**
     * Constructor method for DistributionPoint
     * @uses DistributionPoint::setDistributionPointID()
     * @uses DistributionPoint::setDistributionServiceProviderID()
     * @uses DistributionPoint::setPremiseTypeID()
     * @uses DistributionPoint::setCountyID()
     * @uses DistributionPoint::setProductID()
     * @uses DistributionPoint::setHasAmsMeter()
     * @uses DistributionPoint::setIsMarketSwitch()
     * @uses DistributionPoint::setSwitchOrMoveInDate()
     * @uses DistributionPoint::setSwitchOrMoveInOrder()
     * @uses DistributionPoint::setIsServiceOrderComplete()
     * @uses DistributionPoint::setIsNewService()
     * @uses DistributionPoint::setStartRegisterValue()
     * @uses DistributionPoint::setIsSwitchHold()
     * @uses DistributionPoint::setIsBackDatedNewService()
     * @uses DistributionPoint::setAddress1()
     * @uses DistributionPoint::setAddress2()
     * @uses DistributionPoint::setCity()
     * @uses DistributionPoint::setStateCode()
     * @uses DistributionPoint::setZipCode()
     * @uses DistributionPoint::setZipPlus4Code()
     * @uses DistributionPoint::setMetered()
     * @uses DistributionPoint::setServiceProviderIdentifier()
     * @uses DistributionPoint::setPowerRegion()
     * @uses DistributionPoint::setStationCode()
     * @uses DistributionPoint::setStationName()
     * @uses DistributionPoint::setServiceCycle()
     * @uses DistributionPoint::setPremiseType()
     * @uses DistributionPoint::setDwellingType()
     * @uses DistributionPoint::setDwellingUnits()
     * @uses DistributionPoint::setLoadProfile()
     * @uses DistributionPoint::setCustomerAccountNumber()
     * @uses DistributionPoint::setCustomerName()
     * @uses DistributionPoint::setStatus()
     * @uses DistributionPoint::setDistributionServiceProviderName()
     * @uses DistributionPoint::setDistributionServiceProviderISO()
     * @uses DistributionPoint::setDistributionServiceProviderStateCode()
     * @uses DistributionPoint::setDistributionServiceProviderStateName()
     * @uses DistributionPoint::setTaxAddress1()
     * @uses DistributionPoint::setTaxAddress2()
     * @uses DistributionPoint::setTaxCity()
     * @uses DistributionPoint::setTaxState()
     * @uses DistributionPoint::setTaxZip5()
     * @uses DistributionPoint::setTaxZip4()
     * @uses DistributionPoint::setTaxFullZip()
     * @uses DistributionPoint::setAccountAssociated()
     * @uses DistributionPoint::setBlockNumber()
     * @uses DistributionPoint::setLotNumber()
     * @uses DistributionPoint::setMeterSize()
     * @uses DistributionPoint::setMonthlyBillingCycle()
     * @uses DistributionPoint::setPolrCustomerClass()
     * @param int $distributionPointID
     * @param int $distributionServiceProviderID
     * @param int $premiseTypeID
     * @param int $countyID
     * @param int $productID
     * @param bool $hasAmsMeter
     * @param bool $isMarketSwitch
     * @param string $switchOrMoveInDate
     * @param bool $switchOrMoveInOrder
     * @param bool $isServiceOrderComplete
     * @param bool $isNewService
     * @param float $startRegisterValue
     * @param bool $isSwitchHold
     * @param bool $isBackDatedNewService
     * @param string $address1
     * @param string $address2
     * @param string $city
     * @param string $stateCode
     * @param string $zipCode
     * @param string $zipPlus4Code
     * @param string $metered
     * @param string $serviceProviderIdentifier
     * @param string $powerRegion
     * @param string $stationCode
     * @param string $stationName
     * @param string $serviceCycle
     * @param string $premiseType
     * @param string $dwellingType
     * @param string $dwellingUnits
     * @param string $loadProfile
     * @param string $customerAccountNumber
     * @param string $customerName
     * @param string $status
     * @param string $distributionServiceProviderName
     * @param string $distributionServiceProviderISO
     * @param string $distributionServiceProviderStateCode
     * @param string $distributionServiceProviderStateName
     * @param string $taxAddress1
     * @param string $taxAddress2
     * @param string $taxCity
     * @param string $taxState
     * @param string $taxZip5
     * @param string $taxZip4
     * @param string $taxFullZip
     * @param \SGCIS\Struct\Account $accountAssociated
     * @param string $blockNumber
     * @param string $lotNumber
     * @param string $meterSize
     * @param string $monthlyBillingCycle
     * @param string $polrCustomerClass
     */
    public function __construct($distributionPointID = null, $distributionServiceProviderID = null, $premiseTypeID = null, $countyID = null, $productID = null, $hasAmsMeter = null, $isMarketSwitch = null, $switchOrMoveInDate = null, $switchOrMoveInOrder = null, $isServiceOrderComplete = null, $isNewService = null, $startRegisterValue = null, $isSwitchHold = null, $isBackDatedNewService = null, $address1 = null, $address2 = null, $city = null, $stateCode = null, $zipCode = null, $zipPlus4Code = null, $metered = null, $serviceProviderIdentifier = null, $powerRegion = null, $stationCode = null, $stationName = null, $serviceCycle = null, $premiseType = null, $dwellingType = null, $dwellingUnits = null, $loadProfile = null, $customerAccountNumber = null, $customerName = null, $status = null, $distributionServiceProviderName = null, $distributionServiceProviderISO = null, $distributionServiceProviderStateCode = null, $distributionServiceProviderStateName = null, $taxAddress1 = null, $taxAddress2 = null, $taxCity = null, $taxState = null, $taxZip5 = null, $taxZip4 = null, $taxFullZip = null, \SGCIS\Struct\Account $accountAssociated = null, $blockNumber = null, $lotNumber = null, $meterSize = null, $monthlyBillingCycle = null, $polrCustomerClass = null)
    {
        $this
            ->setDistributionPointID($distributionPointID)
            ->setDistributionServiceProviderID($distributionServiceProviderID)
            ->setPremiseTypeID($premiseTypeID)
            ->setCountyID($countyID)
            ->setProductID($productID)
            ->setHasAmsMeter($hasAmsMeter)
            ->setIsMarketSwitch($isMarketSwitch)
            ->setSwitchOrMoveInDate($switchOrMoveInDate)
            ->setSwitchOrMoveInOrder($switchOrMoveInOrder)
            ->setIsServiceOrderComplete($isServiceOrderComplete)
            ->setIsNewService($isNewService)
            ->setStartRegisterValue($startRegisterValue)
            ->setIsSwitchHold($isSwitchHold)
            ->setIsBackDatedNewService($isBackDatedNewService)
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setCity($city)
            ->setStateCode($stateCode)
            ->setZipCode($zipCode)
            ->setZipPlus4Code($zipPlus4Code)
            ->setMetered($metered)
            ->setServiceProviderIdentifier($serviceProviderIdentifier)
            ->setPowerRegion($powerRegion)
            ->setStationCode($stationCode)
            ->setStationName($stationName)
            ->setServiceCycle($serviceCycle)
            ->setPremiseType($premiseType)
            ->setDwellingType($dwellingType)
            ->setDwellingUnits($dwellingUnits)
            ->setLoadProfile($loadProfile)
            ->setCustomerAccountNumber($customerAccountNumber)
            ->setCustomerName($customerName)
            ->setStatus($status)
            ->setDistributionServiceProviderName($distributionServiceProviderName)
            ->setDistributionServiceProviderISO($distributionServiceProviderISO)
            ->setDistributionServiceProviderStateCode($distributionServiceProviderStateCode)
            ->setDistributionServiceProviderStateName($distributionServiceProviderStateName)
            ->setTaxAddress1($taxAddress1)
            ->setTaxAddress2($taxAddress2)
            ->setTaxCity($taxCity)
            ->setTaxState($taxState)
            ->setTaxZip5($taxZip5)
            ->setTaxZip4($taxZip4)
            ->setTaxFullZip($taxFullZip)
            ->setAccountAssociated($accountAssociated)
            ->setBlockNumber($blockNumber)
            ->setLotNumber($lotNumber)
            ->setMeterSize($meterSize)
            ->setMonthlyBillingCycle($monthlyBillingCycle)
            ->setPolrCustomerClass($polrCustomerClass);
    }
    /**
     * Get DistributionPointID value
     * @return int
     */
    public function getDistributionPointID()
    {
        return $this->DistributionPointID;
    }
    /**
     * Set DistributionPointID value
     * @param int $distributionPointID
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setDistributionPointID($distributionPointID = null)
    {
        // validation for constraint: int
        if (!is_null($distributionPointID) && !is_numeric($distributionPointID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distributionPointID)), __LINE__);
        }
        $this->DistributionPointID = $distributionPointID;
        return $this;
    }
    /**
     * Get DistributionServiceProviderID value
     * @return int
     */
    public function getDistributionServiceProviderID()
    {
        return $this->DistributionServiceProviderID;
    }
    /**
     * Set DistributionServiceProviderID value
     * @param int $distributionServiceProviderID
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setDistributionServiceProviderID($distributionServiceProviderID = null)
    {
        // validation for constraint: int
        if (!is_null($distributionServiceProviderID) && !is_numeric($distributionServiceProviderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distributionServiceProviderID)), __LINE__);
        }
        $this->DistributionServiceProviderID = $distributionServiceProviderID;
        return $this;
    }
    /**
     * Get PremiseTypeID value
     * @return int
     */
    public function getPremiseTypeID()
    {
        return $this->PremiseTypeID;
    }
    /**
     * Set PremiseTypeID value
     * @param int $premiseTypeID
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setPremiseTypeID($premiseTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($premiseTypeID) && !is_numeric($premiseTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($premiseTypeID)), __LINE__);
        }
        $this->PremiseTypeID = $premiseTypeID;
        return $this;
    }
    /**
     * Get CountyID value
     * @return int
     */
    public function getCountyID()
    {
        return $this->CountyID;
    }
    /**
     * Set CountyID value
     * @param int $countyID
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setCountyID($countyID = null)
    {
        // validation for constraint: int
        if (!is_null($countyID) && !is_numeric($countyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($countyID)), __LINE__);
        }
        $this->CountyID = $countyID;
        return $this;
    }
    /**
     * Get ProductID value
     * @return int
     */
    public function getProductID()
    {
        return $this->ProductID;
    }
    /**
     * Set ProductID value
     * @param int $productID
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setProductID($productID = null)
    {
        // validation for constraint: int
        if (!is_null($productID) && !is_numeric($productID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productID)), __LINE__);
        }
        $this->ProductID = $productID;
        return $this;
    }
    /**
     * Get HasAmsMeter value
     * @return bool
     */
    public function getHasAmsMeter()
    {
        return $this->HasAmsMeter;
    }
    /**
     * Set HasAmsMeter value
     * @param bool $hasAmsMeter
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setHasAmsMeter($hasAmsMeter = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasAmsMeter) && !is_bool($hasAmsMeter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasAmsMeter)), __LINE__);
        }
        $this->HasAmsMeter = $hasAmsMeter;
        return $this;
    }
    /**
     * Get IsMarketSwitch value
     * @return bool
     */
    public function getIsMarketSwitch()
    {
        return $this->IsMarketSwitch;
    }
    /**
     * Set IsMarketSwitch value
     * @param bool $isMarketSwitch
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setIsMarketSwitch($isMarketSwitch = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMarketSwitch) && !is_bool($isMarketSwitch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isMarketSwitch)), __LINE__);
        }
        $this->IsMarketSwitch = $isMarketSwitch;
        return $this;
    }
    /**
     * Get SwitchOrMoveInDate value
     * @return string
     */
    public function getSwitchOrMoveInDate()
    {
        return $this->SwitchOrMoveInDate;
    }
    /**
     * Set SwitchOrMoveInDate value
     * @param string $switchOrMoveInDate
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setSwitchOrMoveInDate($switchOrMoveInDate = null)
    {
        // validation for constraint: string
        if (!is_null($switchOrMoveInDate) && !is_string($switchOrMoveInDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($switchOrMoveInDate)), __LINE__);
        }
        $this->SwitchOrMoveInDate = $switchOrMoveInDate;
        return $this;
    }
    /**
     * Get SwitchOrMoveInOrder value
     * @return bool
     */
    public function getSwitchOrMoveInOrder()
    {
        return $this->SwitchOrMoveInOrder;
    }
    /**
     * Set SwitchOrMoveInOrder value
     * @param bool $switchOrMoveInOrder
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setSwitchOrMoveInOrder($switchOrMoveInOrder = null)
    {
        // validation for constraint: boolean
        if (!is_null($switchOrMoveInOrder) && !is_bool($switchOrMoveInOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($switchOrMoveInOrder)), __LINE__);
        }
        $this->SwitchOrMoveInOrder = $switchOrMoveInOrder;
        return $this;
    }
    /**
     * Get IsServiceOrderComplete value
     * @return bool
     */
    public function getIsServiceOrderComplete()
    {
        return $this->IsServiceOrderComplete;
    }
    /**
     * Set IsServiceOrderComplete value
     * @param bool $isServiceOrderComplete
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setIsServiceOrderComplete($isServiceOrderComplete = null)
    {
        // validation for constraint: boolean
        if (!is_null($isServiceOrderComplete) && !is_bool($isServiceOrderComplete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isServiceOrderComplete)), __LINE__);
        }
        $this->IsServiceOrderComplete = $isServiceOrderComplete;
        return $this;
    }
    /**
     * Get IsNewService value
     * @return bool
     */
    public function getIsNewService()
    {
        return $this->IsNewService;
    }
    /**
     * Set IsNewService value
     * @param bool $isNewService
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setIsNewService($isNewService = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNewService) && !is_bool($isNewService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isNewService)), __LINE__);
        }
        $this->IsNewService = $isNewService;
        return $this;
    }
    /**
     * Get StartRegisterValue value
     * @return float
     */
    public function getStartRegisterValue()
    {
        return $this->StartRegisterValue;
    }
    /**
     * Set StartRegisterValue value
     * @param float $startRegisterValue
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setStartRegisterValue($startRegisterValue = null)
    {
        $this->StartRegisterValue = $startRegisterValue;
        return $this;
    }
    /**
     * Get IsSwitchHold value
     * @return bool
     */
    public function getIsSwitchHold()
    {
        return $this->IsSwitchHold;
    }
    /**
     * Set IsSwitchHold value
     * @param bool $isSwitchHold
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setIsSwitchHold($isSwitchHold = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSwitchHold) && !is_bool($isSwitchHold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSwitchHold)), __LINE__);
        }
        $this->IsSwitchHold = $isSwitchHold;
        return $this;
    }
    /**
     * Get IsBackDatedNewService value
     * @return bool
     */
    public function getIsBackDatedNewService()
    {
        return $this->IsBackDatedNewService;
    }
    /**
     * Set IsBackDatedNewService value
     * @param bool $isBackDatedNewService
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setIsBackDatedNewService($isBackDatedNewService = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBackDatedNewService) && !is_bool($isBackDatedNewService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isBackDatedNewService)), __LINE__);
        }
        $this->IsBackDatedNewService = $isBackDatedNewService;
        return $this;
    }
    /**
     * Get Address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->Address1;
    }
    /**
     * Set Address1 value
     * @param string $address1
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address1)), __LINE__);
        }
        $this->Address1 = $address1;
        return $this;
    }
    /**
     * Get Address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->Address2;
    }
    /**
     * Set Address2 value
     * @param string $address2
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address2)), __LINE__);
        }
        $this->Address2 = $address2;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get StateCode value
     * @return string|null
     */
    public function getStateCode()
    {
        return $this->StateCode;
    }
    /**
     * Set StateCode value
     * @param string $stateCode
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setStateCode($stateCode = null)
    {
        // validation for constraint: string
        if (!is_null($stateCode) && !is_string($stateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stateCode)), __LINE__);
        }
        $this->StateCode = $stateCode;
        return $this;
    }
    /**
     * Get ZipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->ZipCode;
    }
    /**
     * Set ZipCode value
     * @param string $zipCode
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zipCode)), __LINE__);
        }
        $this->ZipCode = $zipCode;
        return $this;
    }
    /**
     * Get ZipPlus4Code value
     * @return string|null
     */
    public function getZipPlus4Code()
    {
        return $this->ZipPlus4Code;
    }
    /**
     * Set ZipPlus4Code value
     * @param string $zipPlus4Code
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setZipPlus4Code($zipPlus4Code = null)
    {
        // validation for constraint: string
        if (!is_null($zipPlus4Code) && !is_string($zipPlus4Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zipPlus4Code)), __LINE__);
        }
        $this->ZipPlus4Code = $zipPlus4Code;
        return $this;
    }
    /**
     * Get Metered value
     * @return string|null
     */
    public function getMetered()
    {
        return $this->Metered;
    }
    /**
     * Set Metered value
     * @param string $metered
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setMetered($metered = null)
    {
        // validation for constraint: string
        if (!is_null($metered) && !is_string($metered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($metered)), __LINE__);
        }
        $this->Metered = $metered;
        return $this;
    }
    /**
     * Get ServiceProviderIdentifier value
     * @return string|null
     */
    public function getServiceProviderIdentifier()
    {
        return $this->ServiceProviderIdentifier;
    }
    /**
     * Set ServiceProviderIdentifier value
     * @param string $serviceProviderIdentifier
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setServiceProviderIdentifier($serviceProviderIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($serviceProviderIdentifier) && !is_string($serviceProviderIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceProviderIdentifier)), __LINE__);
        }
        $this->ServiceProviderIdentifier = $serviceProviderIdentifier;
        return $this;
    }
    /**
     * Get PowerRegion value
     * @return string|null
     */
    public function getPowerRegion()
    {
        return $this->PowerRegion;
    }
    /**
     * Set PowerRegion value
     * @param string $powerRegion
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setPowerRegion($powerRegion = null)
    {
        // validation for constraint: string
        if (!is_null($powerRegion) && !is_string($powerRegion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($powerRegion)), __LINE__);
        }
        $this->PowerRegion = $powerRegion;
        return $this;
    }
    /**
     * Get StationCode value
     * @return string|null
     */
    public function getStationCode()
    {
        return $this->StationCode;
    }
    /**
     * Set StationCode value
     * @param string $stationCode
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setStationCode($stationCode = null)
    {
        // validation for constraint: string
        if (!is_null($stationCode) && !is_string($stationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stationCode)), __LINE__);
        }
        $this->StationCode = $stationCode;
        return $this;
    }
    /**
     * Get StationName value
     * @return string|null
     */
    public function getStationName()
    {
        return $this->StationName;
    }
    /**
     * Set StationName value
     * @param string $stationName
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setStationName($stationName = null)
    {
        // validation for constraint: string
        if (!is_null($stationName) && !is_string($stationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stationName)), __LINE__);
        }
        $this->StationName = $stationName;
        return $this;
    }
    /**
     * Get ServiceCycle value
     * @return string|null
     */
    public function getServiceCycle()
    {
        return $this->ServiceCycle;
    }
    /**
     * Set ServiceCycle value
     * @param string $serviceCycle
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setServiceCycle($serviceCycle = null)
    {
        // validation for constraint: string
        if (!is_null($serviceCycle) && !is_string($serviceCycle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceCycle)), __LINE__);
        }
        $this->ServiceCycle = $serviceCycle;
        return $this;
    }
    /**
     * Get PremiseType value
     * @return string|null
     */
    public function getPremiseType()
    {
        return $this->PremiseType;
    }
    /**
     * Set PremiseType value
     * @param string $premiseType
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setPremiseType($premiseType = null)
    {
        // validation for constraint: string
        if (!is_null($premiseType) && !is_string($premiseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($premiseType)), __LINE__);
        }
        $this->PremiseType = $premiseType;
        return $this;
    }
    /**
     * Get DwellingType value
     * @return string|null
     */
    public function getDwellingType()
    {
        return $this->DwellingType;
    }
    /**
     * Set DwellingType value
     * @param string $dwellingType
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setDwellingType($dwellingType = null)
    {
        // validation for constraint: string
        if (!is_null($dwellingType) && !is_string($dwellingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dwellingType)), __LINE__);
        }
        $this->DwellingType = $dwellingType;
        return $this;
    }
    /**
     * Get DwellingUnits value
     * @return string|null
     */
    public function getDwellingUnits()
    {
        return $this->DwellingUnits;
    }
    /**
     * Set DwellingUnits value
     * @param string $dwellingUnits
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setDwellingUnits($dwellingUnits = null)
    {
        // validation for constraint: string
        if (!is_null($dwellingUnits) && !is_string($dwellingUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dwellingUnits)), __LINE__);
        }
        $this->DwellingUnits = $dwellingUnits;
        return $this;
    }
    /**
     * Get LoadProfile value
     * @return string|null
     */
    public function getLoadProfile()
    {
        return $this->LoadProfile;
    }
    /**
     * Set LoadProfile value
     * @param string $loadProfile
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setLoadProfile($loadProfile = null)
    {
        // validation for constraint: string
        if (!is_null($loadProfile) && !is_string($loadProfile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($loadProfile)), __LINE__);
        }
        $this->LoadProfile = $loadProfile;
        return $this;
    }
    /**
     * Get CustomerAccountNumber value
     * @return string|null
     */
    public function getCustomerAccountNumber()
    {
        return $this->CustomerAccountNumber;
    }
    /**
     * Set CustomerAccountNumber value
     * @param string $customerAccountNumber
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setCustomerAccountNumber($customerAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($customerAccountNumber) && !is_string($customerAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerAccountNumber)), __LINE__);
        }
        $this->CustomerAccountNumber = $customerAccountNumber;
        return $this;
    }
    /**
     * Get CustomerName value
     * @return string|null
     */
    public function getCustomerName()
    {
        return $this->CustomerName;
    }
    /**
     * Set CustomerName value
     * @param string $customerName
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setCustomerName($customerName = null)
    {
        // validation for constraint: string
        if (!is_null($customerName) && !is_string($customerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerName)), __LINE__);
        }
        $this->CustomerName = $customerName;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get DistributionServiceProviderName value
     * @return string|null
     */
    public function getDistributionServiceProviderName()
    {
        return $this->DistributionServiceProviderName;
    }
    /**
     * Set DistributionServiceProviderName value
     * @param string $distributionServiceProviderName
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setDistributionServiceProviderName($distributionServiceProviderName = null)
    {
        // validation for constraint: string
        if (!is_null($distributionServiceProviderName) && !is_string($distributionServiceProviderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distributionServiceProviderName)), __LINE__);
        }
        $this->DistributionServiceProviderName = $distributionServiceProviderName;
        return $this;
    }
    /**
     * Get DistributionServiceProviderISO value
     * @return string|null
     */
    public function getDistributionServiceProviderISO()
    {
        return $this->DistributionServiceProviderISO;
    }
    /**
     * Set DistributionServiceProviderISO value
     * @param string $distributionServiceProviderISO
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setDistributionServiceProviderISO($distributionServiceProviderISO = null)
    {
        // validation for constraint: string
        if (!is_null($distributionServiceProviderISO) && !is_string($distributionServiceProviderISO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distributionServiceProviderISO)), __LINE__);
        }
        $this->DistributionServiceProviderISO = $distributionServiceProviderISO;
        return $this;
    }
    /**
     * Get DistributionServiceProviderStateCode value
     * @return string|null
     */
    public function getDistributionServiceProviderStateCode()
    {
        return $this->DistributionServiceProviderStateCode;
    }
    /**
     * Set DistributionServiceProviderStateCode value
     * @param string $distributionServiceProviderStateCode
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setDistributionServiceProviderStateCode($distributionServiceProviderStateCode = null)
    {
        // validation for constraint: string
        if (!is_null($distributionServiceProviderStateCode) && !is_string($distributionServiceProviderStateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distributionServiceProviderStateCode)), __LINE__);
        }
        $this->DistributionServiceProviderStateCode = $distributionServiceProviderStateCode;
        return $this;
    }
    /**
     * Get DistributionServiceProviderStateName value
     * @return string|null
     */
    public function getDistributionServiceProviderStateName()
    {
        return $this->DistributionServiceProviderStateName;
    }
    /**
     * Set DistributionServiceProviderStateName value
     * @param string $distributionServiceProviderStateName
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setDistributionServiceProviderStateName($distributionServiceProviderStateName = null)
    {
        // validation for constraint: string
        if (!is_null($distributionServiceProviderStateName) && !is_string($distributionServiceProviderStateName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distributionServiceProviderStateName)), __LINE__);
        }
        $this->DistributionServiceProviderStateName = $distributionServiceProviderStateName;
        return $this;
    }
    /**
     * Get TaxAddress1 value
     * @return string|null
     */
    public function getTaxAddress1()
    {
        return $this->TaxAddress1;
    }
    /**
     * Set TaxAddress1 value
     * @param string $taxAddress1
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setTaxAddress1($taxAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($taxAddress1) && !is_string($taxAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxAddress1)), __LINE__);
        }
        $this->TaxAddress1 = $taxAddress1;
        return $this;
    }
    /**
     * Get TaxAddress2 value
     * @return string|null
     */
    public function getTaxAddress2()
    {
        return $this->TaxAddress2;
    }
    /**
     * Set TaxAddress2 value
     * @param string $taxAddress2
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setTaxAddress2($taxAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($taxAddress2) && !is_string($taxAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxAddress2)), __LINE__);
        }
        $this->TaxAddress2 = $taxAddress2;
        return $this;
    }
    /**
     * Get TaxCity value
     * @return string|null
     */
    public function getTaxCity()
    {
        return $this->TaxCity;
    }
    /**
     * Set TaxCity value
     * @param string $taxCity
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setTaxCity($taxCity = null)
    {
        // validation for constraint: string
        if (!is_null($taxCity) && !is_string($taxCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxCity)), __LINE__);
        }
        $this->TaxCity = $taxCity;
        return $this;
    }
    /**
     * Get TaxState value
     * @return string|null
     */
    public function getTaxState()
    {
        return $this->TaxState;
    }
    /**
     * Set TaxState value
     * @param string $taxState
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setTaxState($taxState = null)
    {
        // validation for constraint: string
        if (!is_null($taxState) && !is_string($taxState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxState)), __LINE__);
        }
        $this->TaxState = $taxState;
        return $this;
    }
    /**
     * Get TaxZip5 value
     * @return string|null
     */
    public function getTaxZip5()
    {
        return $this->TaxZip5;
    }
    /**
     * Set TaxZip5 value
     * @param string $taxZip5
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setTaxZip5($taxZip5 = null)
    {
        // validation for constraint: string
        if (!is_null($taxZip5) && !is_string($taxZip5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxZip5)), __LINE__);
        }
        $this->TaxZip5 = $taxZip5;
        return $this;
    }
    /**
     * Get TaxZip4 value
     * @return string|null
     */
    public function getTaxZip4()
    {
        return $this->TaxZip4;
    }
    /**
     * Set TaxZip4 value
     * @param string $taxZip4
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setTaxZip4($taxZip4 = null)
    {
        // validation for constraint: string
        if (!is_null($taxZip4) && !is_string($taxZip4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxZip4)), __LINE__);
        }
        $this->TaxZip4 = $taxZip4;
        return $this;
    }
    /**
     * Get TaxFullZip value
     * @return string|null
     */
    public function getTaxFullZip()
    {
        return $this->TaxFullZip;
    }
    /**
     * Set TaxFullZip value
     * @param string $taxFullZip
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setTaxFullZip($taxFullZip = null)
    {
        // validation for constraint: string
        if (!is_null($taxFullZip) && !is_string($taxFullZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxFullZip)), __LINE__);
        }
        $this->TaxFullZip = $taxFullZip;
        return $this;
    }
    /**
     * Get AccountAssociated value
     * @return \SGCIS\Struct\Account|null
     */
    public function getAccountAssociated()
    {
        return $this->AccountAssociated;
    }
    /**
     * Set AccountAssociated value
     * @param \SGCIS\Struct\Account $accountAssociated
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setAccountAssociated(\SGCIS\Struct\Account $accountAssociated = null)
    {
        $this->AccountAssociated = $accountAssociated;
        return $this;
    }
    /**
     * Get BlockNumber value
     * @return string|null
     */
    public function getBlockNumber()
    {
        return $this->BlockNumber;
    }
    /**
     * Set BlockNumber value
     * @param string $blockNumber
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setBlockNumber($blockNumber = null)
    {
        // validation for constraint: string
        if (!is_null($blockNumber) && !is_string($blockNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($blockNumber)), __LINE__);
        }
        $this->BlockNumber = $blockNumber;
        return $this;
    }
    /**
     * Get LotNumber value
     * @return string|null
     */
    public function getLotNumber()
    {
        return $this->LotNumber;
    }
    /**
     * Set LotNumber value
     * @param string $lotNumber
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setLotNumber($lotNumber = null)
    {
        // validation for constraint: string
        if (!is_null($lotNumber) && !is_string($lotNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lotNumber)), __LINE__);
        }
        $this->LotNumber = $lotNumber;
        return $this;
    }
    /**
     * Get MeterSize value
     * @return string|null
     */
    public function getMeterSize()
    {
        return $this->MeterSize;
    }
    /**
     * Set MeterSize value
     * @param string $meterSize
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setMeterSize($meterSize = null)
    {
        // validation for constraint: string
        if (!is_null($meterSize) && !is_string($meterSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meterSize)), __LINE__);
        }
        $this->MeterSize = $meterSize;
        return $this;
    }
    /**
     * Get MonthlyBillingCycle value
     * @return string|null
     */
    public function getMonthlyBillingCycle()
    {
        return $this->MonthlyBillingCycle;
    }
    /**
     * Set MonthlyBillingCycle value
     * @param string $monthlyBillingCycle
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setMonthlyBillingCycle($monthlyBillingCycle = null)
    {
        // validation for constraint: string
        if (!is_null($monthlyBillingCycle) && !is_string($monthlyBillingCycle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($monthlyBillingCycle)), __LINE__);
        }
        $this->MonthlyBillingCycle = $monthlyBillingCycle;
        return $this;
    }
    /**
     * Get PolrCustomerClass value
     * @return string|null
     */
    public function getPolrCustomerClass()
    {
        return $this->PolrCustomerClass;
    }
    /**
     * Set PolrCustomerClass value
     * @param string $polrCustomerClass
     * @return \SGCIS\Struct\DistributionPoint
     */
    public function setPolrCustomerClass($polrCustomerClass = null)
    {
        // validation for constraint: string
        if (!is_null($polrCustomerClass) && !is_string($polrCustomerClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($polrCustomerClass)), __LINE__);
        }
        $this->PolrCustomerClass = $polrCustomerClass;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\DistributionPoint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
