<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillServicePointMeteredUsage Struct
 * @subpackage Structs
 */
class BillServicePointMeteredUsage extends AbstractStructBase
{
    /**
     * The BillServicePointMeteredUsageID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillServicePointMeteredUsageID;
    /**
     * The BillServicePointID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillServicePointID;
    /**
     * The MeterReadID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MeterReadID;
    /**
     * The ServicePointMeterID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServicePointMeterID;
    /**
     * The RateValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $RateValue;
    /**
     * The CurrentMeterRead
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CurrentMeterRead;
    /**
     * The PreviousMeterRead
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PreviousMeterRead;
    /**
     * The UsageStartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $UsageStartDate;
    /**
     * The UsageEndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $UsageEndDate;
    /**
     * The UsageAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $UsageAmount;
    /**
     * The UnitOfMeasureID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UnitOfMeasureID;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The MeterNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MeterNumber;
    /**
     * The MeterType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MeterType;
    /**
     * The MeterMultiplier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MeterMultiplier;
    /**
     * Constructor method for BillServicePointMeteredUsage
     * @uses BillServicePointMeteredUsage::setBillServicePointMeteredUsageID()
     * @uses BillServicePointMeteredUsage::setBillServicePointID()
     * @uses BillServicePointMeteredUsage::setMeterReadID()
     * @uses BillServicePointMeteredUsage::setServicePointMeterID()
     * @uses BillServicePointMeteredUsage::setRateValue()
     * @uses BillServicePointMeteredUsage::setCurrentMeterRead()
     * @uses BillServicePointMeteredUsage::setPreviousMeterRead()
     * @uses BillServicePointMeteredUsage::setUsageStartDate()
     * @uses BillServicePointMeteredUsage::setUsageEndDate()
     * @uses BillServicePointMeteredUsage::setUsageAmount()
     * @uses BillServicePointMeteredUsage::setUnitOfMeasureID()
     * @uses BillServicePointMeteredUsage::setCreateDate()
     * @uses BillServicePointMeteredUsage::setMeterNumber()
     * @uses BillServicePointMeteredUsage::setMeterType()
     * @uses BillServicePointMeteredUsage::setMeterMultiplier()
     * @param int $billServicePointMeteredUsageID
     * @param int $billServicePointID
     * @param int $meterReadID
     * @param int $servicePointMeterID
     * @param float $rateValue
     * @param float $currentMeterRead
     * @param float $previousMeterRead
     * @param string $usageStartDate
     * @param string $usageEndDate
     * @param float $usageAmount
     * @param int $unitOfMeasureID
     * @param string $createDate
     * @param string $meterNumber
     * @param string $meterType
     * @param string $meterMultiplier
     */
    public function __construct($billServicePointMeteredUsageID = null, $billServicePointID = null, $meterReadID = null, $servicePointMeterID = null, $rateValue = null, $currentMeterRead = null, $previousMeterRead = null, $usageStartDate = null, $usageEndDate = null, $usageAmount = null, $unitOfMeasureID = null, $createDate = null, $meterNumber = null, $meterType = null, $meterMultiplier = null)
    {
        $this
            ->setBillServicePointMeteredUsageID($billServicePointMeteredUsageID)
            ->setBillServicePointID($billServicePointID)
            ->setMeterReadID($meterReadID)
            ->setServicePointMeterID($servicePointMeterID)
            ->setRateValue($rateValue)
            ->setCurrentMeterRead($currentMeterRead)
            ->setPreviousMeterRead($previousMeterRead)
            ->setUsageStartDate($usageStartDate)
            ->setUsageEndDate($usageEndDate)
            ->setUsageAmount($usageAmount)
            ->setUnitOfMeasureID($unitOfMeasureID)
            ->setCreateDate($createDate)
            ->setMeterNumber($meterNumber)
            ->setMeterType($meterType)
            ->setMeterMultiplier($meterMultiplier);
    }
    /**
     * Get BillServicePointMeteredUsageID value
     * @return int
     */
    public function getBillServicePointMeteredUsageID()
    {
        return $this->BillServicePointMeteredUsageID;
    }
    /**
     * Set BillServicePointMeteredUsageID value
     * @param int $billServicePointMeteredUsageID
     * @return \SGCIS\Struct\BillServicePointMeteredUsage
     */
    public function setBillServicePointMeteredUsageID($billServicePointMeteredUsageID = null)
    {
        // validation for constraint: int
        if (!is_null($billServicePointMeteredUsageID) && !is_numeric($billServicePointMeteredUsageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billServicePointMeteredUsageID)), __LINE__);
        }
        $this->BillServicePointMeteredUsageID = $billServicePointMeteredUsageID;
        return $this;
    }
    /**
     * Get BillServicePointID value
     * @return int
     */
    public function getBillServicePointID()
    {
        return $this->BillServicePointID;
    }
    /**
     * Set BillServicePointID value
     * @param int $billServicePointID
     * @return \SGCIS\Struct\BillServicePointMeteredUsage
     */
    public function setBillServicePointID($billServicePointID = null)
    {
        // validation for constraint: int
        if (!is_null($billServicePointID) && !is_numeric($billServicePointID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billServicePointID)), __LINE__);
        }
        $this->BillServicePointID = $billServicePointID;
        return $this;
    }
    /**
     * Get MeterReadID value
     * @return int
     */
    public function getMeterReadID()
    {
        return $this->MeterReadID;
    }
    /**
     * Set MeterReadID value
     * @param int $meterReadID
     * @return \SGCIS\Struct\BillServicePointMeteredUsage
     */
    public function setMeterReadID($meterReadID = null)
    {
        // validation for constraint: int
        if (!is_null($meterReadID) && !is_numeric($meterReadID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($meterReadID)), __LINE__);
        }
        $this->MeterReadID = $meterReadID;
        return $this;
    }
    /**
     * Get ServicePointMeterID value
     * @return int
     */
    public function getServicePointMeterID()
    {
        return $this->ServicePointMeterID;
    }
    /**
     * Set ServicePointMeterID value
     * @param int $servicePointMeterID
     * @return \SGCIS\Struct\BillServicePointMeteredUsage
     */
    public function setServicePointMeterID($servicePointMeterID = null)
    {
        // validation for constraint: int
        if (!is_null($servicePointMeterID) && !is_numeric($servicePointMeterID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($servicePointMeterID)), __LINE__);
        }
        $this->ServicePointMeterID = $servicePointMeterID;
        return $this;
    }
    /**
     * Get RateValue value
     * @return float
     */
    public function getRateValue()
    {
        return $this->RateValue;
    }
    /**
     * Set RateValue value
     * @param float $rateValue
     * @return \SGCIS\Struct\BillServicePointMeteredUsage
     */
    public function setRateValue($rateValue = null)
    {
        $this->RateValue = $rateValue;
        return $this;
    }
    /**
     * Get CurrentMeterRead value
     * @return float
     */
    public function getCurrentMeterRead()
    {
        return $this->CurrentMeterRead;
    }
    /**
     * Set CurrentMeterRead value
     * @param float $currentMeterRead
     * @return \SGCIS\Struct\BillServicePointMeteredUsage
     */
    public function setCurrentMeterRead($currentMeterRead = null)
    {
        $this->CurrentMeterRead = $currentMeterRead;
        return $this;
    }
    /**
     * Get PreviousMeterRead value
     * @return float
     */
    public function getPreviousMeterRead()
    {
        return $this->PreviousMeterRead;
    }
    /**
     * Set PreviousMeterRead value
     * @param float $previousMeterRead
     * @return \SGCIS\Struct\BillServicePointMeteredUsage
     */
    public function setPreviousMeterRead($previousMeterRead = null)
    {
        $this->PreviousMeterRead = $previousMeterRead;
        return $this;
    }
    /**
     * Get UsageStartDate value
     * @return string
     */
    public function getUsageStartDate()
    {
        return $this->UsageStartDate;
    }
    /**
     * Set UsageStartDate value
     * @param string $usageStartDate
     * @return \SGCIS\Struct\BillServicePointMeteredUsage
     */
    public function setUsageStartDate($usageStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($usageStartDate) && !is_string($usageStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($usageStartDate)), __LINE__);
        }
        $this->UsageStartDate = $usageStartDate;
        return $this;
    }
    /**
     * Get UsageEndDate value
     * @return string
     */
    public function getUsageEndDate()
    {
        return $this->UsageEndDate;
    }
    /**
     * Set UsageEndDate value
     * @param string $usageEndDate
     * @return \SGCIS\Struct\BillServicePointMeteredUsage
     */
    public function setUsageEndDate($usageEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($usageEndDate) && !is_string($usageEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($usageEndDate)), __LINE__);
        }
        $this->UsageEndDate = $usageEndDate;
        return $this;
    }
    /**
     * Get UsageAmount value
     * @return float
     */
    public function getUsageAmount()
    {
        return $this->UsageAmount;
    }
    /**
     * Set UsageAmount value
     * @param float $usageAmount
     * @return \SGCIS\Struct\BillServicePointMeteredUsage
     */
    public function setUsageAmount($usageAmount = null)
    {
        $this->UsageAmount = $usageAmount;
        return $this;
    }
    /**
     * Get UnitOfMeasureID value
     * @return int
     */
    public function getUnitOfMeasureID()
    {
        return $this->UnitOfMeasureID;
    }
    /**
     * Set UnitOfMeasureID value
     * @param int $unitOfMeasureID
     * @return \SGCIS\Struct\BillServicePointMeteredUsage
     */
    public function setUnitOfMeasureID($unitOfMeasureID = null)
    {
        // validation for constraint: int
        if (!is_null($unitOfMeasureID) && !is_numeric($unitOfMeasureID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($unitOfMeasureID)), __LINE__);
        }
        $this->UnitOfMeasureID = $unitOfMeasureID;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\BillServicePointMeteredUsage
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get MeterNumber value
     * @return string|null
     */
    public function getMeterNumber()
    {
        return $this->MeterNumber;
    }
    /**
     * Set MeterNumber value
     * @param string $meterNumber
     * @return \SGCIS\Struct\BillServicePointMeteredUsage
     */
    public function setMeterNumber($meterNumber = null)
    {
        // validation for constraint: string
        if (!is_null($meterNumber) && !is_string($meterNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meterNumber)), __LINE__);
        }
        $this->MeterNumber = $meterNumber;
        return $this;
    }
    /**
     * Get MeterType value
     * @return string|null
     */
    public function getMeterType()
    {
        return $this->MeterType;
    }
    /**
     * Set MeterType value
     * @param string $meterType
     * @return \SGCIS\Struct\BillServicePointMeteredUsage
     */
    public function setMeterType($meterType = null)
    {
        // validation for constraint: string
        if (!is_null($meterType) && !is_string($meterType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meterType)), __LINE__);
        }
        $this->MeterType = $meterType;
        return $this;
    }
    /**
     * Get MeterMultiplier value
     * @return string|null
     */
    public function getMeterMultiplier()
    {
        return $this->MeterMultiplier;
    }
    /**
     * Set MeterMultiplier value
     * @param string $meterMultiplier
     * @return \SGCIS\Struct\BillServicePointMeteredUsage
     */
    public function setMeterMultiplier($meterMultiplier = null)
    {
        // validation for constraint: string
        if (!is_null($meterMultiplier) && !is_string($meterMultiplier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meterMultiplier)), __LINE__);
        }
        $this->MeterMultiplier = $meterMultiplier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\BillServicePointMeteredUsage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
