<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillServicePointContractDetail Struct
 * @subpackage Structs
 */
class BillServicePointContractDetail extends AbstractStructBase
{
    /**
     * The BillServicePointContractDetailID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillServicePointContractDetailID;
    /**
     * The BillServicePointID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillServicePointID;
    /**
     * The ServiceAgreementID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServiceAgreementID;
    /**
     * The ContractStartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ContractStartDate;
    /**
     * The ContractEndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ContractEndDate;
    /**
     * The UsageAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $UsageAmount;
    /**
     * The AverageRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AverageRate;
    /**
     * The DollarAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DollarAmount;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The ProductName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductName;
    /**
     * Constructor method for BillServicePointContractDetail
     * @uses BillServicePointContractDetail::setBillServicePointContractDetailID()
     * @uses BillServicePointContractDetail::setBillServicePointID()
     * @uses BillServicePointContractDetail::setServiceAgreementID()
     * @uses BillServicePointContractDetail::setContractStartDate()
     * @uses BillServicePointContractDetail::setContractEndDate()
     * @uses BillServicePointContractDetail::setUsageAmount()
     * @uses BillServicePointContractDetail::setAverageRate()
     * @uses BillServicePointContractDetail::setDollarAmount()
     * @uses BillServicePointContractDetail::setCreateDate()
     * @uses BillServicePointContractDetail::setProductName()
     * @param int $billServicePointContractDetailID
     * @param int $billServicePointID
     * @param int $serviceAgreementID
     * @param string $contractStartDate
     * @param string $contractEndDate
     * @param float $usageAmount
     * @param float $averageRate
     * @param float $dollarAmount
     * @param string $createDate
     * @param string $productName
     */
    public function __construct($billServicePointContractDetailID = null, $billServicePointID = null, $serviceAgreementID = null, $contractStartDate = null, $contractEndDate = null, $usageAmount = null, $averageRate = null, $dollarAmount = null, $createDate = null, $productName = null)
    {
        $this
            ->setBillServicePointContractDetailID($billServicePointContractDetailID)
            ->setBillServicePointID($billServicePointID)
            ->setServiceAgreementID($serviceAgreementID)
            ->setContractStartDate($contractStartDate)
            ->setContractEndDate($contractEndDate)
            ->setUsageAmount($usageAmount)
            ->setAverageRate($averageRate)
            ->setDollarAmount($dollarAmount)
            ->setCreateDate($createDate)
            ->setProductName($productName);
    }
    /**
     * Get BillServicePointContractDetailID value
     * @return int
     */
    public function getBillServicePointContractDetailID()
    {
        return $this->BillServicePointContractDetailID;
    }
    /**
     * Set BillServicePointContractDetailID value
     * @param int $billServicePointContractDetailID
     * @return \SGCIS\Struct\BillServicePointContractDetail
     */
    public function setBillServicePointContractDetailID($billServicePointContractDetailID = null)
    {
        // validation for constraint: int
        if (!is_null($billServicePointContractDetailID) && !is_numeric($billServicePointContractDetailID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billServicePointContractDetailID)), __LINE__);
        }
        $this->BillServicePointContractDetailID = $billServicePointContractDetailID;
        return $this;
    }
    /**
     * Get BillServicePointID value
     * @return int
     */
    public function getBillServicePointID()
    {
        return $this->BillServicePointID;
    }
    /**
     * Set BillServicePointID value
     * @param int $billServicePointID
     * @return \SGCIS\Struct\BillServicePointContractDetail
     */
    public function setBillServicePointID($billServicePointID = null)
    {
        // validation for constraint: int
        if (!is_null($billServicePointID) && !is_numeric($billServicePointID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billServicePointID)), __LINE__);
        }
        $this->BillServicePointID = $billServicePointID;
        return $this;
    }
    /**
     * Get ServiceAgreementID value
     * @return int
     */
    public function getServiceAgreementID()
    {
        return $this->ServiceAgreementID;
    }
    /**
     * Set ServiceAgreementID value
     * @param int $serviceAgreementID
     * @return \SGCIS\Struct\BillServicePointContractDetail
     */
    public function setServiceAgreementID($serviceAgreementID = null)
    {
        // validation for constraint: int
        if (!is_null($serviceAgreementID) && !is_numeric($serviceAgreementID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serviceAgreementID)), __LINE__);
        }
        $this->ServiceAgreementID = $serviceAgreementID;
        return $this;
    }
    /**
     * Get ContractStartDate value
     * @return string
     */
    public function getContractStartDate()
    {
        return $this->ContractStartDate;
    }
    /**
     * Set ContractStartDate value
     * @param string $contractStartDate
     * @return \SGCIS\Struct\BillServicePointContractDetail
     */
    public function setContractStartDate($contractStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($contractStartDate) && !is_string($contractStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contractStartDate)), __LINE__);
        }
        $this->ContractStartDate = $contractStartDate;
        return $this;
    }
    /**
     * Get ContractEndDate value
     * @return string
     */
    public function getContractEndDate()
    {
        return $this->ContractEndDate;
    }
    /**
     * Set ContractEndDate value
     * @param string $contractEndDate
     * @return \SGCIS\Struct\BillServicePointContractDetail
     */
    public function setContractEndDate($contractEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($contractEndDate) && !is_string($contractEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contractEndDate)), __LINE__);
        }
        $this->ContractEndDate = $contractEndDate;
        return $this;
    }
    /**
     * Get UsageAmount value
     * @return float
     */
    public function getUsageAmount()
    {
        return $this->UsageAmount;
    }
    /**
     * Set UsageAmount value
     * @param float $usageAmount
     * @return \SGCIS\Struct\BillServicePointContractDetail
     */
    public function setUsageAmount($usageAmount = null)
    {
        $this->UsageAmount = $usageAmount;
        return $this;
    }
    /**
     * Get AverageRate value
     * @return float
     */
    public function getAverageRate()
    {
        return $this->AverageRate;
    }
    /**
     * Set AverageRate value
     * @param float $averageRate
     * @return \SGCIS\Struct\BillServicePointContractDetail
     */
    public function setAverageRate($averageRate = null)
    {
        $this->AverageRate = $averageRate;
        return $this;
    }
    /**
     * Get DollarAmount value
     * @return float
     */
    public function getDollarAmount()
    {
        return $this->DollarAmount;
    }
    /**
     * Set DollarAmount value
     * @param float $dollarAmount
     * @return \SGCIS\Struct\BillServicePointContractDetail
     */
    public function setDollarAmount($dollarAmount = null)
    {
        $this->DollarAmount = $dollarAmount;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\BillServicePointContractDetail
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get ProductName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->ProductName;
    }
    /**
     * Set ProductName value
     * @param string $productName
     * @return \SGCIS\Struct\BillServicePointContractDetail
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productName)), __LINE__);
        }
        $this->ProductName = $productName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\BillServicePointContractDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
