<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillServicePointCharge Struct
 * @subpackage Structs
 */
class BillServicePointCharge extends AbstractStructBase
{
    /**
     * The BillServicePointChargeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillServicePointChargeID;
    /**
     * The BillServicePointID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillServicePointID;
    /**
     * The BillSectionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillSectionID;
    /**
     * The BillAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BillAmount;
    /**
     * The BillServicePointChargeTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillServicePointChargeTypeID;
    /**
     * The InvoiceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InvoiceID;
    /**
     * The DisplayOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DisplayOrder;
    /**
     * The IsPaidOff
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPaidOff;
    /**
     * The IsApproved
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsApproved;
    /**
     * The MarketTransactionDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MarketTransactionDate;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The Consumption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Consumption;
    /**
     * The DiscountRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DiscountRate;
    /**
     * The ChargeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChargeID;
    /**
     * The IsBaseCharge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsBaseCharge;
    /**
     * The CancelRebillChargeTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CancelRebillChargeTypeID;
    /**
     * The AccountServicePointID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountServicePointID;
    /**
     * The BillDisplay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillDisplay;
    /**
     * The BillServicePointChargeTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillServicePointChargeTypeName;
    /**
     * The InvoiceNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceNumber;
    /**
     * The DocumentTrackingNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentTrackingNumber;
    /**
     * The ServicePointChargeDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfBillServicePointChargeDetail
     */
    public $ServicePointChargeDetails;
    /**
     * The ServiceProviderIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceProviderIdentifier;
    /**
     * The CchGroupTaxList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfCCHGroupTax
     */
    public $CchGroupTaxList;
    /**
     * The BillServicePointChargeCharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfBillServicePointChargeCharge
     */
    public $BillServicePointChargeCharges;
    /**
     * Constructor method for BillServicePointCharge
     * @uses BillServicePointCharge::setBillServicePointChargeID()
     * @uses BillServicePointCharge::setBillServicePointID()
     * @uses BillServicePointCharge::setBillSectionID()
     * @uses BillServicePointCharge::setBillAmount()
     * @uses BillServicePointCharge::setBillServicePointChargeTypeID()
     * @uses BillServicePointCharge::setInvoiceID()
     * @uses BillServicePointCharge::setDisplayOrder()
     * @uses BillServicePointCharge::setIsPaidOff()
     * @uses BillServicePointCharge::setIsApproved()
     * @uses BillServicePointCharge::setMarketTransactionDate()
     * @uses BillServicePointCharge::setCreateDate()
     * @uses BillServicePointCharge::setConsumption()
     * @uses BillServicePointCharge::setDiscountRate()
     * @uses BillServicePointCharge::setChargeID()
     * @uses BillServicePointCharge::setIsBaseCharge()
     * @uses BillServicePointCharge::setCancelRebillChargeTypeID()
     * @uses BillServicePointCharge::setAccountServicePointID()
     * @uses BillServicePointCharge::setBillDisplay()
     * @uses BillServicePointCharge::setBillServicePointChargeTypeName()
     * @uses BillServicePointCharge::setInvoiceNumber()
     * @uses BillServicePointCharge::setDocumentTrackingNumber()
     * @uses BillServicePointCharge::setServicePointChargeDetails()
     * @uses BillServicePointCharge::setServiceProviderIdentifier()
     * @uses BillServicePointCharge::setCchGroupTaxList()
     * @uses BillServicePointCharge::setBillServicePointChargeCharges()
     * @param int $billServicePointChargeID
     * @param int $billServicePointID
     * @param int $billSectionID
     * @param float $billAmount
     * @param int $billServicePointChargeTypeID
     * @param int $invoiceID
     * @param int $displayOrder
     * @param bool $isPaidOff
     * @param bool $isApproved
     * @param string $marketTransactionDate
     * @param string $createDate
     * @param float $consumption
     * @param float $discountRate
     * @param int $chargeID
     * @param bool $isBaseCharge
     * @param int $cancelRebillChargeTypeID
     * @param int $accountServicePointID
     * @param string $billDisplay
     * @param string $billServicePointChargeTypeName
     * @param string $invoiceNumber
     * @param string $documentTrackingNumber
     * @param \SGCIS\Array\ArrayOfBillServicePointChargeDetail $servicePointChargeDetails
     * @param string $serviceProviderIdentifier
     * @param \SGCIS\Array\ArrayOfCCHGroupTax $cchGroupTaxList
     * @param \SGCIS\Array\ArrayOfBillServicePointChargeCharge $billServicePointChargeCharges
     */
    public function __construct($billServicePointChargeID = null, $billServicePointID = null, $billSectionID = null, $billAmount = null, $billServicePointChargeTypeID = null, $invoiceID = null, $displayOrder = null, $isPaidOff = null, $isApproved = null, $marketTransactionDate = null, $createDate = null, $consumption = null, $discountRate = null, $chargeID = null, $isBaseCharge = null, $cancelRebillChargeTypeID = null, $accountServicePointID = null, $billDisplay = null, $billServicePointChargeTypeName = null, $invoiceNumber = null, $documentTrackingNumber = null, \SGCIS\Array\ArrayOfBillServicePointChargeDetail $servicePointChargeDetails = null, $serviceProviderIdentifier = null, \SGCIS\Array\ArrayOfCCHGroupTax $cchGroupTaxList = null, \SGCIS\Array\ArrayOfBillServicePointChargeCharge $billServicePointChargeCharges = null)
    {
        $this
            ->setBillServicePointChargeID($billServicePointChargeID)
            ->setBillServicePointID($billServicePointID)
            ->setBillSectionID($billSectionID)
            ->setBillAmount($billAmount)
            ->setBillServicePointChargeTypeID($billServicePointChargeTypeID)
            ->setInvoiceID($invoiceID)
            ->setDisplayOrder($displayOrder)
            ->setIsPaidOff($isPaidOff)
            ->setIsApproved($isApproved)
            ->setMarketTransactionDate($marketTransactionDate)
            ->setCreateDate($createDate)
            ->setConsumption($consumption)
            ->setDiscountRate($discountRate)
            ->setChargeID($chargeID)
            ->setIsBaseCharge($isBaseCharge)
            ->setCancelRebillChargeTypeID($cancelRebillChargeTypeID)
            ->setAccountServicePointID($accountServicePointID)
            ->setBillDisplay($billDisplay)
            ->setBillServicePointChargeTypeName($billServicePointChargeTypeName)
            ->setInvoiceNumber($invoiceNumber)
            ->setDocumentTrackingNumber($documentTrackingNumber)
            ->setServicePointChargeDetails($servicePointChargeDetails)
            ->setServiceProviderIdentifier($serviceProviderIdentifier)
            ->setCchGroupTaxList($cchGroupTaxList)
            ->setBillServicePointChargeCharges($billServicePointChargeCharges);
    }
    /**
     * Get BillServicePointChargeID value
     * @return int
     */
    public function getBillServicePointChargeID()
    {
        return $this->BillServicePointChargeID;
    }
    /**
     * Set BillServicePointChargeID value
     * @param int $billServicePointChargeID
     * @return \SGCIS\Struct\BillServicePointCharge
     */
    public function setBillServicePointChargeID($billServicePointChargeID = null)
    {
        // validation for constraint: int
        if (!is_null($billServicePointChargeID) && !is_numeric($billServicePointChargeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billServicePointChargeID)), __LINE__);
        }
        $this->BillServicePointChargeID = $billServicePointChargeID;
        return $this;
    }
    /**
     * Get BillServicePointID value
     * @return int
     */
    public function getBillServicePointID()
    {
        return $this->BillServicePointID;
    }
    /**
     * Set BillServicePointID value
     * @param int $billServicePointID
     * @return \SGCIS\Struct\BillServicePointCharge
     */
    public function setBillServicePointID($billServicePointID = null)
    {
        // validation for constraint: int
        if (!is_null($billServicePointID) && !is_numeric($billServicePointID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billServicePointID)), __LINE__);
        }
        $this->BillServicePointID = $billServicePointID;
        return $this;
    }
    /**
     * Get BillSectionID value
     * @return int
     */
    public function getBillSectionID()
    {
        return $this->BillSectionID;
    }
    /**
     * Set BillSectionID value
     * @param int $billSectionID
     * @return \SGCIS\Struct\BillServicePointCharge
     */
    public function setBillSectionID($billSectionID = null)
    {
        // validation for constraint: int
        if (!is_null($billSectionID) && !is_numeric($billSectionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billSectionID)), __LINE__);
        }
        $this->BillSectionID = $billSectionID;
        return $this;
    }
    /**
     * Get BillAmount value
     * @return float
     */
    public function getBillAmount()
    {
        return $this->BillAmount;
    }
    /**
     * Set BillAmount value
     * @param float $billAmount
     * @return \SGCIS\Struct\BillServicePointCharge
     */
    public function setBillAmount($billAmount = null)
    {
        $this->BillAmount = $billAmount;
        return $this;
    }
    /**
     * Get BillServicePointChargeTypeID value
     * @return int
     */
    public function getBillServicePointChargeTypeID()
    {
        return $this->BillServicePointChargeTypeID;
    }
    /**
     * Set BillServicePointChargeTypeID value
     * @param int $billServicePointChargeTypeID
     * @return \SGCIS\Struct\BillServicePointCharge
     */
    public function setBillServicePointChargeTypeID($billServicePointChargeTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($billServicePointChargeTypeID) && !is_numeric($billServicePointChargeTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billServicePointChargeTypeID)), __LINE__);
        }
        $this->BillServicePointChargeTypeID = $billServicePointChargeTypeID;
        return $this;
    }
    /**
     * Get InvoiceID value
     * @return int
     */
    public function getInvoiceID()
    {
        return $this->InvoiceID;
    }
    /**
     * Set InvoiceID value
     * @param int $invoiceID
     * @return \SGCIS\Struct\BillServicePointCharge
     */
    public function setInvoiceID($invoiceID = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceID) && !is_numeric($invoiceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($invoiceID)), __LINE__);
        }
        $this->InvoiceID = $invoiceID;
        return $this;
    }
    /**
     * Get DisplayOrder value
     * @return int
     */
    public function getDisplayOrder()
    {
        return $this->DisplayOrder;
    }
    /**
     * Set DisplayOrder value
     * @param int $displayOrder
     * @return \SGCIS\Struct\BillServicePointCharge
     */
    public function setDisplayOrder($displayOrder = null)
    {
        // validation for constraint: int
        if (!is_null($displayOrder) && !is_numeric($displayOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($displayOrder)), __LINE__);
        }
        $this->DisplayOrder = $displayOrder;
        return $this;
    }
    /**
     * Get IsPaidOff value
     * @return bool
     */
    public function getIsPaidOff()
    {
        return $this->IsPaidOff;
    }
    /**
     * Set IsPaidOff value
     * @param bool $isPaidOff
     * @return \SGCIS\Struct\BillServicePointCharge
     */
    public function setIsPaidOff($isPaidOff = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPaidOff) && !is_bool($isPaidOff)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPaidOff)), __LINE__);
        }
        $this->IsPaidOff = $isPaidOff;
        return $this;
    }
    /**
     * Get IsApproved value
     * @return bool
     */
    public function getIsApproved()
    {
        return $this->IsApproved;
    }
    /**
     * Set IsApproved value
     * @param bool $isApproved
     * @return \SGCIS\Struct\BillServicePointCharge
     */
    public function setIsApproved($isApproved = null)
    {
        // validation for constraint: boolean
        if (!is_null($isApproved) && !is_bool($isApproved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isApproved)), __LINE__);
        }
        $this->IsApproved = $isApproved;
        return $this;
    }
    /**
     * Get MarketTransactionDate value
     * @return string
     */
    public function getMarketTransactionDate()
    {
        return $this->MarketTransactionDate;
    }
    /**
     * Set MarketTransactionDate value
     * @param string $marketTransactionDate
     * @return \SGCIS\Struct\BillServicePointCharge
     */
    public function setMarketTransactionDate($marketTransactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($marketTransactionDate) && !is_string($marketTransactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($marketTransactionDate)), __LINE__);
        }
        $this->MarketTransactionDate = $marketTransactionDate;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\BillServicePointCharge
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get Consumption value
     * @return float
     */
    public function getConsumption()
    {
        return $this->Consumption;
    }
    /**
     * Set Consumption value
     * @param float $consumption
     * @return \SGCIS\Struct\BillServicePointCharge
     */
    public function setConsumption($consumption = null)
    {
        $this->Consumption = $consumption;
        return $this;
    }
    /**
     * Get DiscountRate value
     * @return float
     */
    public function getDiscountRate()
    {
        return $this->DiscountRate;
    }
    /**
     * Set DiscountRate value
     * @param float $discountRate
     * @return \SGCIS\Struct\BillServicePointCharge
     */
    public function setDiscountRate($discountRate = null)
    {
        $this->DiscountRate = $discountRate;
        return $this;
    }
    /**
     * Get ChargeID value
     * @return int
     */
    public function getChargeID()
    {
        return $this->ChargeID;
    }
    /**
     * Set ChargeID value
     * @param int $chargeID
     * @return \SGCIS\Struct\BillServicePointCharge
     */
    public function setChargeID($chargeID = null)
    {
        // validation for constraint: int
        if (!is_null($chargeID) && !is_numeric($chargeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeID)), __LINE__);
        }
        $this->ChargeID = $chargeID;
        return $this;
    }
    /**
     * Get IsBaseCharge value
     * @return bool
     */
    public function getIsBaseCharge()
    {
        return $this->IsBaseCharge;
    }
    /**
     * Set IsBaseCharge value
     * @param bool $isBaseCharge
     * @return \SGCIS\Struct\BillServicePointCharge
     */
    public function setIsBaseCharge($isBaseCharge = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBaseCharge) && !is_bool($isBaseCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isBaseCharge)), __LINE__);
        }
        $this->IsBaseCharge = $isBaseCharge;
        return $this;
    }
    /**
     * Get CancelRebillChargeTypeID value
     * @return int
     */
    public function getCancelRebillChargeTypeID()
    {
        return $this->CancelRebillChargeTypeID;
    }
    /**
     * Set CancelRebillChargeTypeID value
     * @param int $cancelRebillChargeTypeID
     * @return \SGCIS\Struct\BillServicePointCharge
     */
    public function setCancelRebillChargeTypeID($cancelRebillChargeTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($cancelRebillChargeTypeID) && !is_numeric($cancelRebillChargeTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cancelRebillChargeTypeID)), __LINE__);
        }
        $this->CancelRebillChargeTypeID = $cancelRebillChargeTypeID;
        return $this;
    }
    /**
     * Get AccountServicePointID value
     * @return int
     */
    public function getAccountServicePointID()
    {
        return $this->AccountServicePointID;
    }
    /**
     * Set AccountServicePointID value
     * @param int $accountServicePointID
     * @return \SGCIS\Struct\BillServicePointCharge
     */
    public function setAccountServicePointID($accountServicePointID = null)
    {
        // validation for constraint: int
        if (!is_null($accountServicePointID) && !is_numeric($accountServicePointID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountServicePointID)), __LINE__);
        }
        $this->AccountServicePointID = $accountServicePointID;
        return $this;
    }
    /**
     * Get BillDisplay value
     * @return string|null
     */
    public function getBillDisplay()
    {
        return $this->BillDisplay;
    }
    /**
     * Set BillDisplay value
     * @param string $billDisplay
     * @return \SGCIS\Struct\BillServicePointCharge
     */
    public function setBillDisplay($billDisplay = null)
    {
        // validation for constraint: string
        if (!is_null($billDisplay) && !is_string($billDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billDisplay)), __LINE__);
        }
        $this->BillDisplay = $billDisplay;
        return $this;
    }
    /**
     * Get BillServicePointChargeTypeName value
     * @return string|null
     */
    public function getBillServicePointChargeTypeName()
    {
        return $this->BillServicePointChargeTypeName;
    }
    /**
     * Set BillServicePointChargeTypeName value
     * @param string $billServicePointChargeTypeName
     * @return \SGCIS\Struct\BillServicePointCharge
     */
    public function setBillServicePointChargeTypeName($billServicePointChargeTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($billServicePointChargeTypeName) && !is_string($billServicePointChargeTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billServicePointChargeTypeName)), __LINE__);
        }
        $this->BillServicePointChargeTypeName = $billServicePointChargeTypeName;
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->InvoiceNumber;
    }
    /**
     * Set InvoiceNumber value
     * @param string $invoiceNumber
     * @return \SGCIS\Struct\BillServicePointCharge
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoiceNumber)), __LINE__);
        }
        $this->InvoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get DocumentTrackingNumber value
     * @return string|null
     */
    public function getDocumentTrackingNumber()
    {
        return $this->DocumentTrackingNumber;
    }
    /**
     * Set DocumentTrackingNumber value
     * @param string $documentTrackingNumber
     * @return \SGCIS\Struct\BillServicePointCharge
     */
    public function setDocumentTrackingNumber($documentTrackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($documentTrackingNumber) && !is_string($documentTrackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentTrackingNumber)), __LINE__);
        }
        $this->DocumentTrackingNumber = $documentTrackingNumber;
        return $this;
    }
    /**
     * Get ServicePointChargeDetails value
     * @return \SGCIS\Array\ArrayOfBillServicePointChargeDetail|null
     */
    public function getServicePointChargeDetails()
    {
        return $this->ServicePointChargeDetails;
    }
    /**
     * Set ServicePointChargeDetails value
     * @param \SGCIS\Array\ArrayOfBillServicePointChargeDetail $servicePointChargeDetails
     * @return \SGCIS\Struct\BillServicePointCharge
     */
    public function setServicePointChargeDetails(\SGCIS\Array\ArrayOfBillServicePointChargeDetail $servicePointChargeDetails = null)
    {
        $this->ServicePointChargeDetails = $servicePointChargeDetails;
        return $this;
    }
    /**
     * Get ServiceProviderIdentifier value
     * @return string|null
     */
    public function getServiceProviderIdentifier()
    {
        return $this->ServiceProviderIdentifier;
    }
    /**
     * Set ServiceProviderIdentifier value
     * @param string $serviceProviderIdentifier
     * @return \SGCIS\Struct\BillServicePointCharge
     */
    public function setServiceProviderIdentifier($serviceProviderIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($serviceProviderIdentifier) && !is_string($serviceProviderIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceProviderIdentifier)), __LINE__);
        }
        $this->ServiceProviderIdentifier = $serviceProviderIdentifier;
        return $this;
    }
    /**
     * Get CchGroupTaxList value
     * @return \SGCIS\Array\ArrayOfCCHGroupTax|null
     */
    public function getCchGroupTaxList()
    {
        return $this->CchGroupTaxList;
    }
    /**
     * Set CchGroupTaxList value
     * @param \SGCIS\Array\ArrayOfCCHGroupTax $cchGroupTaxList
     * @return \SGCIS\Struct\BillServicePointCharge
     */
    public function setCchGroupTaxList(\SGCIS\Array\ArrayOfCCHGroupTax $cchGroupTaxList = null)
    {
        $this->CchGroupTaxList = $cchGroupTaxList;
        return $this;
    }
    /**
     * Get BillServicePointChargeCharges value
     * @return \SGCIS\Array\ArrayOfBillServicePointChargeCharge|null
     */
    public function getBillServicePointChargeCharges()
    {
        return $this->BillServicePointChargeCharges;
    }
    /**
     * Set BillServicePointChargeCharges value
     * @param \SGCIS\Array\ArrayOfBillServicePointChargeCharge $billServicePointChargeCharges
     * @return \SGCIS\Struct\BillServicePointCharge
     */
    public function setBillServicePointChargeCharges(\SGCIS\Array\ArrayOfBillServicePointChargeCharge $billServicePointChargeCharges = null)
    {
        $this->BillServicePointChargeCharges = $billServicePointChargeCharges;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\BillServicePointCharge
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
