<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AutoPaymentRequest Struct
 * @subpackage Structs
 */
class AutoPaymentRequest extends ServiceRequestBase
{
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The AccountAutoPayID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountAutoPayID;
    /**
     * The InactivateAutoPayment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $InactivateAutoPayment;
    /**
     * The AutoPay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\AccountAutoPay
     */
    public $AutoPay;
    /**
     * Constructor method for AutoPaymentRequest
     * @uses AutoPaymentRequest::setAccountID()
     * @uses AutoPaymentRequest::setAccountAutoPayID()
     * @uses AutoPaymentRequest::setInactivateAutoPayment()
     * @uses AutoPaymentRequest::setAutoPay()
     * @param int $accountID
     * @param int $accountAutoPayID
     * @param bool $inactivateAutoPayment
     * @param \SGCIS\Struct\AccountAutoPay $autoPay
     */
    public function __construct($accountID = null, $accountAutoPayID = null, $inactivateAutoPayment = null, \SGCIS\Struct\AccountAutoPay $autoPay = null)
    {
        $this
            ->setAccountID($accountID)
            ->setAccountAutoPayID($accountAutoPayID)
            ->setInactivateAutoPayment($inactivateAutoPayment)
            ->setAutoPay($autoPay);
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\AutoPaymentRequest
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get AccountAutoPayID value
     * @return int
     */
    public function getAccountAutoPayID()
    {
        return $this->AccountAutoPayID;
    }
    /**
     * Set AccountAutoPayID value
     * @param int $accountAutoPayID
     * @return \SGCIS\Struct\AutoPaymentRequest
     */
    public function setAccountAutoPayID($accountAutoPayID = null)
    {
        // validation for constraint: int
        if (!is_null($accountAutoPayID) && !is_numeric($accountAutoPayID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountAutoPayID)), __LINE__);
        }
        $this->AccountAutoPayID = $accountAutoPayID;
        return $this;
    }
    /**
     * Get InactivateAutoPayment value
     * @return bool
     */
    public function getInactivateAutoPayment()
    {
        return $this->InactivateAutoPayment;
    }
    /**
     * Set InactivateAutoPayment value
     * @param bool $inactivateAutoPayment
     * @return \SGCIS\Struct\AutoPaymentRequest
     */
    public function setInactivateAutoPayment($inactivateAutoPayment = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactivateAutoPayment) && !is_bool($inactivateAutoPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($inactivateAutoPayment)), __LINE__);
        }
        $this->InactivateAutoPayment = $inactivateAutoPayment;
        return $this;
    }
    /**
     * Get AutoPay value
     * @return \SGCIS\Struct\AccountAutoPay|null
     */
    public function getAutoPay()
    {
        return $this->AutoPay;
    }
    /**
     * Set AutoPay value
     * @param \SGCIS\Struct\AccountAutoPay $autoPay
     * @return \SGCIS\Struct\AutoPaymentRequest
     */
    public function setAutoPay(\SGCIS\Struct\AccountAutoPay $autoPay = null)
    {
        $this->AutoPay = $autoPay;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AutoPaymentRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
