<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AutoPayMetaDataResponse Struct
 * @subpackage Structs
 */
class AutoPayMetaDataResponse extends ServiceResponseBase
{
    /**
     * The PaymentTenderTypes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfPaymentTenderType
     */
    public $PaymentTenderTypes;
    /**
     * The AutoPayEvents
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfSystemEvent
     */
    public $AutoPayEvents;
    /**
     * Constructor method for AutoPayMetaDataResponse
     * @uses AutoPayMetaDataResponse::setPaymentTenderTypes()
     * @uses AutoPayMetaDataResponse::setAutoPayEvents()
     * @param \SGCIS\Array\ArrayOfPaymentTenderType $paymentTenderTypes
     * @param \SGCIS\Array\ArrayOfSystemEvent $autoPayEvents
     */
    public function __construct(\SGCIS\Array\ArrayOfPaymentTenderType $paymentTenderTypes = null, \SGCIS\Array\ArrayOfSystemEvent $autoPayEvents = null)
    {
        $this
            ->setPaymentTenderTypes($paymentTenderTypes)
            ->setAutoPayEvents($autoPayEvents);
    }
    /**
     * Get PaymentTenderTypes value
     * @return \SGCIS\Array\ArrayOfPaymentTenderType|null
     */
    public function getPaymentTenderTypes()
    {
        return $this->PaymentTenderTypes;
    }
    /**
     * Set PaymentTenderTypes value
     * @param \SGCIS\Array\ArrayOfPaymentTenderType $paymentTenderTypes
     * @return \SGCIS\Struct\AutoPayMetaDataResponse
     */
    public function setPaymentTenderTypes(\SGCIS\Array\ArrayOfPaymentTenderType $paymentTenderTypes = null)
    {
        $this->PaymentTenderTypes = $paymentTenderTypes;
        return $this;
    }
    /**
     * Get AutoPayEvents value
     * @return \SGCIS\Array\ArrayOfSystemEvent|null
     */
    public function getAutoPayEvents()
    {
        return $this->AutoPayEvents;
    }
    /**
     * Set AutoPayEvents value
     * @param \SGCIS\Array\ArrayOfSystemEvent $autoPayEvents
     * @return \SGCIS\Struct\AutoPayMetaDataResponse
     */
    public function setAutoPayEvents(\SGCIS\Array\ArrayOfSystemEvent $autoPayEvents = null)
    {
        $this->AutoPayEvents = $autoPayEvents;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AutoPayMetaDataResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
