<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountSummaryTransaction Struct
 * @subpackage Structs
 */
class AccountSummaryTransaction extends AbstractStructBase
{
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The EfectiveTransactionDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EfectiveTransactionDate;
    /**
     * The Energy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Energy;
    /**
     * The DailyFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DailyFee;
    /**
     * The StateSurcharge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $StateSurcharge;
    /**
     * The Tax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Tax;
    /**
     * The Total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Total;
    /**
     * Constructor method for AccountSummaryTransaction
     * @uses AccountSummaryTransaction::setAccountID()
     * @uses AccountSummaryTransaction::setEfectiveTransactionDate()
     * @uses AccountSummaryTransaction::setEnergy()
     * @uses AccountSummaryTransaction::setDailyFee()
     * @uses AccountSummaryTransaction::setStateSurcharge()
     * @uses AccountSummaryTransaction::setTax()
     * @uses AccountSummaryTransaction::setTotal()
     * @param int $accountID
     * @param string $efectiveTransactionDate
     * @param float $energy
     * @param float $dailyFee
     * @param float $stateSurcharge
     * @param float $tax
     * @param float $total
     */
    public function __construct($accountID = null, $efectiveTransactionDate = null, $energy = null, $dailyFee = null, $stateSurcharge = null, $tax = null, $total = null)
    {
        $this
            ->setAccountID($accountID)
            ->setEfectiveTransactionDate($efectiveTransactionDate)
            ->setEnergy($energy)
            ->setDailyFee($dailyFee)
            ->setStateSurcharge($stateSurcharge)
            ->setTax($tax)
            ->setTotal($total);
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\AccountSummaryTransaction
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get EfectiveTransactionDate value
     * @return string
     */
    public function getEfectiveTransactionDate()
    {
        return $this->EfectiveTransactionDate;
    }
    /**
     * Set EfectiveTransactionDate value
     * @param string $efectiveTransactionDate
     * @return \SGCIS\Struct\AccountSummaryTransaction
     */
    public function setEfectiveTransactionDate($efectiveTransactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($efectiveTransactionDate) && !is_string($efectiveTransactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($efectiveTransactionDate)), __LINE__);
        }
        $this->EfectiveTransactionDate = $efectiveTransactionDate;
        return $this;
    }
    /**
     * Get Energy value
     * @return float
     */
    public function getEnergy()
    {
        return $this->Energy;
    }
    /**
     * Set Energy value
     * @param float $energy
     * @return \SGCIS\Struct\AccountSummaryTransaction
     */
    public function setEnergy($energy = null)
    {
        $this->Energy = $energy;
        return $this;
    }
    /**
     * Get DailyFee value
     * @return float
     */
    public function getDailyFee()
    {
        return $this->DailyFee;
    }
    /**
     * Set DailyFee value
     * @param float $dailyFee
     * @return \SGCIS\Struct\AccountSummaryTransaction
     */
    public function setDailyFee($dailyFee = null)
    {
        $this->DailyFee = $dailyFee;
        return $this;
    }
    /**
     * Get StateSurcharge value
     * @return float
     */
    public function getStateSurcharge()
    {
        return $this->StateSurcharge;
    }
    /**
     * Set StateSurcharge value
     * @param float $stateSurcharge
     * @return \SGCIS\Struct\AccountSummaryTransaction
     */
    public function setStateSurcharge($stateSurcharge = null)
    {
        $this->StateSurcharge = $stateSurcharge;
        return $this;
    }
    /**
     * Get Tax value
     * @return float
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @param float $tax
     * @return \SGCIS\Struct\AccountSummaryTransaction
     */
    public function setTax($tax = null)
    {
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Get Total value
     * @return float
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param float $total
     * @return \SGCIS\Struct\AccountSummaryTransaction
     */
    public function setTotal($total = null)
    {
        $this->Total = $total;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AccountSummaryTransaction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
