<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountPrevious Struct
 * @subpackage Structs
 */
class AccountPrevious extends AbstractStructBase
{
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The CompanyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CompanyID;
    /**
     * The AccountStartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AccountStartDate;
    /**
     * The AccountEndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AccountEndDate;
    /**
     * The AccountStatusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountStatusID;
    /**
     * The ProductID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductID;
    /**
     * The BalanceOwed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BalanceOwed;
    /**
     * The BadDebtBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BadDebtBalance;
    /**
     * The IsNoPromoAllowed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsNoPromoAllowed;
    /**
     * The IsPostalMailDocDelivery
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPostalMailDocDelivery;
    /**
     * The IsElectronicDocDelivery
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsElectronicDocDelivery;
    /**
     * The SalesForceLeadID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SalesForceLeadID;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The CompanyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompanyName;
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PersonName;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * The AccountStatusName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountStatusName;
    /**
     * The ProductName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductName;
    /**
     * The AccountAccountFlags
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAccountAccountFlag
     */
    public $AccountAccountFlags;
    /**
     * Constructor method for AccountPrevious
     * @uses AccountPrevious::setAccountID()
     * @uses AccountPrevious::setCompanyID()
     * @uses AccountPrevious::setAccountStartDate()
     * @uses AccountPrevious::setAccountEndDate()
     * @uses AccountPrevious::setAccountStatusID()
     * @uses AccountPrevious::setProductID()
     * @uses AccountPrevious::setBalanceOwed()
     * @uses AccountPrevious::setBadDebtBalance()
     * @uses AccountPrevious::setIsNoPromoAllowed()
     * @uses AccountPrevious::setIsPostalMailDocDelivery()
     * @uses AccountPrevious::setIsElectronicDocDelivery()
     * @uses AccountPrevious::setSalesForceLeadID()
     * @uses AccountPrevious::setAccountNumber()
     * @uses AccountPrevious::setCompanyName()
     * @uses AccountPrevious::setPersonName()
     * @uses AccountPrevious::setAddress()
     * @uses AccountPrevious::setAccountStatusName()
     * @uses AccountPrevious::setProductName()
     * @uses AccountPrevious::setAccountAccountFlags()
     * @param int $accountID
     * @param int $companyID
     * @param string $accountStartDate
     * @param string $accountEndDate
     * @param int $accountStatusID
     * @param int $productID
     * @param float $balanceOwed
     * @param float $badDebtBalance
     * @param bool $isNoPromoAllowed
     * @param bool $isPostalMailDocDelivery
     * @param bool $isElectronicDocDelivery
     * @param int $salesForceLeadID
     * @param string $accountNumber
     * @param string $companyName
     * @param string $personName
     * @param string $address
     * @param string $accountStatusName
     * @param string $productName
     * @param \SGCIS\Array\ArrayOfAccountAccountFlag $accountAccountFlags
     */
    public function __construct($accountID = null, $companyID = null, $accountStartDate = null, $accountEndDate = null, $accountStatusID = null, $productID = null, $balanceOwed = null, $badDebtBalance = null, $isNoPromoAllowed = null, $isPostalMailDocDelivery = null, $isElectronicDocDelivery = null, $salesForceLeadID = null, $accountNumber = null, $companyName = null, $personName = null, $address = null, $accountStatusName = null, $productName = null, \SGCIS\Array\ArrayOfAccountAccountFlag $accountAccountFlags = null)
    {
        $this
            ->setAccountID($accountID)
            ->setCompanyID($companyID)
            ->setAccountStartDate($accountStartDate)
            ->setAccountEndDate($accountEndDate)
            ->setAccountStatusID($accountStatusID)
            ->setProductID($productID)
            ->setBalanceOwed($balanceOwed)
            ->setBadDebtBalance($badDebtBalance)
            ->setIsNoPromoAllowed($isNoPromoAllowed)
            ->setIsPostalMailDocDelivery($isPostalMailDocDelivery)
            ->setIsElectronicDocDelivery($isElectronicDocDelivery)
            ->setSalesForceLeadID($salesForceLeadID)
            ->setAccountNumber($accountNumber)
            ->setCompanyName($companyName)
            ->setPersonName($personName)
            ->setAddress($address)
            ->setAccountStatusName($accountStatusName)
            ->setProductName($productName)
            ->setAccountAccountFlags($accountAccountFlags);
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\AccountPrevious
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get CompanyID value
     * @return int
     */
    public function getCompanyID()
    {
        return $this->CompanyID;
    }
    /**
     * Set CompanyID value
     * @param int $companyID
     * @return \SGCIS\Struct\AccountPrevious
     */
    public function setCompanyID($companyID = null)
    {
        // validation for constraint: int
        if (!is_null($companyID) && !is_numeric($companyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($companyID)), __LINE__);
        }
        $this->CompanyID = $companyID;
        return $this;
    }
    /**
     * Get AccountStartDate value
     * @return string
     */
    public function getAccountStartDate()
    {
        return $this->AccountStartDate;
    }
    /**
     * Set AccountStartDate value
     * @param string $accountStartDate
     * @return \SGCIS\Struct\AccountPrevious
     */
    public function setAccountStartDate($accountStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($accountStartDate) && !is_string($accountStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountStartDate)), __LINE__);
        }
        $this->AccountStartDate = $accountStartDate;
        return $this;
    }
    /**
     * Get AccountEndDate value
     * @return string
     */
    public function getAccountEndDate()
    {
        return $this->AccountEndDate;
    }
    /**
     * Set AccountEndDate value
     * @param string $accountEndDate
     * @return \SGCIS\Struct\AccountPrevious
     */
    public function setAccountEndDate($accountEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($accountEndDate) && !is_string($accountEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountEndDate)), __LINE__);
        }
        $this->AccountEndDate = $accountEndDate;
        return $this;
    }
    /**
     * Get AccountStatusID value
     * @return int
     */
    public function getAccountStatusID()
    {
        return $this->AccountStatusID;
    }
    /**
     * Set AccountStatusID value
     * @param int $accountStatusID
     * @return \SGCIS\Struct\AccountPrevious
     */
    public function setAccountStatusID($accountStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($accountStatusID) && !is_numeric($accountStatusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountStatusID)), __LINE__);
        }
        $this->AccountStatusID = $accountStatusID;
        return $this;
    }
    /**
     * Get ProductID value
     * @return int
     */
    public function getProductID()
    {
        return $this->ProductID;
    }
    /**
     * Set ProductID value
     * @param int $productID
     * @return \SGCIS\Struct\AccountPrevious
     */
    public function setProductID($productID = null)
    {
        // validation for constraint: int
        if (!is_null($productID) && !is_numeric($productID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productID)), __LINE__);
        }
        $this->ProductID = $productID;
        return $this;
    }
    /**
     * Get BalanceOwed value
     * @return float
     */
    public function getBalanceOwed()
    {
        return $this->BalanceOwed;
    }
    /**
     * Set BalanceOwed value
     * @param float $balanceOwed
     * @return \SGCIS\Struct\AccountPrevious
     */
    public function setBalanceOwed($balanceOwed = null)
    {
        $this->BalanceOwed = $balanceOwed;
        return $this;
    }
    /**
     * Get BadDebtBalance value
     * @return float
     */
    public function getBadDebtBalance()
    {
        return $this->BadDebtBalance;
    }
    /**
     * Set BadDebtBalance value
     * @param float $badDebtBalance
     * @return \SGCIS\Struct\AccountPrevious
     */
    public function setBadDebtBalance($badDebtBalance = null)
    {
        $this->BadDebtBalance = $badDebtBalance;
        return $this;
    }
    /**
     * Get IsNoPromoAllowed value
     * @return bool
     */
    public function getIsNoPromoAllowed()
    {
        return $this->IsNoPromoAllowed;
    }
    /**
     * Set IsNoPromoAllowed value
     * @param bool $isNoPromoAllowed
     * @return \SGCIS\Struct\AccountPrevious
     */
    public function setIsNoPromoAllowed($isNoPromoAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNoPromoAllowed) && !is_bool($isNoPromoAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isNoPromoAllowed)), __LINE__);
        }
        $this->IsNoPromoAllowed = $isNoPromoAllowed;
        return $this;
    }
    /**
     * Get IsPostalMailDocDelivery value
     * @return bool
     */
    public function getIsPostalMailDocDelivery()
    {
        return $this->IsPostalMailDocDelivery;
    }
    /**
     * Set IsPostalMailDocDelivery value
     * @param bool $isPostalMailDocDelivery
     * @return \SGCIS\Struct\AccountPrevious
     */
    public function setIsPostalMailDocDelivery($isPostalMailDocDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPostalMailDocDelivery) && !is_bool($isPostalMailDocDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPostalMailDocDelivery)), __LINE__);
        }
        $this->IsPostalMailDocDelivery = $isPostalMailDocDelivery;
        return $this;
    }
    /**
     * Get IsElectronicDocDelivery value
     * @return bool
     */
    public function getIsElectronicDocDelivery()
    {
        return $this->IsElectronicDocDelivery;
    }
    /**
     * Set IsElectronicDocDelivery value
     * @param bool $isElectronicDocDelivery
     * @return \SGCIS\Struct\AccountPrevious
     */
    public function setIsElectronicDocDelivery($isElectronicDocDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($isElectronicDocDelivery) && !is_bool($isElectronicDocDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isElectronicDocDelivery)), __LINE__);
        }
        $this->IsElectronicDocDelivery = $isElectronicDocDelivery;
        return $this;
    }
    /**
     * Get SalesForceLeadID value
     * @return int
     */
    public function getSalesForceLeadID()
    {
        return $this->SalesForceLeadID;
    }
    /**
     * Set SalesForceLeadID value
     * @param int $salesForceLeadID
     * @return \SGCIS\Struct\AccountPrevious
     */
    public function setSalesForceLeadID($salesForceLeadID = null)
    {
        // validation for constraint: int
        if (!is_null($salesForceLeadID) && !is_numeric($salesForceLeadID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($salesForceLeadID)), __LINE__);
        }
        $this->SalesForceLeadID = $salesForceLeadID;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \SGCIS\Struct\AccountPrevious
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get CompanyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param string $companyName
     * @return \SGCIS\Struct\AccountPrevious
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get PersonName value
     * @return string|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param string $personName
     * @return \SGCIS\Struct\AccountPrevious
     */
    public function setPersonName($personName = null)
    {
        // validation for constraint: string
        if (!is_null($personName) && !is_string($personName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($personName)), __LINE__);
        }
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \SGCIS\Struct\AccountPrevious
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get AccountStatusName value
     * @return string|null
     */
    public function getAccountStatusName()
    {
        return $this->AccountStatusName;
    }
    /**
     * Set AccountStatusName value
     * @param string $accountStatusName
     * @return \SGCIS\Struct\AccountPrevious
     */
    public function setAccountStatusName($accountStatusName = null)
    {
        // validation for constraint: string
        if (!is_null($accountStatusName) && !is_string($accountStatusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountStatusName)), __LINE__);
        }
        $this->AccountStatusName = $accountStatusName;
        return $this;
    }
    /**
     * Get ProductName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->ProductName;
    }
    /**
     * Set ProductName value
     * @param string $productName
     * @return \SGCIS\Struct\AccountPrevious
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productName)), __LINE__);
        }
        $this->ProductName = $productName;
        return $this;
    }
    /**
     * Get AccountAccountFlags value
     * @return \SGCIS\Array\ArrayOfAccountAccountFlag|null
     */
    public function getAccountAccountFlags()
    {
        return $this->AccountAccountFlags;
    }
    /**
     * Set AccountAccountFlags value
     * @param \SGCIS\Array\ArrayOfAccountAccountFlag $accountAccountFlags
     * @return \SGCIS\Struct\AccountPrevious
     */
    public function setAccountAccountFlags(\SGCIS\Array\ArrayOfAccountAccountFlag $accountAccountFlags = null)
    {
        $this->AccountAccountFlags = $accountAccountFlags;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AccountPrevious
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
