<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountCommunication Struct
 * @subpackage Structs
 */
class AccountCommunication extends AbstractStructBase
{
    /**
     * The AccountCommunicationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountCommunicationID;
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The CommunicationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CommunicationDate;
    /**
     * The NotificationChannelID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NotificationChannelID;
    /**
     * The CreatedByUserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CreatedByUserID;
    /**
     * The SystemEventID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SystemEventID;
    /**
     * The IsHtml
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsHtml;
    /**
     * The NotificationTemplateID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NotificationTemplateID;
    /**
     * The ServiceOrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServiceOrderID;
    /**
     * The CommunicationText
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CommunicationText;
    /**
     * The CommunicationRichText
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CommunicationRichText;
    /**
     * The CommunicationTypeText
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CommunicationTypeText;
    /**
     * The Recipient
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Recipient;
    /**
     * The CcRecipient
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CcRecipient;
    /**
     * The UserNotes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserNotes;
    /**
     * The CommunicationSubject
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CommunicationSubject;
    /**
     * The CommItemID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CommItemID;
    /**
     * The NotificationTemplateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NotificationTemplateName;
    /**
     * The NotificationChannelName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NotificationChannelName;
    /**
     * The CreatedByUserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreatedByUserName;
    /**
     * The MailFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MailFrom;
    /**
     * The MailTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MailTo;
    /**
     * The Subject
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Subject;
    /**
     * The AttachedFiles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAttachedFile
     */
    public $AttachedFiles;
    /**
     * The MessageID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MessageID;
    /**
     * The MessageStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MessageStatus;
    /**
     * The MessageErrorCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MessageErrorCode;
    /**
     * Constructor method for AccountCommunication
     * @uses AccountCommunication::setAccountCommunicationID()
     * @uses AccountCommunication::setAccountID()
     * @uses AccountCommunication::setCommunicationDate()
     * @uses AccountCommunication::setNotificationChannelID()
     * @uses AccountCommunication::setCreatedByUserID()
     * @uses AccountCommunication::setSystemEventID()
     * @uses AccountCommunication::setIsHtml()
     * @uses AccountCommunication::setNotificationTemplateID()
     * @uses AccountCommunication::setServiceOrderID()
     * @uses AccountCommunication::setCommunicationText()
     * @uses AccountCommunication::setCommunicationRichText()
     * @uses AccountCommunication::setCommunicationTypeText()
     * @uses AccountCommunication::setRecipient()
     * @uses AccountCommunication::setCcRecipient()
     * @uses AccountCommunication::setUserNotes()
     * @uses AccountCommunication::setCommunicationSubject()
     * @uses AccountCommunication::setCommItemID()
     * @uses AccountCommunication::setNotificationTemplateName()
     * @uses AccountCommunication::setNotificationChannelName()
     * @uses AccountCommunication::setCreatedByUserName()
     * @uses AccountCommunication::setMailFrom()
     * @uses AccountCommunication::setMailTo()
     * @uses AccountCommunication::setSubject()
     * @uses AccountCommunication::setAttachedFiles()
     * @uses AccountCommunication::setMessageID()
     * @uses AccountCommunication::setMessageStatus()
     * @uses AccountCommunication::setMessageErrorCode()
     * @param int $accountCommunicationID
     * @param int $accountID
     * @param string $communicationDate
     * @param int $notificationChannelID
     * @param int $createdByUserID
     * @param int $systemEventID
     * @param bool $isHtml
     * @param int $notificationTemplateID
     * @param int $serviceOrderID
     * @param string $communicationText
     * @param string $communicationRichText
     * @param string $communicationTypeText
     * @param string $recipient
     * @param string $ccRecipient
     * @param string $userNotes
     * @param string $communicationSubject
     * @param string $commItemID
     * @param string $notificationTemplateName
     * @param string $notificationChannelName
     * @param string $createdByUserName
     * @param string $mailFrom
     * @param string $mailTo
     * @param string $subject
     * @param \SGCIS\Array\ArrayOfAttachedFile $attachedFiles
     * @param string $messageID
     * @param string $messageStatus
     * @param string $messageErrorCode
     */
    public function __construct($accountCommunicationID = null, $accountID = null, $communicationDate = null, $notificationChannelID = null, $createdByUserID = null, $systemEventID = null, $isHtml = null, $notificationTemplateID = null, $serviceOrderID = null, $communicationText = null, $communicationRichText = null, $communicationTypeText = null, $recipient = null, $ccRecipient = null, $userNotes = null, $communicationSubject = null, $commItemID = null, $notificationTemplateName = null, $notificationChannelName = null, $createdByUserName = null, $mailFrom = null, $mailTo = null, $subject = null, \SGCIS\Array\ArrayOfAttachedFile $attachedFiles = null, $messageID = null, $messageStatus = null, $messageErrorCode = null)
    {
        $this
            ->setAccountCommunicationID($accountCommunicationID)
            ->setAccountID($accountID)
            ->setCommunicationDate($communicationDate)
            ->setNotificationChannelID($notificationChannelID)
            ->setCreatedByUserID($createdByUserID)
            ->setSystemEventID($systemEventID)
            ->setIsHtml($isHtml)
            ->setNotificationTemplateID($notificationTemplateID)
            ->setServiceOrderID($serviceOrderID)
            ->setCommunicationText($communicationText)
            ->setCommunicationRichText($communicationRichText)
            ->setCommunicationTypeText($communicationTypeText)
            ->setRecipient($recipient)
            ->setCcRecipient($ccRecipient)
            ->setUserNotes($userNotes)
            ->setCommunicationSubject($communicationSubject)
            ->setCommItemID($commItemID)
            ->setNotificationTemplateName($notificationTemplateName)
            ->setNotificationChannelName($notificationChannelName)
            ->setCreatedByUserName($createdByUserName)
            ->setMailFrom($mailFrom)
            ->setMailTo($mailTo)
            ->setSubject($subject)
            ->setAttachedFiles($attachedFiles)
            ->setMessageID($messageID)
            ->setMessageStatus($messageStatus)
            ->setMessageErrorCode($messageErrorCode);
    }
    /**
     * Get AccountCommunicationID value
     * @return int
     */
    public function getAccountCommunicationID()
    {
        return $this->AccountCommunicationID;
    }
    /**
     * Set AccountCommunicationID value
     * @param int $accountCommunicationID
     * @return \SGCIS\Struct\AccountCommunication
     */
    public function setAccountCommunicationID($accountCommunicationID = null)
    {
        // validation for constraint: int
        if (!is_null($accountCommunicationID) && !is_numeric($accountCommunicationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountCommunicationID)), __LINE__);
        }
        $this->AccountCommunicationID = $accountCommunicationID;
        return $this;
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\AccountCommunication
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get CommunicationDate value
     * @return string
     */
    public function getCommunicationDate()
    {
        return $this->CommunicationDate;
    }
    /**
     * Set CommunicationDate value
     * @param string $communicationDate
     * @return \SGCIS\Struct\AccountCommunication
     */
    public function setCommunicationDate($communicationDate = null)
    {
        // validation for constraint: string
        if (!is_null($communicationDate) && !is_string($communicationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($communicationDate)), __LINE__);
        }
        $this->CommunicationDate = $communicationDate;
        return $this;
    }
    /**
     * Get NotificationChannelID value
     * @return int
     */
    public function getNotificationChannelID()
    {
        return $this->NotificationChannelID;
    }
    /**
     * Set NotificationChannelID value
     * @param int $notificationChannelID
     * @return \SGCIS\Struct\AccountCommunication
     */
    public function setNotificationChannelID($notificationChannelID = null)
    {
        // validation for constraint: int
        if (!is_null($notificationChannelID) && !is_numeric($notificationChannelID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($notificationChannelID)), __LINE__);
        }
        $this->NotificationChannelID = $notificationChannelID;
        return $this;
    }
    /**
     * Get CreatedByUserID value
     * @return int
     */
    public function getCreatedByUserID()
    {
        return $this->CreatedByUserID;
    }
    /**
     * Set CreatedByUserID value
     * @param int $createdByUserID
     * @return \SGCIS\Struct\AccountCommunication
     */
    public function setCreatedByUserID($createdByUserID = null)
    {
        // validation for constraint: int
        if (!is_null($createdByUserID) && !is_numeric($createdByUserID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($createdByUserID)), __LINE__);
        }
        $this->CreatedByUserID = $createdByUserID;
        return $this;
    }
    /**
     * Get SystemEventID value
     * @return int
     */
    public function getSystemEventID()
    {
        return $this->SystemEventID;
    }
    /**
     * Set SystemEventID value
     * @param int $systemEventID
     * @return \SGCIS\Struct\AccountCommunication
     */
    public function setSystemEventID($systemEventID = null)
    {
        // validation for constraint: int
        if (!is_null($systemEventID) && !is_numeric($systemEventID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($systemEventID)), __LINE__);
        }
        $this->SystemEventID = $systemEventID;
        return $this;
    }
    /**
     * Get IsHtml value
     * @return bool
     */
    public function getIsHtml()
    {
        return $this->IsHtml;
    }
    /**
     * Set IsHtml value
     * @param bool $isHtml
     * @return \SGCIS\Struct\AccountCommunication
     */
    public function setIsHtml($isHtml = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHtml) && !is_bool($isHtml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isHtml)), __LINE__);
        }
        $this->IsHtml = $isHtml;
        return $this;
    }
    /**
     * Get NotificationTemplateID value
     * @return int
     */
    public function getNotificationTemplateID()
    {
        return $this->NotificationTemplateID;
    }
    /**
     * Set NotificationTemplateID value
     * @param int $notificationTemplateID
     * @return \SGCIS\Struct\AccountCommunication
     */
    public function setNotificationTemplateID($notificationTemplateID = null)
    {
        // validation for constraint: int
        if (!is_null($notificationTemplateID) && !is_numeric($notificationTemplateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($notificationTemplateID)), __LINE__);
        }
        $this->NotificationTemplateID = $notificationTemplateID;
        return $this;
    }
    /**
     * Get ServiceOrderID value
     * @return int
     */
    public function getServiceOrderID()
    {
        return $this->ServiceOrderID;
    }
    /**
     * Set ServiceOrderID value
     * @param int $serviceOrderID
     * @return \SGCIS\Struct\AccountCommunication
     */
    public function setServiceOrderID($serviceOrderID = null)
    {
        // validation for constraint: int
        if (!is_null($serviceOrderID) && !is_numeric($serviceOrderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serviceOrderID)), __LINE__);
        }
        $this->ServiceOrderID = $serviceOrderID;
        return $this;
    }
    /**
     * Get CommunicationText value
     * @return string|null
     */
    public function getCommunicationText()
    {
        return $this->CommunicationText;
    }
    /**
     * Set CommunicationText value
     * @param string $communicationText
     * @return \SGCIS\Struct\AccountCommunication
     */
    public function setCommunicationText($communicationText = null)
    {
        // validation for constraint: string
        if (!is_null($communicationText) && !is_string($communicationText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($communicationText)), __LINE__);
        }
        $this->CommunicationText = $communicationText;
        return $this;
    }
    /**
     * Get CommunicationRichText value
     * @return string|null
     */
    public function getCommunicationRichText()
    {
        return $this->CommunicationRichText;
    }
    /**
     * Set CommunicationRichText value
     * @param string $communicationRichText
     * @return \SGCIS\Struct\AccountCommunication
     */
    public function setCommunicationRichText($communicationRichText = null)
    {
        // validation for constraint: string
        if (!is_null($communicationRichText) && !is_string($communicationRichText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($communicationRichText)), __LINE__);
        }
        $this->CommunicationRichText = $communicationRichText;
        return $this;
    }
    /**
     * Get CommunicationTypeText value
     * @return string|null
     */
    public function getCommunicationTypeText()
    {
        return $this->CommunicationTypeText;
    }
    /**
     * Set CommunicationTypeText value
     * @param string $communicationTypeText
     * @return \SGCIS\Struct\AccountCommunication
     */
    public function setCommunicationTypeText($communicationTypeText = null)
    {
        // validation for constraint: string
        if (!is_null($communicationTypeText) && !is_string($communicationTypeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($communicationTypeText)), __LINE__);
        }
        $this->CommunicationTypeText = $communicationTypeText;
        return $this;
    }
    /**
     * Get Recipient value
     * @return string|null
     */
    public function getRecipient()
    {
        return $this->Recipient;
    }
    /**
     * Set Recipient value
     * @param string $recipient
     * @return \SGCIS\Struct\AccountCommunication
     */
    public function setRecipient($recipient = null)
    {
        // validation for constraint: string
        if (!is_null($recipient) && !is_string($recipient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recipient)), __LINE__);
        }
        $this->Recipient = $recipient;
        return $this;
    }
    /**
     * Get CcRecipient value
     * @return string|null
     */
    public function getCcRecipient()
    {
        return $this->CcRecipient;
    }
    /**
     * Set CcRecipient value
     * @param string $ccRecipient
     * @return \SGCIS\Struct\AccountCommunication
     */
    public function setCcRecipient($ccRecipient = null)
    {
        // validation for constraint: string
        if (!is_null($ccRecipient) && !is_string($ccRecipient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ccRecipient)), __LINE__);
        }
        $this->CcRecipient = $ccRecipient;
        return $this;
    }
    /**
     * Get UserNotes value
     * @return string|null
     */
    public function getUserNotes()
    {
        return $this->UserNotes;
    }
    /**
     * Set UserNotes value
     * @param string $userNotes
     * @return \SGCIS\Struct\AccountCommunication
     */
    public function setUserNotes($userNotes = null)
    {
        // validation for constraint: string
        if (!is_null($userNotes) && !is_string($userNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userNotes)), __LINE__);
        }
        $this->UserNotes = $userNotes;
        return $this;
    }
    /**
     * Get CommunicationSubject value
     * @return string|null
     */
    public function getCommunicationSubject()
    {
        return $this->CommunicationSubject;
    }
    /**
     * Set CommunicationSubject value
     * @param string $communicationSubject
     * @return \SGCIS\Struct\AccountCommunication
     */
    public function setCommunicationSubject($communicationSubject = null)
    {
        // validation for constraint: string
        if (!is_null($communicationSubject) && !is_string($communicationSubject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($communicationSubject)), __LINE__);
        }
        $this->CommunicationSubject = $communicationSubject;
        return $this;
    }
    /**
     * Get CommItemID value
     * @return string|null
     */
    public function getCommItemID()
    {
        return $this->CommItemID;
    }
    /**
     * Set CommItemID value
     * @param string $commItemID
     * @return \SGCIS\Struct\AccountCommunication
     */
    public function setCommItemID($commItemID = null)
    {
        // validation for constraint: string
        if (!is_null($commItemID) && !is_string($commItemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($commItemID)), __LINE__);
        }
        $this->CommItemID = $commItemID;
        return $this;
    }
    /**
     * Get NotificationTemplateName value
     * @return string|null
     */
    public function getNotificationTemplateName()
    {
        return $this->NotificationTemplateName;
    }
    /**
     * Set NotificationTemplateName value
     * @param string $notificationTemplateName
     * @return \SGCIS\Struct\AccountCommunication
     */
    public function setNotificationTemplateName($notificationTemplateName = null)
    {
        // validation for constraint: string
        if (!is_null($notificationTemplateName) && !is_string($notificationTemplateName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notificationTemplateName)), __LINE__);
        }
        $this->NotificationTemplateName = $notificationTemplateName;
        return $this;
    }
    /**
     * Get NotificationChannelName value
     * @return string|null
     */
    public function getNotificationChannelName()
    {
        return $this->NotificationChannelName;
    }
    /**
     * Set NotificationChannelName value
     * @param string $notificationChannelName
     * @return \SGCIS\Struct\AccountCommunication
     */
    public function setNotificationChannelName($notificationChannelName = null)
    {
        // validation for constraint: string
        if (!is_null($notificationChannelName) && !is_string($notificationChannelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notificationChannelName)), __LINE__);
        }
        $this->NotificationChannelName = $notificationChannelName;
        return $this;
    }
    /**
     * Get CreatedByUserName value
     * @return string|null
     */
    public function getCreatedByUserName()
    {
        return $this->CreatedByUserName;
    }
    /**
     * Set CreatedByUserName value
     * @param string $createdByUserName
     * @return \SGCIS\Struct\AccountCommunication
     */
    public function setCreatedByUserName($createdByUserName = null)
    {
        // validation for constraint: string
        if (!is_null($createdByUserName) && !is_string($createdByUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createdByUserName)), __LINE__);
        }
        $this->CreatedByUserName = $createdByUserName;
        return $this;
    }
    /**
     * Get MailFrom value
     * @return string|null
     */
    public function getMailFrom()
    {
        return $this->MailFrom;
    }
    /**
     * Set MailFrom value
     * @param string $mailFrom
     * @return \SGCIS\Struct\AccountCommunication
     */
    public function setMailFrom($mailFrom = null)
    {
        // validation for constraint: string
        if (!is_null($mailFrom) && !is_string($mailFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailFrom)), __LINE__);
        }
        $this->MailFrom = $mailFrom;
        return $this;
    }
    /**
     * Get MailTo value
     * @return string|null
     */
    public function getMailTo()
    {
        return $this->MailTo;
    }
    /**
     * Set MailTo value
     * @param string $mailTo
     * @return \SGCIS\Struct\AccountCommunication
     */
    public function setMailTo($mailTo = null)
    {
        // validation for constraint: string
        if (!is_null($mailTo) && !is_string($mailTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailTo)), __LINE__);
        }
        $this->MailTo = $mailTo;
        return $this;
    }
    /**
     * Get Subject value
     * @return string|null
     */
    public function getSubject()
    {
        return $this->Subject;
    }
    /**
     * Set Subject value
     * @param string $subject
     * @return \SGCIS\Struct\AccountCommunication
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subject)), __LINE__);
        }
        $this->Subject = $subject;
        return $this;
    }
    /**
     * Get AttachedFiles value
     * @return \SGCIS\Array\ArrayOfAttachedFile|null
     */
    public function getAttachedFiles()
    {
        return $this->AttachedFiles;
    }
    /**
     * Set AttachedFiles value
     * @param \SGCIS\Array\ArrayOfAttachedFile $attachedFiles
     * @return \SGCIS\Struct\AccountCommunication
     */
    public function setAttachedFiles(\SGCIS\Array\ArrayOfAttachedFile $attachedFiles = null)
    {
        $this->AttachedFiles = $attachedFiles;
        return $this;
    }
    /**
     * Get MessageID value
     * @return string|null
     */
    public function getMessageID()
    {
        return $this->MessageID;
    }
    /**
     * Set MessageID value
     * @param string $messageID
     * @return \SGCIS\Struct\AccountCommunication
     */
    public function setMessageID($messageID = null)
    {
        // validation for constraint: string
        if (!is_null($messageID) && !is_string($messageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageID)), __LINE__);
        }
        $this->MessageID = $messageID;
        return $this;
    }
    /**
     * Get MessageStatus value
     * @return string|null
     */
    public function getMessageStatus()
    {
        return $this->MessageStatus;
    }
    /**
     * Set MessageStatus value
     * @param string $messageStatus
     * @return \SGCIS\Struct\AccountCommunication
     */
    public function setMessageStatus($messageStatus = null)
    {
        // validation for constraint: string
        if (!is_null($messageStatus) && !is_string($messageStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageStatus)), __LINE__);
        }
        $this->MessageStatus = $messageStatus;
        return $this;
    }
    /**
     * Get MessageErrorCode value
     * @return string|null
     */
    public function getMessageErrorCode()
    {
        return $this->MessageErrorCode;
    }
    /**
     * Set MessageErrorCode value
     * @param string $messageErrorCode
     * @return \SGCIS\Struct\AccountCommunication
     */
    public function setMessageErrorCode($messageErrorCode = null)
    {
        // validation for constraint: string
        if (!is_null($messageErrorCode) && !is_string($messageErrorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageErrorCode)), __LINE__);
        }
        $this->MessageErrorCode = $messageErrorCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\AccountCommunication
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
