<?php

namespace SGCIS\Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Save Service
 * @subpackage Services
 */
class Save extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SaveAutoPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\SaveAutoPayment $parameters
     * @return \SGCIS\Struct\SaveAutoPaymentResponse|bool
     */
    public function SaveAutoPayment(\SGCIS\Struct\SaveAutoPayment $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SaveAutoPayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SavePaymentAccount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\SavePaymentAccount $parameters
     * @return \SGCIS\Struct\SavePaymentAccountResponse|bool
     */
    public function SavePaymentAccount(\SGCIS\Struct\SavePaymentAccount $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SavePaymentAccount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveAccountCustomFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\SaveAccountCustomFields $parameters
     * @return \SGCIS\Struct\SaveAccountCustomFieldsResponse|bool
     */
    public function SaveAccountCustomFields(\SGCIS\Struct\SaveAccountCustomFields $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SaveAccountCustomFields($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \SGCIS\Struct\SaveAccountCustomFieldsResponse|\SGCIS\Struct\SaveAutoPaymentResponse|\SGCIS\Struct\SavePaymentAccountResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
