<?php

namespace SGCIS\Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get Service
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetAccountShallowCopy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetAccountShallowCopy $parameters
     * @return \SGCIS\Struct\GetAccountShallowCopyResponse|bool
     */
    public function GetAccountShallowCopy(\SGCIS\Struct\GetAccountShallowCopy $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAccountShallowCopy($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserAgentCodeByAgentID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetUserAgentCodeByAgentID $parameters
     * @return \SGCIS\Struct\GetUserAgentCodeByAgentIDResponse|bool
     */
    public function GetUserAgentCodeByAgentID(\SGCIS\Struct\GetUserAgentCodeByAgentID $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUserAgentCodeByAgentID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAccountDocuments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetAccountDocuments $parameters
     * @return \SGCIS\Struct\GetAccountDocumentsResponse|bool
     */
    public function GetAccountDocuments(\SGCIS\Struct\GetAccountDocuments $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAccountDocuments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAccountDocumentTypes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetAccountDocumentTypes $parameters
     * @return \SGCIS\Struct\GetAccountDocumentTypesResponse|bool
     */
    public function GetAccountDocumentTypes(\SGCIS\Struct\GetAccountDocumentTypes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAccountDocumentTypes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAccountIVR
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetAccountIVR $parameters
     * @return \SGCIS\Struct\GetAccountIVRResponse|bool
     */
    public function GetAccountIVR(\SGCIS\Struct\GetAccountIVR $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAccountIVR($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProductsByZipCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetProductsByZipCode $parameters
     * @return \SGCIS\Struct\GetProductsByZipCodeResponse|bool
     */
    public function GetProductsByZipCode(\SGCIS\Struct\GetProductsByZipCode $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetProductsByZipCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProducts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetProducts $parameters
     * @return \SGCIS\Struct\GetProductsResponse|bool
     */
    public function GetProducts(\SGCIS\Struct\GetProducts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetProducts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDistributionPoints
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetDistributionPoints $parameters
     * @return \SGCIS\Struct\GetDistributionPointsResponse|bool
     */
    public function GetDistributionPoints(\SGCIS\Struct\GetDistributionPoints $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDistributionPoints($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAccountActivityMobile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetAccountActivityMobile $parameters
     * @return \SGCIS\Struct\GetAccountActivityMobileResponse|bool
     */
    public function GetAccountActivityMobile(\SGCIS\Struct\GetAccountActivityMobile $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAccountActivityMobile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAutoPayMetaData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetAutoPayMetaData $parameters
     * @return \SGCIS\Struct\GetAutoPayMetaDataResponse|bool
     */
    public function GetAutoPayMetaData(\SGCIS\Struct\GetAutoPayMetaData $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAutoPayMetaData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProductDeepCopy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetProductDeepCopy $parameters
     * @return \SGCIS\Struct\GetProductDeepCopyResponse|bool
     */
    public function GetProductDeepCopy(\SGCIS\Struct\GetProductDeepCopy $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetProductDeepCopy($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPaymentLocations
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetPaymentLocations $parameters
     * @return \SGCIS\Struct\GetPaymentLocationsResponse|bool
     */
    public function GetPaymentLocations(\SGCIS\Struct\GetPaymentLocations $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPaymentLocations($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAccountActivity
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetAccountActivity $parameters
     * @return \SGCIS\Struct\GetAccountActivityResponse|bool
     */
    public function GetAccountActivity(\SGCIS\Struct\GetAccountActivity $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAccountActivity($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAccount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetAccount $parameters
     * @return \SGCIS\Struct\GetAccountResponse|bool
     */
    public function GetAccount(\SGCIS\Struct\GetAccount $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAccount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUspAccount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetUspAccount $parameters
     * @return \SGCIS\Struct\GetUspAccountResponse|bool
     */
    public function GetUspAccount(\SGCIS\Struct\GetUspAccount $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUspAccount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFees
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetFees $parameters
     * @return \SGCIS\Struct\GetFeesResponse|bool
     */
    public function GetFees(\SGCIS\Struct\GetFees $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetFees($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPaymentArrangements
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetPaymentArrangements $parameters
     * @return \SGCIS\Struct\GetPaymentArrangementsResponse|bool
     */
    public function GetPaymentArrangements(\SGCIS\Struct\GetPaymentArrangements $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPaymentArrangements($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPaymentArrangement
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetPaymentArrangement $parameters
     * @return \SGCIS\Struct\GetPaymentArrangementResponse|bool
     */
    public function GetPaymentArrangement(\SGCIS\Struct\GetPaymentArrangement $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPaymentArrangement($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPaymentAccounts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetPaymentAccounts $parameters
     * @return \SGCIS\Struct\GetPaymentAccountsResponse|bool
     */
    public function GetPaymentAccounts(\SGCIS\Struct\GetPaymentAccounts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPaymentAccounts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAccountAutopayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetAccountAutopayment $parameters
     * @return \SGCIS\Struct\GetAccountAutopaymentResponse|bool
     */
    public function GetAccountAutopayment(\SGCIS\Struct\GetAccountAutopayment $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAccountAutopayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDataLists
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetDataLists $parameters
     * @return \SGCIS\Struct\GetDataListsResponse|bool
     */
    public function GetDataLists(\SGCIS\Struct\GetDataLists $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDataLists($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDataList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetDataList $parameters
     * @return \SGCIS\Struct\GetDataListResponse|bool
     */
    public function GetDataList(\SGCIS\Struct\GetDataList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDataList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSystemProperty
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetSystemProperty $parameters
     * @return \SGCIS\Struct\GetSystemPropertyResponse|bool
     */
    public function GetSystemProperty(\SGCIS\Struct\GetSystemProperty $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSystemProperty($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCurrentBill
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetCurrentBill $parameters
     * @return \SGCIS\Struct\GetCurrentBillResponse|bool
     */
    public function GetCurrentBill(\SGCIS\Struct\GetCurrentBill $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCurrentBill($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBillHistory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetBillHistory $parameters
     * @return \SGCIS\Struct\GetBillHistoryResponse|bool
     */
    public function GetBillHistory(\SGCIS\Struct\GetBillHistory $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetBillHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetWebProducts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetWebProducts $parameters
     * @return \SGCIS\Struct\GetWebProductsResponse|bool
     */
    public function GetWebProducts(\SGCIS\Struct\GetWebProducts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetWebProducts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAccountTransactionSummary
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetAccountTransactionSummary $parameters
     * @return \SGCIS\Struct\GetAccountTransactionSummaryResponse|bool
     */
    public function GetAccountTransactionSummary(\SGCIS\Struct\GetAccountTransactionSummary $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAccountTransactionSummary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetCustomFields $parameters
     * @return \SGCIS\Struct\GetCustomFieldsResponse|bool
     */
    public function GetCustomFields(\SGCIS\Struct\GetCustomFields $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomFields($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAccountCustomFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetAccountCustomFields $parameters
     * @return \SGCIS\Struct\GetAccountCustomFieldsResponse|bool
     */
    public function GetAccountCustomFields(\SGCIS\Struct\GetAccountCustomFields $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAccountCustomFields($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserCharacteristics
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetUserCharacteristics $parameters
     * @return \SGCIS\Struct\GetUserCharacteristicsResponse|bool
     */
    public function GetUserCharacteristics(\SGCIS\Struct\GetUserCharacteristics $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUserCharacteristics($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetZipCodeWeather
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\GetZipCodeWeather $parameters
     * @return \SGCIS\Struct\GetZipCodeWeatherResponse|bool
     */
    public function GetZipCodeWeather(\SGCIS\Struct\GetZipCodeWeather $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetZipCodeWeather($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \SGCIS\Struct\GetAccountActivityMobileResponse|\SGCIS\Struct\GetAccountActivityResponse|\SGCIS\Struct\GetAccountAutopaymentResponse|\SGCIS\Struct\GetAccountCustomFieldsResponse|\SGCIS\Struct\GetAccountDocumentsResponse|\SGCIS\Struct\GetAccountDocumentTypesResponse|\SGCIS\Struct\GetAccountIVRResponse|\SGCIS\Struct\GetAccountResponse|\SGCIS\Struct\GetAccountShallowCopyResponse|\SGCIS\Struct\GetAccountTransactionSummaryResponse|\SGCIS\Struct\GetAutoPayMetaDataResponse|\SGCIS\Struct\GetBillHistoryResponse|\SGCIS\Struct\GetCurrentBillResponse|\SGCIS\Struct\GetCustomFieldsResponse|\SGCIS\Struct\GetDataListResponse|\SGCIS\Struct\GetDataListsResponse|\SGCIS\Struct\GetDistributionPointsResponse|\SGCIS\Struct\GetFeesResponse|\SGCIS\Struct\GetPaymentAccountsResponse|\SGCIS\Struct\GetPaymentArrangementResponse|\SGCIS\Struct\GetPaymentArrangementsResponse|\SGCIS\Struct\GetPaymentLocationsResponse|\SGCIS\Struct\GetProductDeepCopyResponse|\SGCIS\Struct\GetProductsByZipCodeResponse|\SGCIS\Struct\GetProductsResponse|\SGCIS\Struct\GetSystemPropertyResponse|\SGCIS\Struct\GetUserAgentCodeByAgentIDResponse|\SGCIS\Struct\GetUserCharacteristicsResponse|\SGCIS\Struct\GetUspAccountResponse|\SGCIS\Struct\GetWebProductsResponse|\SGCIS\Struct\GetZipCodeWeatherResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
