<?php

namespace SGCIS\Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for External Service
 * @subpackage Services
 */
class External extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ExternalAuthenticateUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\ExternalAuthenticateUser $parameters
     * @return \SGCIS\Struct\ExternalAuthenticateUserResponse|bool
     */
    public function ExternalAuthenticateUser(\SGCIS\Struct\ExternalAuthenticateUser $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExternalAuthenticateUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExternalRecoverPassword
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SGCIS\Struct\ExternalRecoverPassword $parameters
     * @return \SGCIS\Struct\ExternalRecoverPasswordResponse|bool
     */
    public function ExternalRecoverPassword(\SGCIS\Struct\ExternalRecoverPassword $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExternalRecoverPassword($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \SGCIS\Struct\ExternalAuthenticateUserResponse|\SGCIS\Struct\ExternalRecoverPasswordResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
