<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfServicePointMeterGroup Array
 * @subpackage Arrays
 */
class ArrayOfServicePointMeterGroup extends AbstractStructArrayBase
{
    /**
     * The ServicePointMeterGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\ServicePointMeterGroup[]
     */
    public $ServicePointMeterGroup;
    /**
     * Constructor method for ArrayOfServicePointMeterGroup
     * @uses ArrayOfServicePointMeterGroup::setServicePointMeterGroup()
     * @param \SGCIS\Struct\ServicePointMeterGroup[] $servicePointMeterGroup
     */
    public function __construct(array $servicePointMeterGroup = array())
    {
        $this
            ->setServicePointMeterGroup($servicePointMeterGroup);
    }
    /**
     * Get ServicePointMeterGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\ServicePointMeterGroup[]|null
     */
    public function getServicePointMeterGroup()
    {
        return isset($this->ServicePointMeterGroup) ? $this->ServicePointMeterGroup : null;
    }
    /**
     * Set ServicePointMeterGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\ServicePointMeterGroup[] $servicePointMeterGroup
     * @return \SGCIS\Array\ArrayOfServicePointMeterGroup
     */
    public function setServicePointMeterGroup(array $servicePointMeterGroup = array())
    {
        foreach ($servicePointMeterGroup as $arrayOfServicePointMeterGroupServicePointMeterGroupItem) {
            // validation for constraint: itemType
            if (!$arrayOfServicePointMeterGroupServicePointMeterGroupItem instanceof \SGCIS\Struct\ServicePointMeterGroup) {
                throw new \InvalidArgumentException(sprintf('The ServicePointMeterGroup property can only contain items of \SGCIS\Struct\ServicePointMeterGroup, "%s" given', is_object($arrayOfServicePointMeterGroupServicePointMeterGroupItem) ? get_class($arrayOfServicePointMeterGroupServicePointMeterGroupItem) : gettype($arrayOfServicePointMeterGroupServicePointMeterGroupItem)), __LINE__);
            }
        }
        if (is_null($servicePointMeterGroup) || (is_array($servicePointMeterGroup) && empty($servicePointMeterGroup))) {
            unset($this->ServicePointMeterGroup);
        } else {
            $this->ServicePointMeterGroup = $servicePointMeterGroup;
        }
        return $this;
    }
    /**
     * Add item to ServicePointMeterGroup value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\ServicePointMeterGroup $item
     * @return \SGCIS\Array\ArrayOfServicePointMeterGroup
     */
    public function addToServicePointMeterGroup(\SGCIS\Struct\ServicePointMeterGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\ServicePointMeterGroup) {
            throw new \InvalidArgumentException(sprintf('The ServicePointMeterGroup property can only contain items of \SGCIS\Struct\ServicePointMeterGroup, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ServicePointMeterGroup[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\ServicePointMeterGroup|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\ServicePointMeterGroup|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\ServicePointMeterGroup|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\ServicePointMeterGroup|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\ServicePointMeterGroup|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ServicePointMeterGroup
     */
    public function getAttributeName()
    {
        return 'ServicePointMeterGroup';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfServicePointMeterGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
