<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProductAvgPrice Array
 * @subpackage Arrays
 */
class ArrayOfProductAvgPrice extends AbstractStructArrayBase
{
    /**
     * The ProductAvgPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\ProductAvgPrice[]
     */
    public $ProductAvgPrice;
    /**
     * Constructor method for ArrayOfProductAvgPrice
     * @uses ArrayOfProductAvgPrice::setProductAvgPrice()
     * @param \SGCIS\Struct\ProductAvgPrice[] $productAvgPrice
     */
    public function __construct(array $productAvgPrice = array())
    {
        $this
            ->setProductAvgPrice($productAvgPrice);
    }
    /**
     * Get ProductAvgPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\ProductAvgPrice[]|null
     */
    public function getProductAvgPrice()
    {
        return isset($this->ProductAvgPrice) ? $this->ProductAvgPrice : null;
    }
    /**
     * Set ProductAvgPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\ProductAvgPrice[] $productAvgPrice
     * @return \SGCIS\Array\ArrayOfProductAvgPrice
     */
    public function setProductAvgPrice(array $productAvgPrice = array())
    {
        foreach ($productAvgPrice as $arrayOfProductAvgPriceProductAvgPriceItem) {
            // validation for constraint: itemType
            if (!$arrayOfProductAvgPriceProductAvgPriceItem instanceof \SGCIS\Struct\ProductAvgPrice) {
                throw new \InvalidArgumentException(sprintf('The ProductAvgPrice property can only contain items of \SGCIS\Struct\ProductAvgPrice, "%s" given', is_object($arrayOfProductAvgPriceProductAvgPriceItem) ? get_class($arrayOfProductAvgPriceProductAvgPriceItem) : gettype($arrayOfProductAvgPriceProductAvgPriceItem)), __LINE__);
            }
        }
        if (is_null($productAvgPrice) || (is_array($productAvgPrice) && empty($productAvgPrice))) {
            unset($this->ProductAvgPrice);
        } else {
            $this->ProductAvgPrice = $productAvgPrice;
        }
        return $this;
    }
    /**
     * Add item to ProductAvgPrice value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\ProductAvgPrice $item
     * @return \SGCIS\Array\ArrayOfProductAvgPrice
     */
    public function addToProductAvgPrice(\SGCIS\Struct\ProductAvgPrice $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\ProductAvgPrice) {
            throw new \InvalidArgumentException(sprintf('The ProductAvgPrice property can only contain items of \SGCIS\Struct\ProductAvgPrice, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ProductAvgPrice[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\ProductAvgPrice|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\ProductAvgPrice|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\ProductAvgPrice|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\ProductAvgPrice|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\ProductAvgPrice|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProductAvgPrice
     */
    public function getAttributeName()
    {
        return 'ProductAvgPrice';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfProductAvgPrice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
