<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPaymentArrangementSchedule Array
 * @subpackage Arrays
 */
class ArrayOfPaymentArrangementSchedule extends AbstractStructArrayBase
{
    /**
     * The PaymentArrangementSchedule
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\PaymentArrangementSchedule[]
     */
    public $PaymentArrangementSchedule;
    /**
     * Constructor method for ArrayOfPaymentArrangementSchedule
     * @uses ArrayOfPaymentArrangementSchedule::setPaymentArrangementSchedule()
     * @param \SGCIS\Struct\PaymentArrangementSchedule[] $paymentArrangementSchedule
     */
    public function __construct(array $paymentArrangementSchedule = array())
    {
        $this
            ->setPaymentArrangementSchedule($paymentArrangementSchedule);
    }
    /**
     * Get PaymentArrangementSchedule value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\PaymentArrangementSchedule[]|null
     */
    public function getPaymentArrangementSchedule()
    {
        return isset($this->PaymentArrangementSchedule) ? $this->PaymentArrangementSchedule : null;
    }
    /**
     * Set PaymentArrangementSchedule value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\PaymentArrangementSchedule[] $paymentArrangementSchedule
     * @return \SGCIS\Array\ArrayOfPaymentArrangementSchedule
     */
    public function setPaymentArrangementSchedule(array $paymentArrangementSchedule = array())
    {
        foreach ($paymentArrangementSchedule as $arrayOfPaymentArrangementSchedulePaymentArrangementScheduleItem) {
            // validation for constraint: itemType
            if (!$arrayOfPaymentArrangementSchedulePaymentArrangementScheduleItem instanceof \SGCIS\Struct\PaymentArrangementSchedule) {
                throw new \InvalidArgumentException(sprintf('The PaymentArrangementSchedule property can only contain items of \SGCIS\Struct\PaymentArrangementSchedule, "%s" given', is_object($arrayOfPaymentArrangementSchedulePaymentArrangementScheduleItem) ? get_class($arrayOfPaymentArrangementSchedulePaymentArrangementScheduleItem) : gettype($arrayOfPaymentArrangementSchedulePaymentArrangementScheduleItem)), __LINE__);
            }
        }
        if (is_null($paymentArrangementSchedule) || (is_array($paymentArrangementSchedule) && empty($paymentArrangementSchedule))) {
            unset($this->PaymentArrangementSchedule);
        } else {
            $this->PaymentArrangementSchedule = $paymentArrangementSchedule;
        }
        return $this;
    }
    /**
     * Add item to PaymentArrangementSchedule value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\PaymentArrangementSchedule $item
     * @return \SGCIS\Array\ArrayOfPaymentArrangementSchedule
     */
    public function addToPaymentArrangementSchedule(\SGCIS\Struct\PaymentArrangementSchedule $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\PaymentArrangementSchedule) {
            throw new \InvalidArgumentException(sprintf('The PaymentArrangementSchedule property can only contain items of \SGCIS\Struct\PaymentArrangementSchedule, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentArrangementSchedule[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\PaymentArrangementSchedule|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\PaymentArrangementSchedule|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\PaymentArrangementSchedule|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\PaymentArrangementSchedule|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\PaymentArrangementSchedule|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PaymentArrangementSchedule
     */
    public function getAttributeName()
    {
        return 'PaymentArrangementSchedule';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfPaymentArrangementSchedule
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
