<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfNotificationChannel Array
 * @subpackage Arrays
 */
class ArrayOfNotificationChannel extends AbstractStructArrayBase
{
    /**
     * The NotificationChannel
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\NotificationChannel[]
     */
    public $NotificationChannel;
    /**
     * Constructor method for ArrayOfNotificationChannel
     * @uses ArrayOfNotificationChannel::setNotificationChannel()
     * @param \SGCIS\Struct\NotificationChannel[] $notificationChannel
     */
    public function __construct(array $notificationChannel = array())
    {
        $this
            ->setNotificationChannel($notificationChannel);
    }
    /**
     * Get NotificationChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\NotificationChannel[]|null
     */
    public function getNotificationChannel()
    {
        return isset($this->NotificationChannel) ? $this->NotificationChannel : null;
    }
    /**
     * Set NotificationChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\NotificationChannel[] $notificationChannel
     * @return \SGCIS\Array\ArrayOfNotificationChannel
     */
    public function setNotificationChannel(array $notificationChannel = array())
    {
        foreach ($notificationChannel as $arrayOfNotificationChannelNotificationChannelItem) {
            // validation for constraint: itemType
            if (!$arrayOfNotificationChannelNotificationChannelItem instanceof \SGCIS\Struct\NotificationChannel) {
                throw new \InvalidArgumentException(sprintf('The NotificationChannel property can only contain items of \SGCIS\Struct\NotificationChannel, "%s" given', is_object($arrayOfNotificationChannelNotificationChannelItem) ? get_class($arrayOfNotificationChannelNotificationChannelItem) : gettype($arrayOfNotificationChannelNotificationChannelItem)), __LINE__);
            }
        }
        if (is_null($notificationChannel) || (is_array($notificationChannel) && empty($notificationChannel))) {
            unset($this->NotificationChannel);
        } else {
            $this->NotificationChannel = $notificationChannel;
        }
        return $this;
    }
    /**
     * Add item to NotificationChannel value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\NotificationChannel $item
     * @return \SGCIS\Array\ArrayOfNotificationChannel
     */
    public function addToNotificationChannel(\SGCIS\Struct\NotificationChannel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\NotificationChannel) {
            throw new \InvalidArgumentException(sprintf('The NotificationChannel property can only contain items of \SGCIS\Struct\NotificationChannel, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NotificationChannel[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\NotificationChannel|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\NotificationChannel|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\NotificationChannel|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\NotificationChannel|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\NotificationChannel|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string NotificationChannel
     */
    public function getAttributeName()
    {
        return 'NotificationChannel';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfNotificationChannel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
