<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfFeeEvent Array
 * @subpackage Arrays
 */
class ArrayOfFeeEvent extends AbstractStructArrayBase
{
    /**
     * The FeeEvent
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\FeeEvent[]
     */
    public $FeeEvent;
    /**
     * Constructor method for ArrayOfFeeEvent
     * @uses ArrayOfFeeEvent::setFeeEvent()
     * @param \SGCIS\Struct\FeeEvent[] $feeEvent
     */
    public function __construct(array $feeEvent = array())
    {
        $this
            ->setFeeEvent($feeEvent);
    }
    /**
     * Get FeeEvent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\FeeEvent[]|null
     */
    public function getFeeEvent()
    {
        return isset($this->FeeEvent) ? $this->FeeEvent : null;
    }
    /**
     * Set FeeEvent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\FeeEvent[] $feeEvent
     * @return \SGCIS\Array\ArrayOfFeeEvent
     */
    public function setFeeEvent(array $feeEvent = array())
    {
        foreach ($feeEvent as $arrayOfFeeEventFeeEventItem) {
            // validation for constraint: itemType
            if (!$arrayOfFeeEventFeeEventItem instanceof \SGCIS\Struct\FeeEvent) {
                throw new \InvalidArgumentException(sprintf('The FeeEvent property can only contain items of \SGCIS\Struct\FeeEvent, "%s" given', is_object($arrayOfFeeEventFeeEventItem) ? get_class($arrayOfFeeEventFeeEventItem) : gettype($arrayOfFeeEventFeeEventItem)), __LINE__);
            }
        }
        if (is_null($feeEvent) || (is_array($feeEvent) && empty($feeEvent))) {
            unset($this->FeeEvent);
        } else {
            $this->FeeEvent = $feeEvent;
        }
        return $this;
    }
    /**
     * Add item to FeeEvent value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\FeeEvent $item
     * @return \SGCIS\Array\ArrayOfFeeEvent
     */
    public function addToFeeEvent(\SGCIS\Struct\FeeEvent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\FeeEvent) {
            throw new \InvalidArgumentException(sprintf('The FeeEvent property can only contain items of \SGCIS\Struct\FeeEvent, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FeeEvent[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\FeeEvent|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\FeeEvent|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\FeeEvent|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\FeeEvent|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\FeeEvent|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string FeeEvent
     */
    public function getAttributeName()
    {
        return 'FeeEvent';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfFeeEvent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
