<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEDIBill Array
 * @subpackage Arrays
 */
class ArrayOfEDIBill extends AbstractStructArrayBase
{
    /**
     * The EDIBill
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\EDIBill[]
     */
    public $EDIBill;
    /**
     * Constructor method for ArrayOfEDIBill
     * @uses ArrayOfEDIBill::setEDIBill()
     * @param \SGCIS\Struct\EDIBill[] $eDIBill
     */
    public function __construct(array $eDIBill = array())
    {
        $this
            ->setEDIBill($eDIBill);
    }
    /**
     * Get EDIBill value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\EDIBill[]|null
     */
    public function getEDIBill()
    {
        return isset($this->EDIBill) ? $this->EDIBill : null;
    }
    /**
     * Set EDIBill value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\EDIBill[] $eDIBill
     * @return \SGCIS\Array\ArrayOfEDIBill
     */
    public function setEDIBill(array $eDIBill = array())
    {
        foreach ($eDIBill as $arrayOfEDIBillEDIBillItem) {
            // validation for constraint: itemType
            if (!$arrayOfEDIBillEDIBillItem instanceof \SGCIS\Struct\EDIBill) {
                throw new \InvalidArgumentException(sprintf('The EDIBill property can only contain items of \SGCIS\Struct\EDIBill, "%s" given', is_object($arrayOfEDIBillEDIBillItem) ? get_class($arrayOfEDIBillEDIBillItem) : gettype($arrayOfEDIBillEDIBillItem)), __LINE__);
            }
        }
        if (is_null($eDIBill) || (is_array($eDIBill) && empty($eDIBill))) {
            unset($this->EDIBill);
        } else {
            $this->EDIBill = $eDIBill;
        }
        return $this;
    }
    /**
     * Add item to EDIBill value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\EDIBill $item
     * @return \SGCIS\Array\ArrayOfEDIBill
     */
    public function addToEDIBill(\SGCIS\Struct\EDIBill $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\EDIBill) {
            throw new \InvalidArgumentException(sprintf('The EDIBill property can only contain items of \SGCIS\Struct\EDIBill, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EDIBill[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\EDIBill|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\EDIBill|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\EDIBill|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\EDIBill|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\EDIBill|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EDIBill
     */
    public function getAttributeName()
    {
        return 'EDIBill';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfEDIBill
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
