<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomField Array
 * @subpackage Arrays
 */
class ArrayOfCustomField extends AbstractStructArrayBase
{
    /**
     * The CustomField
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\CustomField[]
     */
    public $CustomField;
    /**
     * Constructor method for ArrayOfCustomField
     * @uses ArrayOfCustomField::setCustomField()
     * @param \SGCIS\Struct\CustomField[] $customField
     */
    public function __construct(array $customField = array())
    {
        $this
            ->setCustomField($customField);
    }
    /**
     * Get CustomField value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\CustomField[]|null
     */
    public function getCustomField()
    {
        return isset($this->CustomField) ? $this->CustomField : null;
    }
    /**
     * Set CustomField value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\CustomField[] $customField
     * @return \SGCIS\Array\ArrayOfCustomField
     */
    public function setCustomField(array $customField = array())
    {
        foreach ($customField as $arrayOfCustomFieldCustomFieldItem) {
            // validation for constraint: itemType
            if (!$arrayOfCustomFieldCustomFieldItem instanceof \SGCIS\Struct\CustomField) {
                throw new \InvalidArgumentException(sprintf('The CustomField property can only contain items of \SGCIS\Struct\CustomField, "%s" given', is_object($arrayOfCustomFieldCustomFieldItem) ? get_class($arrayOfCustomFieldCustomFieldItem) : gettype($arrayOfCustomFieldCustomFieldItem)), __LINE__);
            }
        }
        if (is_null($customField) || (is_array($customField) && empty($customField))) {
            unset($this->CustomField);
        } else {
            $this->CustomField = $customField;
        }
        return $this;
    }
    /**
     * Add item to CustomField value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\CustomField $item
     * @return \SGCIS\Array\ArrayOfCustomField
     */
    public function addToCustomField(\SGCIS\Struct\CustomField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\CustomField) {
            throw new \InvalidArgumentException(sprintf('The CustomField property can only contain items of \SGCIS\Struct\CustomField, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustomField[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\CustomField|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\CustomField|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\CustomField|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\CustomField|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\CustomField|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomField
     */
    public function getAttributeName()
    {
        return 'CustomField';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfCustomField
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
