<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCCHGroupTaxDetail Array
 * @subpackage Arrays
 */
class ArrayOfCCHGroupTaxDetail extends AbstractStructArrayBase
{
    /**
     * The CCHGroupTaxDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\CCHGroupTaxDetail[]
     */
    public $CCHGroupTaxDetail;
    /**
     * Constructor method for ArrayOfCCHGroupTaxDetail
     * @uses ArrayOfCCHGroupTaxDetail::setCCHGroupTaxDetail()
     * @param \SGCIS\Struct\CCHGroupTaxDetail[] $cCHGroupTaxDetail
     */
    public function __construct(array $cCHGroupTaxDetail = array())
    {
        $this
            ->setCCHGroupTaxDetail($cCHGroupTaxDetail);
    }
    /**
     * Get CCHGroupTaxDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\CCHGroupTaxDetail[]|null
     */
    public function getCCHGroupTaxDetail()
    {
        return isset($this->CCHGroupTaxDetail) ? $this->CCHGroupTaxDetail : null;
    }
    /**
     * Set CCHGroupTaxDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\CCHGroupTaxDetail[] $cCHGroupTaxDetail
     * @return \SGCIS\Array\ArrayOfCCHGroupTaxDetail
     */
    public function setCCHGroupTaxDetail(array $cCHGroupTaxDetail = array())
    {
        foreach ($cCHGroupTaxDetail as $arrayOfCCHGroupTaxDetailCCHGroupTaxDetailItem) {
            // validation for constraint: itemType
            if (!$arrayOfCCHGroupTaxDetailCCHGroupTaxDetailItem instanceof \SGCIS\Struct\CCHGroupTaxDetail) {
                throw new \InvalidArgumentException(sprintf('The CCHGroupTaxDetail property can only contain items of \SGCIS\Struct\CCHGroupTaxDetail, "%s" given', is_object($arrayOfCCHGroupTaxDetailCCHGroupTaxDetailItem) ? get_class($arrayOfCCHGroupTaxDetailCCHGroupTaxDetailItem) : gettype($arrayOfCCHGroupTaxDetailCCHGroupTaxDetailItem)), __LINE__);
            }
        }
        if (is_null($cCHGroupTaxDetail) || (is_array($cCHGroupTaxDetail) && empty($cCHGroupTaxDetail))) {
            unset($this->CCHGroupTaxDetail);
        } else {
            $this->CCHGroupTaxDetail = $cCHGroupTaxDetail;
        }
        return $this;
    }
    /**
     * Add item to CCHGroupTaxDetail value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\CCHGroupTaxDetail $item
     * @return \SGCIS\Array\ArrayOfCCHGroupTaxDetail
     */
    public function addToCCHGroupTaxDetail(\SGCIS\Struct\CCHGroupTaxDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\CCHGroupTaxDetail) {
            throw new \InvalidArgumentException(sprintf('The CCHGroupTaxDetail property can only contain items of \SGCIS\Struct\CCHGroupTaxDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CCHGroupTaxDetail[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\CCHGroupTaxDetail|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\CCHGroupTaxDetail|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\CCHGroupTaxDetail|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\CCHGroupTaxDetail|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\CCHGroupTaxDetail|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CCHGroupTaxDetail
     */
    public function getAttributeName()
    {
        return 'CCHGroupTaxDetail';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfCCHGroupTaxDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
